











                                     Install-Pro







                                     User's Guide

                                         and

                                   Reference Manual








                       Copyright 1991, 1992 DB/Soft Publishing.
                                 All rights reserved.








                                Printed in the U.S.A.

                             Version 2.00, first printing







          Copyright

          This software is protected under  United States Copyright Law and
          International Treaty provisions.  DB/Soft Publishing reserves all
          rights to Install-Pro except for the following:

          A limited license is hereby granted allowing you use and evaluate
          Install-Pro  for  up  to  30  days.    You  may  also  distribute
          unregistered copies of Install-Pro in its entirety to any parties
          interested provided no modification of the files in the  Install-
          Pro archive occurs.   The maximum transaction related to  selling
          media containing unregistered copies of Install-Pro (eg Shareware
          vendors)  may not exceed $10.00.  Conversion to a more convenient
          archive format is allowed.  All other uses of Install-Pro violate
          this license and are hereby expressly disallowed.

                     Copyright 1991-1992, by DB/Soft Publishing,
                                 All Rights Reserved.

                    3200 Truxel Rd #199, Sacramento, CA 95833 USA

                              Telephone: (916) 927-6951

                                 BBS: (916) 927-2349

          Limited Warranty

          DB/Soft Publishing  grants no warranties, express  or implied, by
          statute  or otherwise,  regarding this  software and  its related
          materials, their fitness for any purpose, their quality, or their
          merchantibility.  In  no way shall  DB/Soft Publishing be  liable
          for  any  special, consequential,  other  damages  for breach  of
          warranty.

          This Statement  shall be  construed, interpreted and  governed by
          the laws of the State of California.

          This  warranty will be replaced by a limited 90-day warranty that
          covers the diskette, software and documentation upon registration
          of Install-Pro.   Further, the limited  license will be  replaced
          with a license that  allows royalty-free distribution of Install-
          Pro with your applications.







          Registering Install-Pro

          Install-Pro  is  an  example   of  software  marketed  under  the
          Shareware  concept.   The premise  is simple:   you  may evaluate
          Install-Pro for  a reasonable period  of time  (30 days  maximum)
          during which you decide if it is a program worth owning and using
          for  installing  your applications.    If so,  you  must register
          Install-Pro, using order.doc for ordering information.  If, after
          a  reasonable  evaluation  period,  you decide  not  to  register
          Install-Pro, you then must discontinue its use.

          This provides  me with  a way to  market software  with very  low
          advertising  overhead, which  results in  a price  savings passed
          directly on to you.  And, it provides you with a chance to 'play'
          with my product and decide if it meets your needs. 

          As  an  incentive to  speed  the  registration process,  a  minor
          modification  to Install-Pro  processing occurs in  the Shareware
          version.  Instead of displaying your opening screen(s), an  order
          information notice is displayed instead.  Thus, HELLO, HELLOBREAK
          and BANNER commands have no effect.   Also, you may disregard the
          section of  the documentation relating to  AUTHORIZATION keys, as
          no authorizing is necessary  with unregistered copies of Install-
          Pro.  Other than  these two modifications, all features  that are
          included in  the registered version of  Install-Pro are available
          here.


          Getting Help_____________________________________________________

          There are several ways of contacting the author, Jeff Dunlop, for
          technical assistance if you get stuck.  From cheapest and slowest
          to most expensive and fastest:

               - Fidonet's SHAREWRE echo

               - ILink's Shareware conference

               - Fidonet netmail at 1:203/16

               - The DB/Soft Online at (916) 927-2349

          The best method of  contacting the author depends on the  type of
          assistance you need.   If it's a rather complicated  problem, you
          will probably be far  better served if  you prepare a message  in
          advance and  upload it with the script in question to the DB/Soft
          Online.  We can then test it and offer suggestions.  If it's just
          a  question  or  suggestion about  Install-Pro  capabilities, the







          ILink  or Fidonet  conferences will work  best.   Fidonet netmail
          privileges can be difficult  to get, but offer excellent  timeli-
          ness at very low connect  time.  Check your local Fidonet  BBS if
          interested.







                                  Table of Contents


               Chapter 1 Introduction .................................. 1
                    Features ........................................... 1
                    Requirements ....................................... 3
                    Getting Started .................................... 4

               Chapter 2 Creating the screens .......................... 5
                    BANNER ............................................. 5
                    HELLO .............................................. 6
                    HELLOBREAK ......................................... 6
                    GOODBYE ............................................ 6
                    GOODBYEBREAK ....................................... 7

               Chapter 3 Building the entry forms ...................... 8
                    USER ............................................... 8

               Chapter 4 Transferring files ........................... 11
                    SUBDIR ............................................ 11
                    FILE .............................................. 12
                    Splitting Files ................................... 13
                    UNZIP ............................................. 15

               Chapter 5 Changing Disks and Terminating ............... 17
                    FIRSTDISK ......................................... 17
                    DISK .............................................. 17
                    END ............................................... 17
                    CHAIN ............................................. 18

               Chapter 6 Verifying the target environment ............. 19
                    SPACE ............................................. 19
                    CPU ............................................... 19
                    FPU ............................................... 19
                    RAM ............................................... 19
                    VER ............................................... 20
                    CONFIGFILES ....................................... 20
                    PATH .............................................. 21

               Chapter 7 Running external programs .................... 22
                    RUN ............................................... 22

               Chapter 8 Customizing Install-Pro ...................... 25
                    ONERROR ........................................... 25 
                    Linking external text ............................. 25


                                          1







                                  Table of Contents

               Chapter 9 Miscellaneous ................................ 27
                    Error Messages .................................... 27
                    Critical Errors ................................... 31
                    Authorization Keys ................................ 31









































                                          2








          Chapter 1


          Introduction_____________________________________________________

          Install-Pro is the flexible and affordable solution to the common
          problem of transferring an application or information base from
          distribution media to its destination directories.  Typically,
          the options have been to write a batch file, to write a custom
          program or to shell out hundreds of dollars for an anemic
          installation utility.  Until Install-Pro.

          Install-Pro is a script driven professional installation program
          that will automate the installation process while providing your
          customers with a crisp, easy-to-use interface.  Unlike other
          script-driven installation utilities, Install-Pro is heavy on
          features, intelligent in its operation, and light on resource
          requirements.  Any application can be ready to install to
          multiple directories from  multiple disks in a matter of minutes.
          A brief list of features includes:

               -    Professional  look   and  feel  for   a  better   first
                    impression.
               
               -    You  customize multiple  welcome  screens and  good-bye
                    screens to your own needs. 

               -    Up to 999 installation disks and unlimited installation
                    files.

               -    Comprehensive environment  detection, including minimum
                    CPU, floating point  processor, installed RAM, and  MS-
                    Dos version.
            
               -    Intelligent FILES= update for Config.sys.

               -    Equally intelligent PATH update for Autoexec.bat
            
               -    All   Install-Pro  text   strings  may   be  optionally
                    redefined via an external file.

               -    Files may be split  into up to 9 pieces for  huge files
                    spanning multiple disks.
            
               -    Files  in  the  .zip  format  may  be  extracted.   All
                    directories  stored  in a  .zip file  are automatically
                    created.
            

                                          1







                               Chapter 1, Introduction
          
                                                                           
                    

               -    You define the directory prompts that the user sees.

               -    You define the default destination directories that the
                    user sees.
            
               -    You optionally define the installation disk names (such
                    as "Utilities Disk" or "Install Disk")
            
               -    You  optionally  specify  the  disk  space requirements
                    associated  with  all  portions  of  the  installation,
                    including  optional portions.  (The user  is given  the
                    option to try to continue with installation if short on
                    disk space.)
            
               -    Up to 8 user-defined destination directories.
            
               -    Unlimited programmer-defined directories child to user-
                    defined directories. 
            
               -    Each  destination directory  may  either be  optionally
                    locked or the user may be allowed to change it.
            
               -    "Run"  commands  allow  your  installation  to  include
                    custom auxiliary  programs or batch  files to  complete
                    special tasks. The installation  diskette directory(s),
                    any  of  the user-defined  directories,  and any  other
                    arguments you  choose can be specified  anywhere on the
                    command line.
            
               -    Portions  of  an  installation   may  be  specified  as
                    optional,  prompting  the  user  whether  the  optional
                    portion should be installed.
            
               -    Multi-Module installations handled seamlessly.
            
               -    Files may be automatically overwritten, prompted before
                    overwriting   a  newer   file,   or   prompted   before
                    overwriting any file.
            
               -    Supports VGA/EGA 50/43 line text modes if detected.
            
               -    Robust  error  handling,  including  a  custom critical
                    error handler that won't scare the  dickens out of your

          2




                               Chapter 1, Introduction
          
                                                                           
                    

                    users, and including  descriptive fatal error  messages
                    (no "error  14 at xxxx:yyyy" found in this program!)


          Requirements_____________________________________________________

          Install-Pro runs under PC-DOS and MS-DOS versions 3.0 and  above.
          A minimum  of 200K  of RAM  memory is required.   More  memory is
          desirable if  external programs are  run from Install-Pro,  or if
          large scripts are processed.

          There is virtually no limit to the size of script files.

          Script  preparation will  require  a text  editor  that does  not
          insert formatting codes into the text.
































                                                                          3




                               Chapter 1, Introduction
          
                                                                           
                    

          Getting Started__________________________________________________

          Before you can really  build an installation script, you  need an
          application that needs to  be installed.  Gather enough  disks to
          hold  your installation,  format  them if  needed,  and copy  the
          application files  over to the disks.   Record what files  are on
          which disks for later  reference, and while you're at  it, record
          the order that  the disks are to be installed.   Included on your
          Install-Pro  disk  are two  files to  aid  you in  recording this
          information.  They  are named  MASTER.DOC and  DISKWKS.DOC.   For
          each installation  you should print  out one copy  of MASTER.DOC,
          and  a copy of DISKWKS.DOC  for every disk  in your installation.
          If you'll  be installing your application  from compressed files,
          then  you want to compress your files before transferring them to
          diskettes.

          If you have  huge files that will need to  be split onto multiple
          disks, you may want to take a  peek at the seperate documentation
          for split.exe.   All that you  really need to know  is that split
          will  split filename.ext  into filename.ex1,  filename.ex2, etc.,
          and that  filename.ex1 must  not be copied  to a  higher-numbered
          disk than filename.ex2.

          Once you have a good  idea of what files need to  be transferred,
          then you're ready to start planning your installation.






















          4




          Chapter 2

          Creating the Opening and Closing screens_________________________

          All commands that define the opening screen(s), BANNER, HELLO and
          HELLOBREAK,  must appear in a file named INSTALL.001 on the first
          diskette of your installation set.  These commands usually appear
          at the top of INSTALL.001.

          The format of the opening screen is similar to the following:


         
         Ŀ
         Welcome to the Install-Pro Installation Program 
         ٱ
         
         
         
         
         Ŀ
          This program is going to transfer the Install-Pro files from   
          the installation diskette to the directory(s) that you enter   
          on the screen to follow.                                       
                                                                         
                           Press a key to continue.                      
         ٱ
         


          The top message that you see is created with the  BANNER command.
          The  bottom message is created  with a series  of HELLO commands.
          If multiple  HELLO screens are  defined, then each  keypress will
          display the following screen until all have been shown.


          BANNER___________________________________________________________

          Syntax:  BANNER "Any text enclosed in quotes"
            
          The BANNER command identifies the line of text to be shown to the
          user as  the  program name  on  the opening  screen.   Up  to  71
          characters are allowed, and a box surrounding the text auto-sizes
          for  a  neat appearance.   If  the  particular text  used creates
          unbalanced sides, insert  an extra  space on the  errant side  to
          even things out.
            
          If quotes are  omitted, only the first word  after BANNER will be
          detected. If  no text is detected after  BANNER, Install-Pro will
          abort with an error  message.  The BANNER command must be defined
          in install.001 to have any effect.
            

                                                                          5




                           Chapter 2, Creating the screens
          


          HELLO____________________________________________________________

          Syntax:  HELLO  "Any text enclosed in quotes"
            
          The HELLO  command identifies a line  of text to be  shown to the
          user on the welcome screen.   Each line may have a maximum length
          of  71  characters.   Characters  in  excess  of  71 are  ignored
          (truncated.)  All  of the HELLO text  lines are displayed in  the
          order  detected in  a  single window,  which automatically  sizes
          itself  to the length and  height of the  combined HELLO display.
          If  you want  empty lines included,  indicate this with  a set of
          empty quotes ("").
            
          Up to 13 HELLO lines will fit  on a single screen.  If more  than
          13  HELLO lines  are defined  without any  intervening HELLOBREAK
          commands  (described  below),   the  subsequent  lines   will  be
          displayed on the  next screen.  Any number of HELLO screens (each
          autosizing, with  a capacity of  up to  13 lines) can  be defined
          within the confines of available memory.
            

          HELLOBREAK_______________________________________________________

          Syntax:  HELLOBREAK
            
          This  command signifies that the following HELLO command is to be
          displayed  on  a  new screen.    Use  this  if you  have  special
          formatting needs that require fewer than 13 lines to a screen.

          The format of the closing screen is similar to the following:

                   
                   Ŀ
                    The installation has completed normally.   
                                                               
                             Press a key to exit...            
                   ٱ
                   

          This  message that  you  see here  is created  with  a series  of
          GOODBYE  commands.   If multiple-screen  messages are  necessary,
          they can be seperated if needed with GOODBYEBREAK commands.


          GOODBYE__________________________________________________________
            
          Syntax: GOODBYE "So-long text goes here"

          6




                           Chapter 2, Creating the screens
          


            
          This  command  is  used to  build  an  end-of-install message  to
          display   to   your   users   after  successful   completion   of
          installation.  It can be  up to 71 characters long, and  like the
          HELLO  lines, the  GOODBYE text  is displayed  in  an auto-sizing
          window.   If you want to  specify an empty line,  use GOODBYE "".
          Somewhere near the bottom of the GOODBYE text, you should include
          something to the effect that a keypress will exit the program.
            
          Any  number  of GOODBYE  lines can  be  defined, anywhere  in the
          script  file(s). After  14  GOODBYE lines  have been  encountered
          without an intervening GOODBYEBREAK command (described  below), a
          page break is automatically inserted by Install-Pro.
            
          When  an install.??? file is processed that is terminated with an
          END  command, after all  transfers have taken  place, the GOODBYE
          messages are displayed, after which the program terminates.  

          The only event that can occur that  will cause the closing screen
          to not  be displayed is if  you choose to terminate  with a CHAIN
          command,  which would load a new installation.  In this instance,
          the closing  screen defined with the  last installation processed
          would be the one displayed.
            

          GOODBYEBREAK_____________________________________________________
            
          Syntax: GOODBYEBREAK
            
          This command tells Install-Pro that the next GOODBYE line defined
          in the script is to appear at the top of a new page.

















                                                                          7




          Chapter 3

          Building the Entry Forms_________________________________________

           
           Ŀ
                        Optional Installation Selection               
           ٱ
           
           
           Ŀ
           Please press your spacebar to check any of these optional  
           installation segments that you wish to include.            
                                                                      
                      ( ) Sample Files                                
                                                                      
           ٱ
           

      
      Ŀ
           Destination Directory Entry       
      ٱ
      
      
      
      
      
      
      
      Ŀ
                                                                           
      Program Files            C:\INSTPRO\                                 
      Document Files           C:\INSTPRO\                                 
      Sample Files             C:\INSTPRO\SAMPLE\                          
                                                                           
      ٱ
      


          The  USER  command,  which  is  used  to  build  the  Destination
          Directory Entry  form   (and its accompanying  Optional Selection
          form)  must appear in Install.001  on the first  diskette of your
          installation set.

            
          USER_____________________________________________________________
            
          Syntax:   [OPTION]  USER  <label>  "prompt"  [default  directory]
          [NOMOD]



          8




                         Chapter 3, Building the Entry Forms
          

          This command  is the  workhorse of  Install-Pro.  It  is used  to
          assign a  prompt and  a default  destination to  a label that  is
          specified by you, as well as specify if the files associated with
          it are to overwrite existing  targets.  When the user inputs  his
          destination directory it will be associated with this label name.
          This command also creates the workspace inside Install-Pro needed
          for FILE, RUN and SUBDIR commands to function.

          A discussion of each component of the USER command follows:
            

          [OPTION]
            
          Before  he is shown  the destination directory  Entry Screen, all
          OPTION  USER lines will be resolved by  a form similar to the top
          form shown above.  This form allows  the user to toggle on or off
          any or all of the optional portions of your installation.

          To give  the user the chance  to not install an  unneeded part of
          your application (tutorials, etc.) you only need to prefix a USER
          command with OPTION.  


          <label>:

          The  label portion of  the USER  command is  nothing more  than a
          tagname to assign to the information stored by this command.   In
          some  of  the  other commands  you  will  want  to refer  to  the
          destination directory  that this  command creates, but  you won't
          know  if that directory will have been  changed by the user.  So,
          we refer  to it  with a  label instead.   Common labels  might be
          prog_files, help_files, etc.


          "prompt"

          In the  above form, "Program Files", "Sample Files" and "Document
          Files" were the prompt portions of the USER commands that created
          the  form.   Each line  of the  Destination Directory  Entry form
          consists of a prompt and its corresponding entry field.  


          [default directory]

          If  you want  the user to  be presented with  a default directory
          when the  Destination Directory Entry form is displayed, then you
          can do so.  It  must be in the form of a legal DOS  path.  In the
          above form, the default directories were  C:\INSTPRO  (twice) and

                                                                          9




                         Chapter 3, Building the Entry Forms
          

          C:\INSTPRO\SAMPLE.   A default  directory is optional  unless you
          want to specify a NOMOD directory (described next).


          [NOMOD]

          Sometimes, you are going to want a specific directory path not to
          be  changed by the user  during installation.   For instance, you
          may  want  a \SYS  directory to  exist  on the  installation hard
          drive.   NOMOD makes this possible.  If you tack NOMOD on the end
          of a USER command, the entry form displays "The directory portion
          of this field  cannot be  changed" whenever the  user is  editing
          this USER entry.   Since it is not possible to know ahead of time
          what drive letters a  target computer will have available,  it is
          not allowed to freeze the destination drive, only the destination
          directory.

































          10




          Chapter 4

          Transferring and decompressing files_____________________________


          SUBDIR___________________________________________________________
            
          Syntax: SUBDIR <label_name> <dirname>
            
          When you define an entry form with USER commands, the directories
          that the  user enters during the  installation will automatically
          be created by Install-Pro.  However, if you have directories that
          you want created child to the user-defined directories, you build
          them  with SUBDIR commands.  The components of the SUBDIR command
          are now discussed:


          <label_name>:
            
          The label name  specified here MUST have  been previously defined
          with a USER command.  The subdirectory will be created as a child
          to  the directory  entered by the  user on  the line  of the form
          associated with this label.


          <dirname>:
            
          This  is the name of the child  subdirectory.  It does not matter
          how long  it is (as long  as the total directory  length is below
          the DOS maximum of 65 characters) or how  many directories are in
          the chain.  That is, \SUB1\SUB2\SUB3 is a legal directory name if
          you wanted a  long chain  created child to  a main  subdirectory.
          There is no requirement that the directory(s) begin or end with a
          backslash.

          SUBDIR lines may exist anywhere in any install.??? file, but must
          precede the  first use  of its  created directory or  Install-Pro
          will be unable to continue.

          Example 1:
            
          USER label_1 "Data Files" C:\MYAPP\DATA
          SUBDIR label_1 \MOREDATA
            
          If  the user  accepted the  default, the  C:\MYAPP\DATA directory
          would  be created.   Also, as  a result  of the  SUBDIR line, the
          C:\MYAPP\DATA\MOREDATA directory would be created.
            
            
          Example 2:
            
          USER label_1 "Data Files" C:\MYAPP\DATA

                                                                         11




                            Chapter 4, Transferring Files
          

          SUBDIR label_1 \DATA1\DATA2\DATA3
            
          If the user  accepted the default  above, C:\MYAPP\DATA would  be
          first created,  and then the -entire-  chain of DATA1\DATA2\DATA3
          would be created as a child.  The resultant chain would thus be
            
          C:\MYAPP\DATA\DATA1\DATA2\DATA3
            
          CAUTION:  The DOS limit for subdirectory length is 65 characters,
          including drive and colon.  Keep in mind the maximum user-entered
          directory is up to 40 characters, leaving you up to 24 characters
          with any margin of safety.   If the total exceeds  65 characters,
          DOS returns a directory creation error.
            

          FILE_____________________________________________________________

          Syntax: FILE <label_name> <filename> [UPGRADE or VERIFY]

          This  command  transfers a  file  from  the current  installation
          diskette to the directory  associated with labelname.   Since the
          file must be on the current diskette, this command must appear in
          the script on the  same diskette.   Thus, if you  want a file  on
          diskette  #2 to be transferred,  the FILE command  must appear in
          install.002 on that diskette.  The components of FILE are:

            
          <label_name>:
            
          The  label  name specified  here MUST  already have  been created
          with a USER command.  This determines the destination directory.


          <filename>:
            
          The  filespec can  take one  of two  forms.  First,  it can  be a
          regular dos filename, in which case it will be transferred to the
          directory associated with the specified label.  Alternatively, it
          can include an  optional directory chain  child to the  directory
          associated with the  specified label,  in which case  it will  be
          transferred to that child directory.  For that child directory to
          exist,  it  must first  be  created a  SUBDIR  command, described
          previously. 


          [UPGRADE]:
            


          12




                            Chapter 4, Transferring Files
          

          This  modifier indicates that any files newer than the file being
          transferred  are to be overwritten only with permission  from the
          user.  Therefore the  user's machine must have a  functional (and
          accurate) clock.


          [VERIFY]:
            
          This modifier directs Install-Pro  to verify all file overwrites,
          even if the file being overwritten is older than the installation
          file.


          Example:
           
          USER label_1 "Data Files" C:\DATA
          FILE label_1 main.exe
          FILE label_1 main2.exe
            
          This script would  transfer main.exe and main2.exe  from the root
          directory of  the current installation diskette  to the directory
          that the  user entered when  prompted with "Data  Files", perhaps
          the default directory presented to him, "C:\DATA".
            
          Now, consider this more advanced example:
            
          USER label_1 "Data Files" C:\DATA
          SUBDIR label_1 \HELP
          FILE label_1 main.exe  
          FILE label_1 main2.exe
          FILE label_1 help\help.dat
            
          Assuming  that the user accepts  the default C:\DATA, this script
          will transfer main.exe  and main2.exe from the  root directory of
          the current  installation  diskette to  C:\DATA, just  as in  the
          previous example.   Also, as child to  the user-entered directory
          will  be created a help  directory, to which  will be transferred
          help.dat.
            
          The final structure if all defaults are accepted by the user is:
            
          C:\DATA\MAIN.EXE
          C:\DATA\MAIN2.EXE
          C:\DATA\HELP\HELP.DAT
            

          Splitting Files__________________________________________________
            

                                                                         13




                            Chapter 4, Transferring Files
          

          If  you have  files  that just  cannot  fit onto  a  distribution
          diskette,Install-Pro  has  the  ability to  handle  split  files.
          First an example of how to tell Install-Pro what you want:
            
          FILE label_1 main.ex1e
          FILE label_1 main.ex2e
            
          These two FILE commands lines would cause Install-Pro to create a
          file  called main.exe  in the label_1  directory, from  TWO files
          main.ex1 and main.ex2.  What Install-Pro does is looks  to see if
          an extra character has been added to  a filename.  If there is an
          extra character:
            
          1.  The  source  (distribution  disk)  filename  is  assigned  an
          extension  of  the  first  three  characters  of  the  filename's
          extension.   This file should  exist on the  current distribution
          diskette.
            
          2. The destination filename has the third character replaced with
          the fourth, and the fourth character is removed.
            
            
          Please note that:
            
          1.  main.ex1e and main.ex2f would  not cause an  append to occur.
          The filenames (with  the exception  of the third  character of  a
          four-character  extension) MUST  match.   In this  case, main.exe
          would  be created  from  main.ex1,  but  main.exf  would  NOT  be
          created.
            
          2. The  files MUST have the  same label name assigned  to each of
          them.  If main.ex1e and main.ex2e were assigned different labels,
          \directory1\main.exe would be  created, but  \directory2\main.exe
          would NOT.
            
            
          The append/create decision is resolved as follows:
            
          1. If  third character of the  extension is a '1'  and the fourth
          character exists, the file is CREATED.
            
          2. If the third character is greater than a '1', then Install-Pro
          checks to make  sure that the preceding portion   of the file was
          copied before proceeding.  If so, the file is APPENDED.  

          3. If the third  character is a number,  but no fourth  character
          exists,  no  split-file  decision  occurs  -  the  file  will  be
          created.

          14




                            Chapter 4, Transferring Files
          

            
          This type of file  transfer can be especially touchy if the order
          of  files transferred  and then  appended is  incorrect.   If you
          split  files,I  strongly recommend  that  you  debug your  script
          carefully and compare  the created file with the  original (using
          the DOS program 'COMP') to be sure that they are identical before
          releasing your application.

          There  is an  accompanying  utility called  split.exe which  will
          split your  large files for you if needed.  It comes with its own
          documentation.


          UNZIP____________________________________________________________

          Syntax: UNZIP <labelname> <zipfile> [VERIFY or UPGRADE]

          This  command specifies a zip file that needs to be decompressed.
          The following assumptions are made with this command:

          1. If  the zip file  is in a  destination directory  it is to  be
          deleted  after  decompression.   (Under  no  circumstances is  it
          possible to delete a zip file on the distribution disk.)

          2. The  base destination  for the  extracted files  is to  be the
          directory  associated with  labelname.    That  is,  subdirectory
          information stored in the zip file is to be used  relative to the
          current zip file directory.

          3. The filename's default extension is 'zip'.

          4. The file was  compressed with a supported version  of PKWare's
          PKZip or 100% compatible.  Currently, the latest version of PKZip
          (1.10) is  supported.  See the  read.me file for  updates on more
          recent releases.

          5. The file was NOT encrypted with a password.

          6. The file is not part of a multiple-volume archive.


          The  components of  the UNZIP  command should  be  interpreted as
          follows:


          <labelname>:



                                                                         15




                            Chapter 4, Transferring Files
          

          The  labelname, which  must  be previously  defined  with a  USER
          command, defines the base directory for the decompression.


          <zipfile>:

          The zipfile may be transferred first  with a FILE command, or  it
          may  be   decompressed  from  the  installation   diskette.    In
          performance,  both  methods  are  identical.    However,  if  you
          decompress  from the diskette, extra care must be taken to ensure
          that  the UNZIP  command  occurs in  the  script on  the  current
          diskette.  If  you transfer  with a file  command and  decompress
          from the installation directory, then the UNZIP command  can come
          anytime afterwards, even on the last diskette.


          [UPGRADE]:

          This modifier indicates that any files newer than the file  being
          transferred are to  be overwritten only with  permission from the
          user.   This modifier is reliant on  the user's machine  having a
          functional clock,  and  that  the  files on  the  user's  machine
          reflect actual dates.


          [VERIFY]:

          This modifier directs Install-Pro to verify all file overwrites.

          Any directory information packed in an  zip file is automatically
          created   as  needed   during   the  unzip   process.  Under   no
          circumstances  will a file stored in a zip file with subdirectory
          information be unpacked into the current directory.

          Example:

          UNZIP label1 zipfile

          would unzip zipfile.zip in the directory associated with label1.

          If UNZIP refers  to an OPTIONal label, the UNZIP  will only occur
          if the user chose to include that part of the installation.

          Since  an error  extracting  a zip  file  must be  considered  as
          dangerous  as an error copying an installation file, crc or other
          unzip errors must be treated as fatal errors, with program abort,
          so  double-check   the  integrity  of  your   .zip  files  before
          distribution.

          16




          Chapter 5

          Changing Disks and Terminating___________________________________


          FIRSTDISK________________________________________________________

          Syntax: FIRSTDISK [disk name]

          This  command  allows  you   to  name  the  first  disk   of  the
          installation something besides the default "Disk 1" (for example,
          "Install Disk").  Other  than slightly changing screen appearance
          and prompts, this command does not affect the physical  operation
          of Install-Pro in any way.  If no argument  follows the FIRSTDISK
          command, the default of "Disk 1" will be used.  

          FIRSTDISK MUST appear in install.001 to have any affect.


          DISK_____________________________________________________________
            
          Syntax: DISK [disk name]
            
          This command specifies that when  processing for the current disk
          has  finished, the  user  is to  be prompted  to insert  the next
          numbered disk (as opposed to terminating the installation).   The
          extension  of the  script  file increments  with each  successive
          disk.   For example, if the  disk being processed is  disk 1 with
          install.001, specifying DISK would cause  the user to be prompted
          to insert disk #2.  If the user presses enter and the disk in the
          drive in which  install.exe exists does  not have install.002  in
          the  current directory, the user will be instructed to try again.
          This  loop repeats  until the  user inserts  the correct  disk or
          until the user presses Escape, which would terminate the program.
            
          The  optional  [disk  name]  argument  allows  you  to  name  the
          following  disk  something besides  "Disk  n".   Common  uses are
          "Utilities  Disk","Fonts Disk"  or what-have-you.   If  you adopt
          this  or  another  naming convention,  be  sure  to  look up  the
          FIRSTDISK  command  for instructions  on  naming  the FIRST  disk
          (since the DISK command always names the FOLLOWING disk.)
            

          END______________________________________________________________

          Syntax: END
            
          This command  indicates  that the  end of  the last  installation
          script  has been  reached.    Just  like  DISK,  END  forces  all
          information  stored in  all  labels to  be  processed.   However,
          unlike DISK, when this processing has been completed, the program
          displays the GOODBYE messages and exits.

                                                                         17




                       Chapter 5, Changing Disks & Terminating
          

            
          This  command   is  mutually  exclusive  of   the  DISK  command.
          Whichever is encountered first on any given diskette will dictate
          the processing that will occur, and the other will be ignored.


          CHAIN____________________________________________________________

          Syntax: CHAIN
            
          This  command indicates  that the  end of  the last  installation
          script  has been  reached, just like  END.  When  this command is
          reached, all work accumulated is processed.  Unlike END, however,
          CHAIN  is a  conditional installation  terminator.   The  user is
          presented with "Do  you wish to install another module (Yes/No)".
          If the user selects NO, then the GOODBYE screen is  displayed and
          Install-Pro terminates.
            
          If  the user  selects  YES, then  he is  prompted  to insert  the
          Install Disk of the next module and Install-Pro transfers control
          to  another copy of itself on the  new diskette, and the old copy
          of Install-Pro in memory  is discarded.  Any GOODBYE  screen will
          be handled by the new copy of Install-Pro.
            
          The  actual filename  that  is  looked  for  with  CHAIN  is  the
          identical path  and filename of the  currently executing process.
          So, if you have  renamed one copy of Install-Pro  to INSTALL.EXE,
          they all must be renamed that way.
            
          The traditional use  for this type of termination is  in the case
          of integrated accounting software, where it is unknown at runtime
          how  many  modules  (General  Ledger,  System  Manager,  Accounts
          Receivable,etc.) have been purchased.
            

          AUTHORIZATION____________________________________________________

          Syntax: AUTHORIZATION 00000
            
          This  command is only required  on the last  line of install.001.
          Its function is solely to create a space for Install-Pro to write
          an  authorization code. After you  have run Install-Pro with your
          key on the command line, this line will be updated by Install-Pro
          with the appropriate authorization code for the current script.





          18




          Chapter 6

          Verifying the target environment_________________________________


          SPACE____________________________________________________________

          Syntax: SPACE <label_name> <nnnnn>
            

          If you  would like  the destination  drive checked  for available
          disk  space before proceeding (often a good idea) you define your
          space requirements with this command.  It is not foolproof, since
          it is  possible that the  installation will go  on top of  an old
          one, but  it provides you with an opportunity to warn the user if
          his disk is almost full.

          Each SPACE command must  reference a defined label (via  the USER
          command.)    After the  user  chooses his  destination  drive and
          directories  in the  entry screen,  all labels  that access  each
          drive are added together  to determine if enough free  disk space
          exists.
            
          The disk check(s) occur directly after the user has finished with
          the   destination  directory   entry   screen.     Any   OPTIONal
          installation  segments that  are  declined by  the  user are  not
          counted when determining adequate disk space.


          CPU______________________________________________________________

          Syntax: CPU <86, 88, 188, 286 or 386>

          This command can be used to warn the user that his  machine has a
          processor that will not run your application.  This is treated as
          a warning,  and the user is  allowed to try to  continue.  Please
          note  that this detection  is not 100%  reliable due to  the huge
          number  of  computers available.   A  80386  and 80486  will both
          report as 386 at this time.


          FPU______________________________________________________________

          Syntax: FPU
            
          This command will  warn the  user that your  application needs  a
          math  co-processor installed to function.   This is  treated as a
          warning, and the user is allowed to try to continue.


          RAM______________________________________________________________
            

                                                                         19




                           Verifying the Target Environment
          

          Syntax: RAM <nnn>

          This command will warn  the user if the installation  machine has
          less ram  installed than required  by your  application.   Please
          avoid  RAM 640, as in some cases DesqView will incorrectly report
          less than 640k.   This is treated as  a warning, and the  user is
          allowed to try to continue.


          VER______________________________________________________________

          Syntax: VER <n.nn>
            
          This command will warn the  user if the version of MS-Dos  on the
          installation machine  is less than required  by your application.
          This is treated as  a warning, and the user is  allowed to try to
          continue.


          CONFIGFILES______________________________________________________

          Syntax: CONFIGFILES <nn>
            
          This command follows the following logic:
            
          1.   Attempt to determine the boot disk.  

          2.   If the boot disk is found, try to find Config.sys.

          3.   If Config.sys has been found, read the FILES= statement.  

          4.   If Config.sys  cannot be  found, or if  Config.sys has  been
               found but with FILES=  too low, ask the user  for permission
               to update  Config.sys.   If permission  is granted,  ask the
               user  for the path  to Config.sys if  Config.sys hasn't been
               found.

          5.   Modify Config.sys if given permission.

          Please note that the goal here is to:
            
          1.   Only  disturb the user if unable to determine that FILES= is
               okay.

          2.   Never modify Config.sys without permission.

          3.   Don't  access  a  Bios-reported floppy  diskette  unless the
               user inputs it as the boot disk.

          20




                           Verifying the Target Environment
          

            
          A  message is  displayed notifying  the user  whether the  update
          occurred, or whether it wasn't needed after all.

          PATH_____________________________________________________________

          Syntax: PATH <labelname>

          This command allows a path associated with a label to be inserted
          into the path statement in Autoexec.bat.  If the path is found in
          Autoexec.bat, no  attempt is  made to add  it again.   Like  with
          Config.Sys, the user is  only disturbed if Install-Pro  is unable
          to determine that the PATH setting is okay.




































                                                                         21





          Chapter 7

          Running External Programs________________________________________


          RUN______________________________________________________________

          Syntax: RUN "any command line in quotes"
            
          This command defines  a command line to  be built to  execute any
          special programs or batch  files that are needed to  customize an
          installation.  One  use for  this might  be to  run a  config.exe
          program that  will bring the  user straight into  configuring the
          application he is  installing.   Another use might  be to  create
          application  menu  definition files  that  couldn't  be built  at
          install-time otherwise.
            
          Run works by one of two methods.  If the command specified on the
          command line has the  extension ".EXE" or ".COM", the  program is
          executed directly by Install-Pro.   If no .EXE or  .COM extension
          is specified, your command is run by invoking a command processor
          shell and  passing it the command  line that you specify.   There
          must be enough memory to load both  your program or command shell
          in addition to that used by Install-Pro.
            
          Run  command lines  of longer than  one word MUST  be enclosed in
          quotes.  
            
          Further,  the directory(s) that  the user  enters at  runtime are
          available on the  RUN command  lines.  Simply  specify any  label
          with  a  preceding exclamation  point  (!)  and the  user-entered
          directory will  be directly substituted  for that portion  of the
          text.   The directory is inserted without any leading or trailing
          spaces, but the  spaces on  the RUN command  line are  UNTOUCHED.
          Some examples follow:
            
          RUN "dir !label_1"
          RUN "!label_1\myprog.exe"
          RUN "copy !label_1\this.fil !label_2"
          RUN "anydir\anyprog.exe"
            
          Finally, a special  sequence, !home, signifies  that you wish  to
          specify the installation directory of the installation disk.  For
          obvious reasons, don't  create any labels called 'home'  with the
          USER command, or the  !home sequence will no longer point  at the
          home directory, but rather  at the directory entered by  the user
          for this labelname.
            
          RUN "!home\myprog.exe"

            

          22




                         Chapter 7, Running External Programs
          

          would  execute  myprog from  the  installation  directory of  the
          installation disk.
            
          When a RUN command is  executed, the screen is saved and  cleared
          first.  After it has completed, the screen is restored.
            
          If the command  shell attempt fails, the user will be notified of
          the reason (usually memory) but the INSTALLATION  WILL NOT ABORT.
          If there is a critical part of your installation occurring with a
          RUN command, be sure  to document it in your  manual installation
          instructions for the user.
            
          A few points to keep in mind:
            
          1.   The  error  trapping  is  much  more  solid  if  Install-Pro
               directly executes your  program.   This is due  to the  fact
               that  if   the  command  shell  is   used  instead,  success
               constitutes the shell  having successfully loaded.   Whether
               enough ram  existed for  your program  or  your program  was
               found is  not detectable by  Install-Pro.  What's  worse, in
               the  case  of  older  versions of  the  alternative  command
               processor 4dos, the command shell load process occurs in two
               parts.  The  first part  of 4dos can  load successfully  but
               fail to load the  rest of itself and still return success to
               Install-Pro.
            
          2.   Memory requirements  for command  shell RUN commands  can be
               significantly  higher,  especially  if  COMMAND.COM  is  the
               target of COMSPEC (about 27k).
            
          3.   A  single  RUN command  in  .EXE  mode is  allowed  up  to 9
               arguments.  Additional  arguments are  ignored.   In command
               shell mode, there  is no  limit to the  number of  arguments
               allowed.
            
          4.   A single RUN command in .EXE mode is allowed a  length of up
               to 256 characters.   The  length of any  single argument  is
               restricted  to  128  characters.    If  argument  zero  (the
               directory, path  and filename  of the executing  program) is
               longer than 128 characters, DOS will return an error message
               back to Install-Pro.   If any other argument is  longer than
               128 characters, the argument will be truncated.
            
          5.   A  single RUN  command in  command shell  mode is  allowed a
               total length  of up to 256 characters, but keep in mind that
               the  widely-used command  interpreter COMMAND.COM  will only
               allow 128 characters  total.  4dos, among  others, allows up
               to 256 characters.

                                                                         23




                         Chapter 7, Running External Programs
          

            
          6.   RUN commands  MAY access OPTIONal directories.   However, if
               any of the optional directories listed in a RUN command line
               were not accepted by the user (even if the directory already
               exists), the  command  will be  ignored.   This  allows  RUN
               commands to  be conditional  on whether  an OPTION has  been
               accepted.  If  an OPTION is declined,  you can be  sure that
               the associated RUN commands will not be executed.









































          24





          Chapter 8

          Customizing Install-Pro__________________________________________


          ONERROR__________________________________________________________

          Syntax: ONERROR "Any text in quotes"

          If an error occurs, you may have a specific suggestion that you'd
          like to  present your customer, for example a number to call.  If
          ONERROR is defined in install.001, the unrecoverable message text
          "Please  refer to  your manual  installation instructions  if the
          problem cannot be corrected."  is directly replaced with whatever
          text  you  specify.    The  text  in  quotes  may  be  up to  200
          characters.


          Linking external text____________________________________________

          Distributed with Install-Pro  comes a  file called  EXTERNAL.LNG.
          This  optional file,  if found  in the Install-Pro  directory, is
          used  to  replace the  internally  defined  text strings.    This
          feature allows  total prompt  redefinition for  specialized needs
          such as foreign language translations.  The linkage occurs before
          ONERROR text  is read  into memory, so  ONERROR takes  precedence
          over its counterpart in the redefinition file.
            
          If  EXTERNAL.LNG is  found,  Install-Pro inserts  the text  found
          directly into the  program space, and  will behave as  if it  had
          been developed with that text.   The file is read on a one-to-one
          correspondence  to internal  string space.   That  is, each  line
          replaces  a specific string of text.  In  the case of some of the
          longer  strings, you may specify a line continuation with the '\'
          (backslash) character.  Thus, 
           
          "String definition 1 " \
          "String definition continued"
            
          would be treated as the following single definition:
            
          "String definition 1 String definition continued"
            
          Don't forget that you  probably want a space character  after the
          last word of  continued string definitions.  The quotations marks
          are   mandatory.    Please  be  aware  that  there  is  a  slight
          performance penalty involved in reading the definition  file.  If
          you do  not want redefinition to take  place, remove external.lng
          from your Install-Pro directory.



                                                                         25




                          Chapter 8, Customizing Install-Pro
          

          Lines beginning  with a  semicolon or  empty  lines are  ignored.
          Liberal use  of semicolon-preceded comments will  greatly aid the
          redefinition   process,   especially  when   translating  between
          languages.
            
          Some  of the string definitions are included with %s or %d format
          specifiers.    If  you  are not  familiar  with  the  programming
          language  C,these  are  used  to insert  variable  text  into the
          string.  When you redefine a string, you must remember to include
          the  format specifiers in a  similar position in  the new string.
          If  you  include  more  format  specifiers  in  the  string  than
          originally  defined,  garbage  will  display in  your  string  at
          runtime.    If  you  display  fewer  format  specifiers,important
          information will not be displayed to your users.
            
          Some of the text strings are menu items (they are labeled as such
          in external.lng.)  They  must be preceded with a  space character
          (i.e." Yes " for the menu hotkeys to work correctly.
            
          The order of  the string  definitions is significant.   You  must
          redefine all of the text if you redefine any of it.
            
          When redefining text,  I strongly suggest that the  original text
          definitions provided in the  sample be commented out and  left in
          the file for reference.   Generally, the new definitions  need to
          be  approximately  the  same  length  as  the originals.    Where
          possible (e.g. some of  the longer messages) I have  allowed some
          extra  leeway by implementing word-wrap in the message box and by
          leaving  extra space.  Generally,  if a text  redefinition is too
          long,  the part that is too long  will either be truncated or run
          into menu selection bars.  If you cannot  satisfactorily redefine
          a line, please contact us.

















          26




          Chapter 9

          Miscellaneous____________________________________________________


          Error Messages___________________________________________________

          The following are the standard error messages built into Install-
          Pro.The  nature of these  errors is such  that Install-Pro cannot
          continue,   so these error messages can probably be classified as
          Fatal Errors.   The message the  user sees is similar  to the one
          that follows:

                
                Ŀ
                 The following unrecoverable error has  occurred:  
                                                                   
                             Error opening install.001             
                                                                   
                                                                   
                 Please refer to your documentation for manual     
                 installation instructions if the problem cannot   
                 corrected                                         
                                                                   
                              Press a key to terminate...          
                
                

          As previously mentioned, the instructions can be modified with an
          ONERROR command.
            

          DOS version 3.0 or higher required
            
          A  DOS version prior to  3.0 was detected.   Install-Pro requires
          MS-DOS 3.0 or later.

            
          Error opening install.001
            
          INSTALL.001 was not found  in the same directory as  Install-Pro,
          or there were no file handles available.

            
          Token was expected but not found: line nn

          A token  was expected but  not found on the  indicated line. This
          usually means that one or more words is missing on this line.


          Memory allocation error


                                                                         27




                                    Miscellaneous
          

          A request for more memory was denied.  This is extremely unlikely
          to occur, as Install-Pro requires under 200k of free RAM.


          Error copying xxxxxxx

          DOS  returned an  error while  trying to  transfer the  indicated
          file.


          Cannot copy a file onto itself

          The user specified the installation diskette as the destination.


          Error creating directory: zzzzzzz

          DOS  returned an  error  while  trying  to create  the  indicated
          directory.  The most likely cause is if the user tries to install
          the  application  to a  directory  that is  the same  name  as an
          existing file.


          Authorization Error

          Install-Pro detected an authorization code that did not match the
          accompanying  script file (install.001).   Run  Install-Pro again
          with your key to authorize your script.
            

          Executable integrity error - bad executable

          Install-Pro  detected  internal  errors in  its  executable file.
          This usually means that  the file has become corrupted.   Restore
          an original from your backup and retry.


          Label not found: xxxxx, line nn

          The token in the <label name> position on the specified line does
          not  correspond to a previously defined label name created with a
          USER command.


          Invalid Disk Space Number

          Either  no token,  or an  invalid token,  was detected  after the
          SPACE command.

          28




                                    Miscellaneous
          


          Unexpected EOF - AUTHORIZATION, END, CHAIN or DISK expected

          If Install-Pro parses to the end of a script without finding some
          indication of how to terminate, it returns this error.


          Zip output file creation error

          An error was detected while trying to create a file imbedded in a
          zip file.  The usual causes are out of disk space, network rights
          insufficient, or an   existing directory of the same name.
            

          Zip file open error

          The zip file was not found, or no file handles were available. 


          Invalid zip file header

          An inconsistency was detected in the zip file.


          Zip file corrupted

          An extracted file's crc did not match its reported crc.


          Zip file encrypted

          Encrypted  zip files (and  the inherent password  needed to build
          the decryption key) are not supported.


          Error chaining to new program

          An error  was encountered  while  trying to  load a  new copy  of
          Install-Pro. Possible causes are  insufficient memory or file not
          found.


          System Error - current directory not available

          Install-Pro requested from DOS the name of the current directory,
          but DOS returned an error.



                                                                         29




                                    Miscellaneous
          

          System Error - change directory failed

          An  attempt  by Install-Pro  to change  to another  directory (to
          unzip a file) failed.
            

          Unexpected end of file

          The  end of  an  zip file  was  encountered unexpectedly.    This
          usually means the file is damaged.


          Disk Write Error - target disk full?

          The majority of disk write errors are a full disk, but they could
          also be caused by hard disk  failure or logical errors in the FAT
          table.
            

          Directories must be 65 characters or less

          The  path entered  by the  user  plus the  SUBDIR attached  to it
          exceeded DOS'  maximum.   Don't  define  SUBDIRs longer  than  20
          characters to be safe.


          Unsupported ZIP version

          A  ZIP version of  higher than 1.10  was detected in  a zip file.
          Since  no version of ZIP greater than 2.30 currently exists, this
          error may likely indicate zip file corruption.


          Invalid command

          The first token encountered  on the indicated line in  the script
          was not a valid command.












          30




                                    Miscellaneous
          

          Critical Errors__________________________________________________

          Should a  disk door  be left  open (or  any other  critical error
          trapped by DOS, for  that matter) a Critical Error  handler built
          into  Install-Pro will take control  and provide the  user with a
          menu similar to this one:

                     
                     [DOS Critical Error]Ŀ
                                                             
                        [Abort]  [Retry]  [Ignore]  [Fail]   
                                                             
                     ٱ
                     

          If the  user accepts retry,  he will be in  most cases safe.   Of
          course,  if  his  computer  picked  the  exact moment  that  he's
          installing your application to crash its hard drive, no  Critical
          Error handler is going to recover very gracefully.


          Authorization Keys_______________________________________________

          With your Install-Pro diskette  you received a key in the form of
          a  series of characters.  This key protects copies of Install-Pro
          that  are released with  your applications  from being  used with
          scripts other than  the one you  defined.  This  key is  utilized
          simply by  including it with  no accompanying punctuation  as the
          only argument on  the Install-Pro  command line.   The result  is
          that the script is processed normally, with an authorization code
          created  on the  AUTHORIZATION  line.   Observing this  procedure
          ensures that your  scripts never cause Install-Pro to  abort with
          an Authorization  Error message.  For  development purposes, just
          create a batch file to save repeatedly typing in your key.  Then,
          when  you  release  your  product,  the  script  has  the  latest
          AUTHORIZATION  (see  above)  encoded  in  your  script,  enabling
          Install-Pro to only  to work  with the unmodified  script.   This
          protects our product, as well  as protects your installation from
          unwanted tampering.










                                                                         31

