*.............................................................................
*
*   Program Name: DEMO.PRG          Copyright: Global Technologies Corporation
*   Date Created: 06/05/90           Language: Clipper 5.0, Graphics Language
*   Time Created: 11:27:44             Author: Bill French
*
*   This demo program contains not a single dGE function call.  Only english
*   like statements of the Graphics Language for Clipper 5.0.  Most of it is
*   commented and much of it is self explanatory.  The menu it produces is
*   quite impressive considering it is less than 20 lines of code.  The entire
*   program including charts is only about 100 lines.
*
*   Compiling is accomplished in ordinary fashion but does require the Graphics
*   Language header file GLLIBR.CH to be present in the compilation directory
*   or the INCLUDE directory.  Additionally, you must link in GLLIBR.LIB in
*   addition to the standard dGE screen drivers and library.
*
*   At run-time, this program requires the dGE character sets listed below.
*   Failure to make these character sets available at run-time will cause dis-
*   play problems.
*
*     DGE0EGA.CHR   RMN1628.STX
*     DGE1EGA.CHR   RMN2828.STX
*     DGE1108.STX   RMN3828.STX
*     DGE1609.STX
*.............................................................................

#include "gllibr.ch"                             // include the gl language definitions

local choice_

do MainMenu                                      // display the main menu

do while .t.                                     // main menu loop
   set character set to system small             // change the character set back to system small
   wait event to choice_                         // wait for a mouse press in a region
   do case                                       // evaluate the mouse click
   case choice_ == "one"                         // if region 1 was clicked
      clear graphics screen                      // clear the graphics screen
      set character set to system small          // change the character set back to system small
      setcolor("gr+/b")
      draw bar chart at 16,14 using demo.dbf ;   // display a bar chart
         plot div_income ;                       // select the field to plot
         label div_code ;                        // specify the label
         filter recno()<=16 ;                    // set the filter
         3d ;                                    // display in 3d mode
         height 12 ;
         width 60 ;
         division 5000 ;
         dotted ;
         color bright cyan ;
         box
      setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
      draw "Sales" at 06,02 using system large vertical
      draw "Division Sales" at 21,17 using roman 3828
      do pause                                   // prompt for a mouse click
   case choice_ == "two"                         // if region 2 was clicked
      clear graphics screen                      // clear the graphics screen
      set character set to system small          // change the character set back to system small
      draw pie chart at 09,40 using demo.dbf ;   // draw a pie chart
         plot div_income ;                       // select the field to plot
         label division ;                        // select the lable
         radius 12 ;
         pattern ;                               // select alternating patterns
         explode 3 ;                             // select the first slice to explode
         filter year = "1990" ;                  // only plot 1990 data
         color                                   // select alternating colors
      setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
      draw "Divisional Sales" at 20,14 using roman 3828
      do pause                                   // prompt for a mouse click
   case choice_ == "thr"                         // if region 3 was clicked
      set color to "r+/b"                        // set the color to bright red on blue
      draw box from 03.5,16 to 16,75             // draw graphical box
      set character set to system 1108           // establish system 1108 character set
      set color to "w+/b"                        // set the color to bright white on blue
      draw "*** Demo Source Code ***" at 04.75,18
      draw "DRAW PIE CHART at 08,46 using DEMO.DBF ;   // select dbf" at 06.0,18
      draw "   PLOT div_income ;               // select plot field" at 07.25,18
      draw "   LABEL division ;                // select label field" at 08.50,18
      draw "   PATTERN ;                       // alternate patterns" at 09.75,18
      draw "   RADIUS 12 ;                     // specify size of pie" at 11.00,18
      draw "   EXPLODE 3 ;                     // explode third slice" at 12.25,18
      draw "   FILTER year='1990' ;            // set filter" at 13.50,18
      draw "   COLOR                           // alternate colors" at 14.75,18
      do pause                                   // prompt for a mouse click
   case choice_ == "fou"                         // if region 4 was clicked
      clear graphics screen                      // clear the screen
      draw " This Picture May Be" at 03,02.5 using roman 2828
      draw "Worth A Thousand Words" at 05,02
      set character set to system small          // change the character set back to system small
      set color to "gr+/b"
      draw box from 05.25,20 to 14.25,59
      set color to "w+/b"
      draw pie chart at 09,40 using demo.dbf ;   // draw a pie chart
         plot div_income ;                       // select the field to plot
         label div_code ;                        // select the lable
         pattern ;                               // select alternatine patterns
         radius 6 ;                              // select the radius (in chrs)
         explode 3 ;                             // select the first slice to explode
         filter year="1990" ;                    // only plot 1990 data
         color                                   // select alternating colors
      setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
      draw "Divisional Sales" at 14,31 using system std
      draw "But It Only Took 16" at 17,06 using roman 2828
      draw "     To Create     " at 19,06
      draw box from 19.50,03.25 to 23,75
      draw "DRAW PIE CHART at 08,46 using DEMO.DBF PLOT div_income PATTERN" at 21,04.5 using system small
      draw "   LABEL division RADIUS 12 EXPLODE 3 FILTER year='1990' COLOR" at 22,04.5
      define event "pause" from 00,00 to 24,79 ;
         activate
      wait event "pause" release                 // wait for a mouse prees in region 7 only
      clear graphics screen                      // clear the screen for the next frame
      draw "The Graphics Language" at 05,03 using roman 3828
      draw "For" at 07,35 using roman 2828
      draw "Clipper 5.0" at 09,20
      draw "by" at 15,36 using roman 1628
      draw "Global Technologies" at 18,07 using roman 2828
      draw "Corporation" at 20,22
      define event "pause" from 00,00 to 24,79 ;
         activate
      wait event "pause" release                 // wait for a mouse pree in region 7 only
      do MainMenu                                // redisplay the main menu
   case choice_ == "fiv"                         // if region 6 was clicked
      exit                                       // exit from the menu loop
   endcase
enddo                                            // do while .t.

set mouse off                                    // hide the mouse
set graphics off                                 // set to text mode
quit                                             // exit to dos

procedure MainMenu
   clear screen                                  // clear the text screen (std Clipper 5.0 command)
   set graphics on                               // graphics mode
   set mouse on                                  // turn on the mouse
   set palette background to bright blue         // change the background color
   clear graphics screen                         // clear the graphics screen
   set event shadow to "n+/b"                    // set event object shadow color
   setcolor("w+/b")                              // set the menu color (std Clipper 5.0 function)
   draw "The Graphics Language" at 02,40 using system 1609 center
   set icon to demo.ico                          // load the sample supericon file
   set character set to system small             // establish the small system character
   define event "one" at 03,06 using super icon 2 shadow activate
   define event "two" at 09,06 using super icon 4 shadow activate
   define event "thr" at 15,06 using super icon 6 shadow activate
   define event "fou" at 21,06 using super icon 7 shadow activate
   define event "fiv" at 21,72 using super icon 1 shadow activate
return

procedure pause
   set character set to system large             // change the character set back to system small
   draw box from 21.5,26 to 23,56 bevel
   @ 22.9,27.25 draw "Click here to continue..."
   define event "pause" from 21.5,26 to 23,56 ;
      activate
   wait event "pause" release                    // wait for a mouse pree in region 7 only
   clear graphics screen                         // clear the previous image
   setcolor("w+/b")                              // set the menu color (std Clipper 5.0 function)
   draw "The Graphics Language" at 02,30 using system 1609
   activate event "one"
   activate event "two"
   activate event "thr"
   activate event "fou"
   activate event "fiv"
return
