//.............................................................................
//
//   Program Name: MENUDEMO.PRG      Copyright: Global Technologies Corporation                          
//   Date Created: 01/17/91           Language: Clipper 5.0                                         
//   Time Created: 23:55:15             Author: Bill French                               
//   /brief/library.src
//.............................................................................
#include "gllibr.ch"                             // include the gl language definitions

#define MaxPrompts 10

function Main()
   local choice_
   clear screen                                     // clear the text screen
   set graphics on                                  // graphics mode
   set mouse on                                     // turn on the mouse
   set palette background to white                  // change the background color
   set event shadow to "n+/b"                       // clear button gets set shadow color
   clear graphics screen                            // clear the graphics screen

   set character set to system medium

   do while .t.
      clear graphics screen
      setcolor("w+/b+")                             // set the menu color (std Clipper 5.0 function)
      set character set to system large             // change the character set back to system small
      draw "GL Experimental Menu" at 02,40 center
      choice_ = popupmenu(05,10,3)
      do case                                       // evaluate the mouse click
      case choice_ == "one"                         // if region 1 was clicked
         clear graphics screen                      // clear the graphics screen
         set character set to system small          // change the character set back to system small
         setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
         draw bar chart at 18,14 using demo.dbf ;   // display a bar chart
            plot div_income ;                       // select the field to plot
            label div_code ;                        // specify the label
            filter recno()<=16 ;                    // set the filter
            3d ;                                    // display in 3d mode
            height 12 ;
            width 60 ;
            division 5000 ;
            dotted ;
            box
         setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
         draw "Sales" at 06,02 using system large vertical
         draw "Division Sales" at 23,17 using roman 3828
         set character set to system large

         setcolor("w+/b+")                             // set the menu color (std Clipper 5.0 function)
         draw "Isolate On Division" at 01.8,40.5
         draw box from 02,40 to 04,44 pattern 2 bevel
         @ 03.6,40.90 draw "SW" using system large
         draw box from 02,46 to 04,50 pattern 2 bevel
         @ 03.6,46.90 draw "NW" using system large
         draw box from 02,52 to 04,56 pattern 2 bevel
         @ 03.6,52.90 draw "SE" using system large
         draw box from 02,58 to 04,62 pattern 2 bevel
         @ 03.6,58.90 draw "NE" using system large

         popmenu1(01,02,7)
      case choice_ == "two"                         // if region 2 was clicked
         clear graphics screen                      // clear the graphics screen
         set character set to system small          // change the character set back to system small
         set color to "b/w"
         draw pie chart at 09,40 using demo.dbf ;   // draw a pie chart
            plot div_income ;                       // select the field to plot
            label division ;                        // select the lable
            radius 12 ;
            pattern ;                               // select alternating patterns
            explode 3 ;                             // select the first slice to explode
            filter year = "1990" ;                  // only plot 1990 data
            color
         setcolor("w+/b")                           // set the menu color (std Clipper 5.0 function)
         draw "Divisional Sales" at 19,14 using roman 3828
         do pause                                   // prompt for a mouse click
      case choice_ == "quit"                        // if region 3 was clicked
         exit
      endcase                                       // do case                                       // evaluate the mouse click
   enddo                                            && do while .t.
   set mouse off
   set graphics off
   clear screen
return(Void)

function popupmenu(x,y,items)
   local temp, prompt, n, _width, _prompts_[items][2]  // declare the menu array
   for prompt := 1 to items
      _prompts_[prompt,1] := NullString          // GL memvar
      _prompts_[prompt,2] := NullString          // GL memvar
   next                                          // for prompt := 1 to maxprompt                  
   _prompts_[1,1] := "Three Dimensional Bar Graph " 
   _prompts_[2,1] := "Pie Chart                   " 
   _prompts_[3,1] := "Quit                        " 

   _prompts_[1,2] := "one"
   _prompts_[2,2] := "two"
   _prompts_[3,2] := "quit"

   _width := len(_prompts_[1,1]) + 5
   __DrawBevel(x,y,items+1,_width,3)
   set color to "w+/"
   for n := 1 to items
      draw _prompts_[n,1] at x+n+.4,y+1.4
      define event _prompts_[n,2] from x+n-.5,y+1.4 to x+n+.5,y+_width activate
   next                                          // for n := 1 to items
   wait event to temp
return(temp)

function popmenu1(x,y,items)
   local _width, j, temp, prompt, _prompts_[items][2]  // declare the menu array
   for prompt := 1 to items
      _prompts_[prompt,1] := NullString          // GL memvar
      _prompts_[prompt,2] := NullString          // GL memvar
   next                                          // for prompt := 1 to maxprompt                  
   _prompts_[1,1] := "Update Database       " 
   _prompts_[2,1] := "What If...            " 
   _prompts_[3,1] := "Show Database Detail  " 
   _prompts_[4,1] := "Show Percentages      " 
   _prompts_[5,1] := "Adjust Graph Scale    " 
   _prompts_[6,1] := "Print To LaserJet III " 
   _prompts_[7,1] := "Return To Main Menu   " 

   _prompts_[1,2] := "1"
   _prompts_[2,2] := "2"
   _prompts_[3,2] := "3"
   _prompts_[4,2] := "4"
   _prompts_[5,2] := "5"
   _prompts_[6,2] := "6"
   _prompts_[7,2] := "7"

   _width := len(_prompts_[1,1]) + 5
   clear graphics window from x-.15,y-.325 to x+items+1.15,y+_width+.325
   __DrawBevel(x,y,items+1,_width,3)
   set color to "w+/"
   for j := 1 to items
      draw _prompts_[j,1] at x+j+.4,y+1.4
      define event _prompts_[j,2] from x+j-.5,y+1.4 to x+j+.5,y+_width activate
   next                                          // for n := 1 to items
   wait event to temp
return(temp)

proc pause
   setcolor("w+/b+")                             // set the menu color (std Clipper 5.0 function)
   draw box from 21,26 to 23,56 pattern 3 bevel
   @ 22.7,27.5 draw "Click here to continue..." using system large
   define event "pause" from 21,26 to 23,56 activate
   wait event "pause" release
   clear graphics window from 21,26 to 23,56 bevel
return



