#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <inout.h>
#include <funcs.h>

/*----------------------- inout ------------------------------*/
/*DESCRIPTION: Allows entry, editing, displaying, and clearing*/
/*	of a field of data with specified length, position,   */
/*	color attributes, and data types.  Handles function   */
/*	keys, tab keys, and arrow keys.			      */
/*							      */
/*INPUT:
--------VARIABLE---------------------DESCRIPTION--------------
	X	;X COORDINATE TO START ENTERING INFORMATION
	Y	;COLUMN TO START ENTERING INFORMATION
	len	;MAX LENGTH OF DATA TO BE ENTERED
	FG	;FOREGROUND COLOR
	BG	;BACKGROUND COLOR
	Data	;STRING THE ENTRY IS STORED IN

	Mode	;0 = ENTER
		;1 = EDIT WITH CURSOR AT THE END OF THE DATA FIELD
		;2 = EDIT WITH CURSOR AT THE BEGINNING OF THE FIELD
		;3 = DISPLAY THE DATA FIELD
		;4 = CLEAR THE DATA FIELD

	Type	;0 = ALPHANUMERIC (DEF)
		;1 = NUMERIC
		;2 = PHONE # (999)-999-9999
		;3 = SOCIAL SECURITY NUMBER 999-99-9999
		;4 = DATE - MM/DD/YY
		;5 = PASSWORD
		;6 = UPPER CASE AN
		;7 = INTEGER
		;8 = REAL
		;9 = A SYSTEM GENERATED NUMBER
		;10 = LONG
                ;11 = DOLLAR

	show	;0 = DOTS (DEF)
		;1 = BLANKS
		;2 = UNDERSCORE
		;3 = NO SHOW

	vkey	;CHAR 1 -- F = ALLOW FUNCTION KEY USE
		;CHAR 2 -- A = ALLOW UP AND DOWN ARROW USE
		;CHAR 3 -- T = ALLOW TAB AND BACKTAB EXIT FROM INOUT

	ret	INPUT
		;0 = NON-DESTRUCTIVE ENTER KEY IN EDIT MODE (DEF)
		;1 = DESTRUCTIVE ENTER KEY IN EDIT MODE
		OUTPUT
		;0 = FIELD FILLED
		;1-12 = FUNCTION KEY PRESSED
		;13 = ENTER KEY PRESSED
		;14 = ESC KEY
		;15 = UP ARROW
		;16 = DOWN ARROW
		;17 = TAB
		;18 = BACKTAB
USES: strspc, strnchr, OnCursor, GetCursor, SetCursor, rtrim, rtrimlen,
	CheckNum, GetIdleCh
---------------------------------------------------------------*/
void inout (int X, int Y, int len, int FG, int BG, void *Data, int Mode,
	int Type, int show, char *vkey, int *ret)
{
	int	CursorX = 0, i, Fkey = 0, arrow = 0, tabkey = 0, fld=0;
	char	temp[80], *EntryPtr[3], EntOpt[4], *mask, entry[80];
	int     EntryX[3], EntMd;
	int	retrn, lendata, a, MoveX, MaxFld=0;
	unsigned int	OldCursor;
	char *strand(char *dest, const char *src);
	char *strtok(char *s1, const char *s2);
	char *strspc(char *s, int n);
	char *rtrim(char *s);
	double atof(const char *s);

/*----------USE RECURSION TO GET SPECIAL TYPES -----------*/
	if (Type==INOUT_PHONE || Type==INOUT_SSN || Type==INOUT_DATE)
	{
	    switch (Type) {
	      case INOUT_PHONE : mask = "(   )-   -    "; break;
	      case INOUT_SSN :   mask = "   -  -    "; break;
	      case INOUT_DATE :  mask = "  /  /  "; break;
	      default : printf("illegal type in funcion inout\n"); exit(0); }
	      i=0;
	      do {
		 if(mask[i]==' ')
		   temp[i] = (show==INOUT_BLANKS)?' ':(show==INOUT_UNDERSCORE)?'_':'';
		 else
		   temp[i] = mask[i];
	      } while(mask[i++] != '\0');

	       /* display mask or data */
	    if(Mode==INOUT_EDIT_BEG || Mode==INOUT_EDIT_END) {
	       EntryPtr[0] = Data;
	       i = Type; }
	    else {
	       EntryPtr[0] = temp;
	       i = INOUT_AN; }
	    inout(X, Y, strlen(mask), FG, BG, EntryPtr[0],
			INOUT_DISPLAY, i, 1, "", &retrn);

	       /* set specifics for the entry type */
	    strand(Data, mask);
	    i=0;
	    EntryPtr[i] = strtok(Data, "()-/");
	    while(EntryPtr[i] != NULL)
	       EntryPtr[++i] = strtok(NULL, "()-/");
	    for(i=0; i<3; ++i)
	      EntryX[i] = X + (EntryPtr[i]-Data)/sizeof(char);
	    strcpy(EntOpt, vkey);
	    EntOpt[2] = 'T';
	    if(Mode==INOUT_EDIT_END) fld = 2;
	    /* loop */
	    do {
	      if(fld < 0)  fld = 0;
	      if(fld < MaxFld) EntMd = 2;
	      else {
		EntMd = Mode;
		MaxFld = fld; }
	      retrn = *ret;
	      inout(EntryX[fld], Y, strlen(EntryPtr[fld]), FG, BG,
		  EntryPtr[fld], EntMd, 1, show, EntOpt, &retrn);
	      if(retrn == INOUT_DOWN || retrn == INOUT_TAB) fld++; /* tab keys  */
	      if(retrn == INOUT_BACKTAB || retrn == INOUT_UP) fld--;
	      if(retrn == INOUT_ESC) break;
	      if(retrn >= INOUT_F1 && retrn <= INOUT_F12 && vkey[0] == 'F') break;
	      if(fld<0 || fld >2)
		if((vkey[2]=='T'&&(retrn==17||retrn==18))
			|| (vkey[1]=='A' && (retrn==15||retrn==16))) break;
		else if(fld<0)	fld = 0;
		     else fld = 2;
	      if(retrn == INOUT_ENTER_KEY) break;
	      if(retrn == 0) ++fld;
	    } while(fld < 3);
	    strand(Data, mask);
	    *ret = retrn;
	    return;
	}

/*---------------SET INITIAL CONDITIONS----------*/
	textcolor(FG);
	textbackground(BG);
FailCheckRestart:
	gotoxy(X, Y);

	if((Mode == 1 || Mode == 2) && *ret == 1)
		retrn = 1;
	else
		retrn = 0;
	*ret = 0;

	if(Mode == INOUT_ENTER || Mode == INOUT_CLEAR)
	{	strspc(entry, len);
		if(show == INOUT_BLANKS)
			cputs(entry);
		else if(show == INOUT_UNDERSCORE)
			cputs(strnchr(temp,'_',len));
		else if(show != INOUT_NO_SHOW)
			cputs(strnchr(temp, '', len));
	}
	if(Mode==INOUT_CLEAR)
	{
	  if(Type==INOUT_INTEGER)
	    *( (int *) Data) = 0;
	  else if(Type == INOUT_LONG)
	    *( (long *) Data) = 0;
	  else if(Type == INOUT_REAL)
	    *( (double * ) Data) = 0;
	  else if(Type == INOUT_DOLLAR )
	    *( (double * ) Data) = 0;
	  else
	    strcpy(Data, entry);
	  return;
	}

	if(Mode>=1 && Mode <=3)
	  if(Type== INOUT_INTEGER)
	    itoa( *((int *) Data), entry, 10);
	  else if(Type == INOUT_LONG)
	    ltoa( *((long *) Data), entry, 10);
	  else if(Type== INOUT_REAL)
            sprintf(entry, "%f", *((double *) Data));
	  else if(Type== INOUT_DOLLAR)
	    sprintf(entry, "%-*f", len-3,  *((double *) Data));
	  else
	    strcpy(entry, Data);


	if(strlen(entry) > len)
		entry[len] = '\0';

	if(Mode >= 1 && Mode <= 3)
	{         /* display data */
	   lendata = strlen(rtrim(entry));
	   cputs((Type==5) ? strnchr(temp, 'X', lendata) : entry);
	   if(show != INOUT_NO_SHOW && lendata != len) {
	     gotoxy(X+lendata, Y);
	     cputs(strnchr(temp,(show==INOUT_BLANKS)?' ':(show==INOUT_UNDERSCORE)?'_':'', len-lendata));}
	}

	if(Mode==INOUT_DISPLAY) return;

	if(vkey[0] == 'F') Fkey = 1;
	if(vkey[1] == 'A') arrow = 1;
	if(vkey[2] == 'T') tabkey = 1;

	if(Mode == 1 && lendata < len)
		CursorX = lendata;
	else if( Mode == 1)
		CursorX = len -1;

	/* save old cursor & turn on cursor */
	OldCursor = GetCursor();
	OnCursor();
/*----------------MAIN LOOP--------------------------------*/
	for(; 1==1;)
	{
		MoveX = 0;

		if((lendata = strlen(entry)) < len)
			strspc(entry+lendata, len - lendata);
		gotoxy(X + CursorX, Y);

/*---------------GET INPUT-------------*/
		a = GetIdleCh();

		if(a == 0)
			a = 256 + getch();   /* extended characters */

		if(a >= 32 && a <=255)		/* valid character */
		{
			if(Type==0 || Type >1&&Type<=6||
			   a>='0' && a<='9' ||
			   (Type==INOUT_INTEGER||Type==INOUT_REAL||Type==INOUT_DOLLAR||Type==INOUT_LONG) && (a=='-' || a=='+')||
			   (Type == INOUT_REAL||Type == INOUT_DOLLAR) && a=='.')
			{  if(Type == INOUT_UPCASE) a = toupper(a);
			   putch((Type==5) ? 'X' : a);
			   entry[CursorX] = a;
			   MoveX = 1; } }
		else if(a == 8)	{		/* bs key */
			if(CursorX != 0) {
			  gotoxy(X+CursorX-1, Y);
			  lendata = rtrimlen(entry);
			  for(i = CursorX-1; i < lendata-1; ++i) {
			    entry[i] = entry[i+1];
			    putch((Type==5) ? 'X' : entry[i]); }
			  entry[i] = ' ';
			  putch((show==INOUT_BLANKS)?' ':(show==INOUT_UNDERSCORE)?'_':'');
			  MoveX = -1; } }
		else if(a == 9)			/* tab key */
			if(tabkey) {
			  *ret = 17;
			  break; }
			else {
			  if(CursorX+5 < rtrimlen(entry)) MoveX = 5; }
		else if(a == 13){        	/* Enter key */
			*ret = 13;
			break; }
		else if(a == 27) {			/* Esc key */
			*ret = 14;
			break; }
		else if(a >=315 && a <=324)		/* PF key */
			{   if(Fkey)
			    {	*ret = a - 314;
				break; } }
		else if(a==389 || a==390) {		/* F11 & 12 */
			if(Fkey) {
			  *ret = a - 378;
			  break; } }
		else if(a == 327)		/* home key */
			MoveX = (CursorX * -1);
		else if( a == 328)		/* up arrow */
			{   if(arrow)
			     {	*ret = 15;
				break; } }
		else if(a == 336)		/* down arrow */
			{  if(arrow)
			   {  *ret = 16;
			      break; } }
		else if(a == 335)		/* end key */
			MoveX = rtrimlen(entry) - CursorX;
		else if(a == 331)		/* left arrow */
			MoveX = -1;
		else if(a == 333 && CursorX < rtrimlen(entry))		/* right arrow */
			  MoveX = 1;
		else if(a == 339) {		/* del key */
			lendata = rtrimlen(entry);
			for(i=CursorX; i<lendata-1; ++i) {
			  entry[i] = entry[i+1];
			  putch((Type==5) ? 'X' : entry[i]); }
			entry[i] = ' ';
			  putch((show==INOUT_BLANKS)?' ':(show==INOUT_UNDERSCORE)?'_':'');}
		else if(a == 271)		/* backtab key */
			if(tabkey) {
			  *ret = 18;
			  break; }
			else MoveX = -5;

/*------------- CHECK END CONDITIONS --------*/
		if(CursorX + MoveX >= len && a > 30 && a < 256)
			break;

		if(CursorX + MoveX > len - 1)	MoveX = 0;
		if(CursorX + MoveX < 0)		MoveX = 0;
		CursorX = CursorX + MoveX;
	}

	if((retrn == 1 || Mode == 0) && CursorX +1 != len)
	{	gotoxy( X + CursorX, Y);          /* destructive enter */
		cputs(strnchr(temp,(show==INOUT_DOTS)?'':(show==INOUT_UNDERSCORE)?'_':' ', len - CursorX));
		strspc(entry + CursorX, len - CursorX);
	}

	if(Type == INOUT_SYSGEN && strcmp(entry, Data) && !CkBeep(CheckNum(entry))) {
	   strcpy(Data, entry);
	   Mode = INOUT_EDIT_END;
	   goto FailCheckRestart; }


	if(Type==INOUT_INTEGER)
	  *( (int *) Data) = atoi(entry);
	else if(Type == INOUT_LONG)
	  *( (long *) Data) = atol(entry);
	else if(Type == INOUT_REAL)
	  *( (double * ) Data) = atof(entry);
	else if(Type == INOUT_DOLLAR)
	  *( (double * ) Data) = atof(entry);
	else
	  strcpy(Data, entry);

	SetCursor(OldCursor);  /* return cursor to its original shape */
} /* inout */

char *strand(char *dest, const char *src)
{
   int i, len;
   len = strlen(src);
   for(i=0; i<len; ++i)
   {
     if(src[i] != ' ')
       dest[i] = src[i];
     if(dest[i] == '\0')
	dest[i] = ' ';
   }
   dest[i] = '\0';
   return(dest);
}

/* main()
{
	int ret=0;
        double ammount=250;

        clrscr();
	inout(5, 8, 7, WHITE, BLACK, &ammount, EDIT_BEG, DOLLAR, DOTS, "XXX", &ret);
}
 */



