#include <stdio.h>
#include <fcntl.h>
#include <io.h>

/*--------------------------------------------------------------*/
/*----------------------------- fgetln -------------------------*/
/*DESCRIPTION: Copies chars from the stream fp to dest until	*/
/*	a newline char is encountered.  Does not place the 	*/
/*	newline ch in dest.  Dest is null terminated.		*/
/*								*/
/*RETURNS: the address of dest or NULL on end of file or error	*/
/*USES: nothing							*/
/*IN: ffile.c 							*/
/*--------------------------------------------------------------*/

char *fgetln(char *dest, FILE *fp)
{
   int i;

   i=0;
   while((dest[i++]=fgetc(fp)) != '\n' && dest[i-1] != '\f')
     if(dest[i-1] == EOF) return(NULL);

   dest[i-1] = '\0';

   return(dest);
}

/*--------------------------------------------------------------*/
/*------------------------ textprinter -------------------------*/
/*DESCRIPTION: Due to a flaw in Turbo C that does not allow 	*/
/*	you to change the stdprn stream to text mode, a new	*/
/*	stream directed to the printer opened for text must	*/
/*	be used.                                              	*/
/*								*/
/*RETURNS: The address of a stream that will print to the 	*/
/*	   printer in text mode, or NULL on an error.		*/
/*								*/
/*USES: nothing							*/
/*IN: ffile.c 							*/
/*--------------------------------------------------------------*/

FILE *textprinter(void)
/*--------RETURNS A STREAM TO THE PRINTER IN TEXT MODE,
	a minor Turbo C miracle -------------------------*/
{
   FILE *textstream;
   int texthandle;

   if((texthandle = dup(fileno(stdprn))) == -1 ||
       setmode(texthandle, O_TEXT)==-1 ||
       (textstream = fdopen(texthandle, "wt"))==NULL)
		return(NULL);
   else
	return(textstream);
}

int RecordsOnFile(FILE *file, int RecordSize)
{
   long filelen;

   filelen = filelength(fileno(file));
   return((filelen==-1 || RecordSize<=0) ? 0: filelen/RecordSize);
}