#include <conio.h>
#include <alloc.h>
#include <stdio.h>
#include <funcs.h>

unsigned Max = 1000;

/*----------------------------------------------------------------*/
/*---------------------------wedit--------------------------------*/
/*			WINDOW EDIT				  */
/*								  */
/*DESCRIPTION: Creates a window for data entry with an option to  */
/*	check each line with CheckNum.  Writes the data to a file */
/*								  */
/*INPUT:                                                          */
/*    filename - name for output file                             */
/*    width    - width of the window                              */
/*    length   - length of the window                             */
/*    fcheck  - a function that performs a check on the    	  */
/*		  entries.  Returns 1 for a pass, 0 for fail.	  */
/*		  Passing NULL means no check will be performed.  */
/*USES: Frame, strspc, OnCursor, OffCursor			  */
/*----------------------------------------------------------------*/

wedit( const char *filename, int width, int length,
	int (*fcheck) (const char *))

{

  int i, key = '', move = 1, done = 1, LinMod;
  int x, y, cursorx = 0, cursory = 0, index = 0, count = 0;
  int TopWinElt = 0, OldWin= 3, movey = 0, movex = 0, tmp;
  FILE *fp;
  char *list;
  char buffer[26], action;
  FrameDataType Fr;
  void DisplayWeditWindow(char *list, int TopOfWin, int X, int Y, int W,
			int Length, int Count);
  void BuildWeditScreen();

/* end data declarations */

  action = AddAppend(filename);
  if (action == 'X') return(0);

  y = 14 - (length/2);
  x = 36 - (width/2);

  /*------------ALLOCATE MEMORY---------*/
  if((list = (char *) calloc(Max, width+1))==NULL)
  {
     message(0, " Not Enough Memory For Function. ");
     return(0);
  }

 /*-------------READ IN DATA FROM FILE------------*/
  if (action != 'O' && action != 'A')
    action = 'A';
  if (action == 'A')
    {
    if ((fp = fopen(filename, "rt")) != NULL)
      {
	 while (fgets(buffer, 26, fp) != NULL)
		memcpy(list+(count++)*(width+1), buffer, width);
	 TopWinElt = (count/length) * length;
	 cursory = count % length;
	 index = TopWinElt + cursory;
      }
      else  /* file not found */
	 action = 'O';
    }  /* append */

  BuildWeditScreen();

  /*-------------DISPLAY FRAME-------------*/
  Fr.clear = 2;
  Frame(&Fr);

  Fr.X = x - 1; Fr.Y = y - 1;
  Fr.L = length +2; Fr.W = width +2;
  Fr.F = CYAN; Fr.B = BLACK;
  Fr.BorderType = 0;
  Frame(&Fr);
  textattr(CYAN);
  OnCursor();

  /*-------------MAIN LOOP----------------*/
  while (done != 0)
  {
  /*-------------DISPLAY STATS------------*/
    if (move != 0)
    {
      WriteAt(20, 15, YELLOW, BLACK, "%-4d", index+1);

      WriteAt(20, 16, YELLOW, BLACK, "%-4d", count );

      WriteAt(20, 17, YELLOW, BLACK, "%-4d", Max-count );

      move = 0;
    }

  /*-------------DISPLAY WINDOW-----------*/
    if(OldWin != TopWinElt)
        DisplayWeditWindow(list, TopWinElt, x, y, width, length, count);
    gotoxy(x + cursorx, y+cursory);
    OldWin = TopWinElt;


  /*-------------GET KEY STROKE------------*/
    key = getch();

    if (key == '\0')
      key = 256 + getch();
    else if (key >=32 && key <= 256)
    {
	putch(key);
	*(list+index*(width+1) + cursorx) = key;
	movex++;
    }

    switch (key){
	case 324:   /* F10 asc 0, 68         */
          done=0;
          break;
	case 328:   /* Up arrow asc 0, 72    */
	  --movey;
          break;
	case 336:   /* Down arrow asc 0, 80  */
	  movey++;
          break;
	case 333:   /* Right arrow asc 0, 77 */
	  movex++;
          break;
	case 331:   /* Left arrow asc 0, 75  */
	  movex--;
          break;
        case 13:   /* Enter asc 13       */
	  movex = -cursorx;
	  movey++;
          break;
	case 327:   /* Home asc 0, 71        */
	  movey = -index;
	  movex = -cursorx;
          break;
	case 335:   /* End Key asc 0, 79        */
	  movey = count - index -1;
	  movex = -cursorx;
          break;
	case 329:   /* Pageup Key asc 0, 73        */
	  movey -= length;
          break;
	case 337:   /* Page down Key asc 0, 81        */
	  movey += length;
          break;
	case  8:   /* BackSpace asc 8    */
	  if(cursorx != 0) {
	     gotoxy(x+cursorx-1, y+cursory);
	     for(i = cursorx-1; i< width-1; ++i) {
		*(list+index*(width+1)+i) = *(list+index*(width+1)+i+1);
		putch(*(list+index*(width+1)+i)); }
	     *(list+index*(width+1)+i) = ' ';
	     putch(' ');
	     movex--; }
	  break;
	case 339:  /*  Del key  asc 0, 83*/
	    for(i = cursorx; i< width -1; ++i) {
	       *(list+index*(width+1)+i) = *(list+index*(width+1)+i+1);
	       putch(*(list+index*(width+1)+i)); }
	    *(list+index*(width+1)+i) = ' ';
	    putch(' ');
	  break;
        default:
          break;
    } /* end switch */


/*-----------PROCESS KEY STROKE-----------*/
    if(movex + cursorx > width - 1) {
       movex = -cursorx;
       movey++; }
    else if(movex + cursorx < 0) {
       movex = width - cursorx -1;
       movey--; }

/*------------ CHECK FOR A VALID NUMBER----------*/
   if (fcheck != NULL)
    {
       if (key >= 48 && key <= 125)  LinMod = 1;
       if (LinMod && movey)
       {   if( !CkBeep(fcheck(list+index*(width+1))))
	   {   movex = 0;
	       movey = 0;
	   }
	   LinMod = 0;
       }
    }

    if(movey + cursory > length-1)
    {   /* past bottom of window */
       if((tmp = (index + movey) / length * length ) < Max)
       {
		TopWinElt = tmp;
		movey = -(cursory - (cursory+movey) % length);
       }
    }
    else if(movey + cursory < 0)    /* past top of window */
       if(index + movey >= 0) {      /* check for top of list */
	  TopWinElt = (index + movey)/length *length;
	  movey = -(cursory - (index + movey) % length); }
       else
	  movey = 0;

    if(index +1 > count && !blanks(list+index*(width+1))) {
       count = index +1;
       ++move; }

    cursorx += movex;
    if(TopWinElt+cursory+movey< Max)
	cursory += movey;
    else /* tried to go past max limit */
    {
	Beep(250, 2); delay(100);
	Beep(250, 2); delay(100);
	Beep(250, 2);
    }

    if(movey || OldWin != TopWinElt) ++move;
    movex = movey = 0;

    index = TopWinElt + cursory;

  } /* end while */

 /*-------------WRITE TO THE FILE-------------*/
  if ((fp = fopen(filename, "wt")) != NULL)
    for (i=0; i<count; i++)
      if(!blanks(list+i*(width+1)))
	fprintf( fp, "%s\n", list+i*(width+1));

  fclose( fp );
  free(list);

  clrscr();
  return(1);

}  /* end wedit */

void DisplayWeditWindow(char *list, int TopOfWin, int X, int Y, int W,
			int Length, int Count)
{

  int i;

  if (TopOfWin < 0) TopOfWin = 0;

  for (i = TopOfWin; i < TopOfWin + Length; i++)
      if(i < Count)   /* output data */
	WriteAt(X, Y+i-TopOfWin, CYAN, BLACK, list+i*(W+1));
      else     /* past entries, so print blanks */
	WriteAt(X, Y+i-TopOfWin, CYAN, BLACK, "%*s", W, " ");
}
/*
void main()
{
   wedit("invite.dat", 9, 10, CheckNum);
}
*/