#include <funcs.h>
#include <stdarg.h>
/*----------------------------message------------------------------*/
/*DESCRIPTION: Displays a message on the bottom of the screen and  */
/* prompts to press a key to recover. 				   */
/*								   */
/*INPUT:							   */
/* 	message = message to be displayed			   */
/* 	recover = 0 -- "ANY KEY"				   */
/* 	recover = 1 -- "ANY KEY TO CONTINUE"			   */
/* 	recover = 2 -- "ANY KEY TO RECOVER"			   */
/* 	recover = 3 -- ""					   */
/*RETURNS: the character entered				   */
/*								   */
/*USES: Frame, GetCursor, OffCursor, SetCursor, GetIdleCh          */
/*-----------------------------------------------------------------*/
char SOUND=1;
char message(int recover, char *format, ... )
{
  char outstr[81];
  va_list arg_ptr;
  FrameDataType F;
  char *recov[] = {"", "(Any Key)", "(Any Key To Continue)",
		"(Any Key To Recover)" };
  char line[79], buff[481], ch;
  char message[81];
  unsigned int  OldCursor;
  int toupper(int ch);

  va_start(arg_ptr, format);
  vsprintf(message, format, arg_ptr);

  OldCursor = GetCursor();
  OffCursor();

  SaveScrn(0, 23, 80, 3, buff);

  if(recover < 0 || recover > 3) recover = 3;
  if(strlen(message) > 78 - strlen(recov[recover]))
    message[78-strlen(recov[recover])] = '\0';

  sprintf(line, " %s %s ", message, recov[recover]);

  F.txt[0] = line;
  F.X = 39-strlen(line)/2; F.Y = 23;
  F.L = 3; F.W = strlen(line)+2;
  F.F = 15; F.B = 4;
  F.BorderType = 2;
  F.clear = 10;  /* no shadow */
  Frame(&F);

  if(SOUND)
     Beep(900, 5);

  ch = toupper(GetIdleCh());

  RestScrn(0, 23, 80, 3, buff);

  SetCursor(OldCursor);
  return(ch);
}

/*main()
{
  NewClear(7,0);
  message("You just got a pay raise.", 2);
}*/