#include "funcs.h"
extern int FG, BG;
/*---------------------- getrange-------------------------------*/
/*DESCRIPTION:	This funcion get startng and ending ranges.	*/
/*								*/
/*INPUT:							*/
/*	prompt = prompt All Entries?  		                */
/*	total = total number to select          	        */
/*	start = starting number of range                	*/
/*	stop = ending number of range	   		        */
/*RETURNS 0 on success						*/
/*       -1 on invalid entry or escape				*/
/*USES: GetCursor, SetCursor, OffCursor, OnCursor, Frame	*/
/*IN: grange.c							*/
/*--------------------------------------------------------------*/

getrange(char *prompt, int total, int *start, int *stop)

{
	int	ans;
	char	buff[36];
	FrameDataType	Fr;
	unsigned int  OldCursor;

	if(total <=0) return(-1);

	OldCursor = GetCursor();
	OffCursor();

	Fr.clear = 2;
	Frame(&Fr);

	Fr.X = 25; Fr.Y = 6;
	Fr.F = (FG==-1)? 7: FG;
	Fr.B = (BG==-1)? 5: BG;
	Fr.L = 5; Fr.W = 36;
	Fr.txt[1] = buff;
	sprintf(Fr.txt[1], "  %s All Entries? (Y/N)", prompt);
	Frame(&Fr);

	do
	{
/*--------LOOP UNTIL 'Y' OR 'N' OR ESC-------------*/
		gotoxy(54, 8);
		ans = toupper(getch());
		if (ans == 27)
			return(-1);
		if (ans == 'Y')
		{
			*start = 1;
			*stop = total;
		}

		if (ans == 'N')
		{
			OnCursor();
			Fr.X = 23; Fr.Y = 7;
			Fr.F = 7; Fr.B = 1;
			Fr.L = 10; Fr.W = 34;
			Fr.txt[1] = buff;
			sprintf(Fr.txt[1], "   There are %d to %s", total, prompt);
			Fr.txt[3] = "     Starting at --> ";
			Fr.txt[5] = "     Stopping at --> ";
			Frame(&Fr);
			gotoxy(45, 11);
			scanf("%d", start);
			gotoxy(45, 13);
			scanf("%d", stop);

			if (*start < 0 || *stop < 0 || *start > total)
			{
				SetCursor(OldCursor);
				return(-1);
			}
			if (*stop > total)
				*stop = total;
		}
	} while(ans != 'Y' && ans != 'N');

	SetCursor(OldCursor);
	return(0);
}
