#include <dos.h>
#define MONO 7
int vid_mode = -1;

/*-------------------SetCursor--------------------------*/
/*DESCRIPTION: Sets the shape of the cursor.		*/
/*							*/
/*USES: nothing 					*/
/*IN: cursor.c						*/
/*------------------------------------------------------*/
void SetCursor(unsigned int shape)
{
 union REGS reg;

 reg.h.ah = 1;
 reg.x.cx = shape;
 int86(0X10, &reg, &reg);
} /* setcursor */

/*----------------------------OffCursor-----------------*/
/*DESCRIPTION: Turns off the cursor.		        */
/*							*/
/*USES: SetCursor					*/
/*IN: cursor.c						*/
/*------------------------------------------------------*/

OffCursor()
{
	unsigned int nocursor = 0x2000;
	SetCursor(nocursor);
}

/*----------------------------OnCursor--------------------------*/
/*DESCRIPTION: Sets the cursor to a short blinking size.	*/
/*	Must be modified for MONO screens.			*/
/*								*/
/*USES: SetCursor						*/
/*IN: cursor.c							*/
/*--------------------------------------------------------------*/

OnCursor()
{
	if(vid_mode==-1)
	  vid_mode = video_mode();

	SetCursor((vid_mode==MONO) ? 0x0A0C : 0x0607);

/*	unsigned int shortcursor = 0x0607;  for MONO screens = 0x0A0C
	SetCursor(shortcursor);             see mcdisply.c initcursor() */
}

/*---------------------------GetCursor--------------------------*/
/*DESCRIPTION: Gets the shape of the current cursor.		*/
/*								*/
/*RETURNS: a number that may be passed to SetCursor             */
/*USES: nothing							*/
/*IN: cursor.c							*/
/*--------------------------------------------------------------*/

unsigned int GetCursor(void)
{
 union REGS reg;

 reg.h.ah = 3;
 reg.h.bh = 0;
 int86(0X10, &reg, &reg);
 return(reg.x.cx);
} /* getcursor */


