#include <conio.h>
#include <stdarg.h>
int savX=1, savY=1, savATT;

/*---------------------Write AT-----------------------------*/
/*                                                          */
/* DESCRPTION: Writes a string to the console or screen     */
/*              at the column and row in the foreground and */
/*              background.                                 */
/*                                                          */
/* INPUT:                                                   */
/*    X	     - screen row       (1-25)                      */
/*    Y      - screen column    (1-80)                      */
/*    fore   - foreground color                             */
/*    back   - background color                             */
/*    format - format of outputted string in printf format  */
/*    ...    - list of arguments                            */
/*                                                          */
/* USES: dma_puts                                           */
/*----------------------------------------------------------*/

void WriteAt( int X, int Y, int fore, int back, char *format, ... )
{
  char outstr[81];
  va_list arg_ptr;

  va_start(arg_ptr, format);
  vsprintf(outstr, format, arg_ptr);

  dma_puts((savX=X), (savY=Y), (savATT=fore+(back<<4)), outstr);

  return;                    /*  Successful Return */
}

/*---------------------------Write----------------------*/
/*							*/
/* DESCRIPTION: Must be preceeded by a call to WriteAt. */
/*	Writes a string to the screen beginning a row   */
/*	below the string written with WriteAt.		*/
/*							*/
/* USES: dma_puts  					*/
/* IN: writeat.c					*/
/*------------------------------------------------------*/

void Write(char *format, ...)
{
  char outstr[81];
  va_list arg_ptr;

  va_start(arg_ptr, format);
  vsprintf(outstr, format, arg_ptr);

  dma_puts(savX, ++savY, savATT, outstr);
}


/*-------------------------WriteDS-----------------------*/
/*							 */
/* DESCRIPTION: Must be preceeded by a call to WriteAt.  */
/*	Writes a string to the screen beginning two rows */
/*	below the string written with WriteAt.		 */
/*							 */
/* USES: dma_puts					 */
/* IN: writeat.c					 */
/*-------------------------------------------------------*/

void WriteDS(char *format, ...)
{
  char outstr[81];
  va_list arg_ptr;

  va_start(arg_ptr, format);
  vsprintf(outstr, format, arg_ptr);

  savY += 2;
  dma_puts(savX, savY, savATT, outstr);
}

/* #include <time.h>
main()
{
   clock_t start, end;
   register int i;

   start = clock();
   for(i=0; i<3000; ++i)
     writeatf(10, 6, BLUE, GREEN, "hi world from writeatf .");
   end = clock();
   printf("time for writeatf was : %f\n", (end-start) / CLK_TCK);

   start = clock();
   for(i=0; i<3000; ++i)
     writeatf(10, 8, BLUE, GREEN, "hi world from writeatf %d.", -6);
   end = clock();
   printf("time for writeatf was : %f\n", (end-start) / CLK_TCK);

   start = clock();
   for(i=0; i<3000; ++i)
     WriteAt(10, 10, BLUE, GREEN, "hi world from WriteAt %d.");
   end = clock();
   printf("time for WriteAt was : %f\n", (end-start) / CLK_TCK);

}  */