/*----------------------------select-------------------------------*/
/*DESCRIPTION: Displays text and allows the user to choose one     */
/*	of the displayed lines.					   */
/*								   */
/*INPUT:
	X & Y - coordinates the upper left corner of the first
		choice appears at
	TotChoices - number of choices
	Choices - string of chars, 1 char for each choice & the char
		  for the chosen choice is returned.
	Text - array of pointers to char that point to the text
		to be displayed
	TextColor, BGcolor - foreground & background text color
	BarColor - color of selection bar
	BarTextColor - color of text in bar
	Abort - 0 accept Esc key
	Abort - 1 don't accept Esc key
	Abort - 10 accept Esc & print double space
	Abort - 11 don't accept Esc key & print double space
	default - char from list of choices to specify the default bar
RETURNS: corresponding char in Choices of selection.
	or 27 if Esc pressed
USES: strspc, GetCursor, OffCursor, SetCursor
-------------------------------------------------------------------*/

char select(int X, int Y, int TotChoices, char *Choices, char *Text[],
		int TextColor, int BGcolor, int BarColor,
		int BarTextColor, int Abort, char defalt)
{

	int	MaxChoi, CurBar, MovBar, i, len, BarLen = 0, Choice, a;
	unsigned int	OldCursor, spacing;
	char *strspc(char *s, int n);

/*---------PRINT THE CHOICES-----------------*/
	if (Abort >=10)
	  spacing = 2;
	else
	  spacing = 1;

	for(i = 0; i < TotChoices; ++i)
	{
	  len = strlen(Text[i]);
	  if(len > BarLen) BarLen = len;
	}
	BarLen++;
	for(i = 0; i < TotChoices; ++i)
	  WriteAt(X, Y + i*spacing, TextColor, BGcolor, " %-*s",
			BarLen, Text[i]);

	OldCursor = GetCursor();
	OffCursor();


	MaxChoi = TotChoices -1;
	CurBar = 0;
	/* initialize the bar to the default parameter */
	for(i=0; i<TotChoices; ++i)
	  if(defalt== Choices[i]) {
	    MovBar = i;
	    break; }
	if(i>=TotChoices)
	  MovBar = 0;

	Choice = -1;

	for(;1==1;)
	{
	  /*--------CLEAR OLD BAR--------*/
	  if(CurBar != MovBar)
	  {
	    WriteAt(X, Y + CurBar*spacing, TextColor, BGcolor, " %-*s",
			BarLen, Text[CurBar]);
	  }

	  /*---------DISPLAY NEW BAR--------*/
	  WriteAt(X, Y + MovBar*spacing, 4, BarColor, "%c", 16);
	  WriteAt(X+1, Y + MovBar*spacing, BarTextColor, BarColor, "%-*s",
		BarLen, Text[MovBar]);

/*	  textbackground(BarColor);
	  gotoxy(X, Y + MovBar*spacing);
	  textcolor(4);
	  putch(16);
	  textcolor(BarTextColor);
	  cputs(line[MovBar]); */
	  CurBar = MovBar;

	  if(Choice > 0 ) break;

	/*-------- GET INPUT---------*/
	  a = toupper(GetIdleCh());
	  if(a == 0)  a = 256 + getch();
	  for(i = 0; i< TotChoices; ++i)
	    if(a == Choices[i])
	    {
	      Choice = Choices[i];
	      MovBar = i;
	    }

	  if( a == 27 && (Abort) % 10 != 1)		/* Esc key */
	  {
	     SetCursor(OldCursor);
	     return(a); /* return 27 for Esc */
	  }
	  else if(a == 13)	/* enter pressed */
	    Choice = Choices[CurBar];
	  else if(a == 327) 	/* home key */
	    MovBar = 0;
	  else if(a == 335)	/* end key */
	    MovBar = MaxChoi;
	  else if(a == 336 || a == 333)	/* down or right arrow */
	    MovBar = CurBar + 1;
	  else if(a == 328 || a == 331) /* up or left arrow */
	    MovBar = CurBar -1;

	  if(MovBar > MaxChoi) MovBar = 0;
	  if(MovBar < 0) MovBar = MaxChoi;

	}

	SetCursor(OldCursor);	/* return cursor to its original shape */

	return(Choice);
}

/* main()
{
  char *text[] = {"option uno", "option dose a mondo rama jama",
		  "option thrace"};
  char choices[] = "123";
  int abort;

  NewClear(1, 0);
  select(30, 8, 3, choices, text, 15, 1, 3, 7, &abort);
} */