/*****************************************************************************
 *
 *                               DCAAPI.h
 *
 *****************************************************************************
 *
 *     Include file describing the Lattice 'C' interface to the HLLAPI.
 *
 *     (C) Copyright Digital Communications Associates, Inc. 1987.
 *     All Rights Reserved.
 *
 ****************************************************************************/

/*
 * PCB_request_code values:
 */
#define PCB_GATEWAY             0
#define PCB_CONNECT             1
#define PCB_DISCONNECT          2
#define PCB_SEND_KEY            3
#define PCB_WAIT                4
#define PCB_COPYPS              5
#define PCB_SEARCH              6
#define PCB_GET_POSITION        7
#define PCB_COPY_STRING         8
#define PCB_SET_PARAMS          9
#define PCB_QUERY               10
#define PCB_RESERVE             11
#define PCB_RELEASE             12
#define PCB_COPYOIA             13
#define PCB_GET_FLD_ATTR        14
#define PCB_COPY_TO_PS          15
#define PCB_WSCTRL              16
#define PCB_PAUSE               18
#define PCB_QUERY_SYSTEM        20
#define PCB_RESET_SYSTEM        21
#define PCB_QUERY_SESS_STAT     22
#define PCB_START_HOST_NTFY     23
#define PCB_QUERY_UPDATE        24
#define PCB_STOP_HOST_NTFY      25
#define PCB_FLD_SEARCH          30
#define PCB_FIND_FLD_POS        31
#define PCB_FIND_FLD_LEN        32
#define PCB_COPY_STR_TO_FLD     33
#define PCB_COPY_FLD_TO_STR     34
#define PCB_SEND_FILE           90
#define PCB_RECV_FILE           91
#define PCB_INVOKE_PGM          92
#define PCB_DOS_REDIRECT        93
#define PCB_CONVERT             99
#define PCB_Q_DCA               255




/*
 * PCB_return_code values:
 */
/*      1 - Connect Presentation Space */
#define PCB_RC_CONNECT_OK                   0       /* successful */
#define PCB_RC_CONNECT_FAIL_SESSION         1       /* failure, unable to connect */
#define PCB_RC_CONNECT_OK_WSCTRL            3       /* successful, connected to WSCTRL */
#define PCB_RC_CONNECT_OK_BUSY              4       /* successful, but busy  */
#define PCB_RC_CONNECT_OK_LOCKED            5       /* successful, but locked */
#define PCB_RC_CONNECT_FAIL_SYSTEM          9       /* failure, system error */

/*      2 - Disconnect Presentation Space */
#define PCB_RC_DISCONNECT_OK                0       /* successful */
#define PCB_RC_DISCONNECT_FAIL_PROGRAM      1       /* failure, program not connected */
#define PCB_RC_DISCONNECT_FAIL_SYSTEM       9       /* failure, system error */

/*      3 - Send Key */
#define PCB_RC_SEND_KEY_OK                  0       /* successful */
#define PCB_RC_SEND_KEY_FAIL_SESSION        1       /* failure, not connected to a valid session */
#define PCB_RC_SEND_KEY_FAIL_PARAMS         2       /* failure, bad parameter sent */
#define PCB_RC_SEND_KEY_OK_WSCTRL           3       /* successful, in WSCTRL */
#define PCB_RC_SEND_KEY_FAIL_BUSY           4       /* failure, session busy */
#define PCB_RC_SEND_KEY_FAIL_LOCKED         5       /* failure, session locked */
#define PCB_RC_SEND_KEY_FAIL_SYSTEM         9       /* failure, system error */

/*      4 - Wait */
#define PCB_RC_WAIT_OK                      0       /* successful */
#define PCB_RC_WAIT_FAIL_SESSION            1       /* failure, not connected to a valid session */
#define PCB_RC_WAIT_OK_WSCTRL               3       /* successful, in WSCTRL */
#define PCB_RC_WAIT_FAIL_BUSY               4       /* failure, session  busy  */
#define PCB_RC_WAIT_FAIL_LOCKED             5       /* failure, session locked */
#define PCB_RC_WAIT_FAIL_SYSTEM             9       /* failure, system error */

/*      5 - Copy Presentation Space */
#define PCB_RC_COPYPS_OK                    0       /* successful */
#define PCB_RC_COPYPS_FAIL_SESSION          1       /* failure, not connected to a valid session */
#define PCB_RC_COPYPS_FAIL_PARAMS           2       /* failure, invalid length */
#define PCB_RC_COPYPS_FAIL_WSCTRL           3       /* failure, in WSCTRL */
#define PCB_RC_COPYPS_OK_BUSY               4       /* successful, session  busy  */
#define PCB_RC_COPYPS_OK_LOCKED             5       /* successful, session locked */
#define PCB_RC_COPYPS_FAIL_SYSTEM           9       /* failure, system error */

/*      6 - Search Presentation Space */
#define PCB_RC_SEARCH_OK                    0       /* successful */
#define PCB_RC_SEARCH_FAIL_SESSION          1       /* failure, never connected to ps */
#define PCB_RC_SEARCH_FAIL_PARAMS           2       /* failure, bad parameter */
#define PCB_RC_SEARCH_FAIL_POSITION         7       /* failure, invalid position */
#define PCB_RC_SEARCH_FAIL_SYSTEM           9       /* failure, system error */
#define PCB_RC_SEARCH_FAIL_NOT_FND         24      /* failure, string not found */

/*      7 - Query Cursor Location */
#define PCB_RC_GETPOS_OK                    0       /* successful */
#define PCB_RC_GETPOS_FAIL_SESSION          1       /* failure, not connected */
#define PCB_RC_GETPOS_FAIL_WSCTRL           3       /* failure, connected to wsctrl */
#define PCB_RC_GETPOS_FAIL_SYSTEM           9       /* system error */

/*      8 - Copy Presentation Space to String */
#define PCB_RC_COPY_STRING_OK               0       /* successful */
#define PCB_RC_COPY_STRING_FAIL_SESSION     1       /* failure, not connected */
#define PCB_RC_COPY_STRING_FAIL_PARAMS      2       /* failure, bad parameter */
#define PCB_RC_COPY_STRING_FAIL_WSCTRL      3       /* failure, in WSCTRL */
#define PCB_RC_COPY_STRING_OK_BUSY          4       /* successful, session  busy  */
#define PCB_RC_COPY_STRING_OK_LOCKED        5       /* successful, session locked */
#define PCB_RC_COPY_STRING_FAIL_POS         7       /* failure, invalid position */
#define PCB_RC_COPY_STRING_FAIL_SYSTEM      9       /* failure, system error */

/*      9 - Set Session Parameters */
#define PCB_RC_SET_PARAMS_OK                0       /* successful */
#define PCB_RC_SET_PARAMS_FAIL_PARAMS       2       /* failure, bad parameter length */
#define PCB_RC_SET_PARAMS_FAIL_SYSTEM       9       /* failure, system error */

/* 10 - Query Sessions */
#define PCB_RC_QUERY_OK                     0       /* successful */
#define PCB_RC_QUERY_FAIL_PARAMS            2       /* failure, bad parameters */
#define PCB_RC_QUERY_FAIL_SYTSTEM           9       /* failure, system error */

/* 11 - Reserve */
#define PCB_RC_RESERVE_OK                   0       /* successful */
#define PCB_RC_RESERVE_FAIL_SESSION         1       /* failure, not connected to a valid session */
#define PCB_RC_RESERVE_FAIL_LOCKED          5       /* failure, session locked */
#define PCB_RC_RESERVE_FAIL_SYSTEM          9       /* failure, system error */

/* 12 - Release */
#define PCB_RC_RELEASE_OK                   0       /* successful */
#define PCB_RC_RELEASE_FAIL_SESSION         1       /* failure, not connected to a valid session */
#define PCB_RC_RELEASE_FAIL_SYSTEM          9       /* failure, system error */

/* 13 - Copy OIA */
#define PCB_RC_COPYOIA_OK                   0       /* successful */
#define PCB_RC_COPYOIA_FAIL_SESSION         1       /* failure, not connected to a valid session */
#define PCB_RC_COPYOIA_FAIL_PARAMS          2       /* failure, invalid length */
#define PCB_RC_COPYOIA_INCOMPL_BUSY         4       /* copy incomplete, session  busy  */
#define PCB_RC_COPYOIA_INCOMPL_LOCKED       5       /* copy incomplete, session locked */
#define PCB_RC_COPYOIA_FAIL_SYSTEM          9       /* failure, system error */

/* 14 - Query Field Attribute */
#define PCB_RC_GETFLDATTR_OK                0       /* successful */
#define PCB_RC_GETFLDATTR_FAIL_SESSION      1       /* failure, not connected to a valid session */
#define PCB_RC_GETFLDATTR_FAIL_POS          7       /* failure, invalid position */

/* 15 - Copy String to Presentation Space   */
#define PCB_RC_COPY_TO_PS_OK                0       /* successful, at least one byte copied */
#define PCB_RC_COPY_TO_PS_FAIL_SESSION      1       /* failure, not connected to a valid session */
#define PCB_RC_COPY_TO_PS_FAIL_BUSY         2       /* failure, none copied, keyboard busy  */
#define PCB_RC_COPY_TO_PS_FAIL_LOCKED       3       /* failure, none copied, keyboard locked */
#define PCB_RC_COPY_TO_PS_FAIL_PROT         4       /* failure, none copied, target ps is protected */
#define PCB_RC_COPY_TO_PS_FAIL_ATTR         5       /* failure, none copied, copying of field attrb not allowed */     
#define PCB_RC_COPY_TO_PS_OK_TRUNCATED      6       /* Successful, at least 1 copied, at least 1 not copied */
#define PCB_RC_COPY_TO_PS_FAIL_POSITION     7       /* failure, invalid position */
#define PCB_RC_COPY_TO_PS_FAIL_SYSTEM       9       /* failure, system error */

/* 16 - WS Ctrl */
#define PCB_RC_WSCTRL_OK                    0       /* successful */
#define PCB_RC_WSCTRL_FAIL_SESSION          1       /* failure, invalid session id */
#define PCB_RC_WSCTRL_FAIL_PARAMS           2       /* failure, bad parameters */
#define PCB_RC_WSCTRL_FAIL_WSC_OWNED        3       /* failure, WSC is owned by another session */
#define PCB_RC_WSCTRL_FAIL_LOCKED           5       /* failure, target is inhibited or protected */
#define PCB_RC_WSCTRL_FAIL_SPEC             6       /* failure, WSC is invalid */
#define PCB_RC_WSCTRL_FAIL_SYSTEM           9       /* failure, system error */

/* 18 - Pause */
#define PCB_RC_PAUSE_OK                     0       /* successful */
#define PCB_RC_PAUSE_FAIL_SYSTEM            9       /* failure, system error */
#define PCB_RC_PAUSE_OK_HOST_NOTIFY        26       /* successful, host ps or oia has changed */

/* 20 - Query System */
#define PCB_RC_QUERY_SYS_OK                 0       /* successful */
#define PCB_RC_QUERY_SYS_FAIL_PARAMS        2       /* failure, bad parameters */
#define PCB_RC_QUERY_SYS_FAIL_SYSTEM        9       /* failure, system error */

/* 21 - Reset System */
#define PCB_RC_RESET_SYSTEM_OK              0       /* successful */
#define PCB_RC_RESET_SYSTEM_FAIL_SYSTEM     9       /* failure, system error */

/* 22 - Query Session Status */
#define PCB_RC_QUERY_SESS_OK                0       /* successful */
#define PCB_RC_QUERY_SESS_FAIL_SESSION      1       /* failure, invalid session */
#define PCB_RC_QUERY_SESS_FAIL_PARAMS       2       /* failure, bad parameters */
#define PCB_RC_QUERY_SESS_FAIL_WSCTRL       3        /* failure, WSC is invalid */
#define PCB_RC_QUERY_SESS_FAIL_SYSTEM       9       /* failure, system error */

/* 23 - Start Host Notification */
#define PCB_RC_START_H_NTFY_OK              0       /* successful */
#define PCB_RC_START_H_NTFY_FAIL_SESS       1       /* failure, invalid session */
#define PCB_RC_START_H_NTFY_FAIL_PARAMS     2       /* failure, bad parameters */
#define PCB_RC_START_H_NTFY_FAIL_SYS        9       /* failure, system error */

/* 24 - QUERY Host Update */
#define PCB_RC_QUERY_UPDATE_OK              0       /* successful, no updates */
#define PCB_RC_QUERY_UPDATE_FAIL_SESS       1       /* failure, invalid session */
#define PCB_RC_QUERY_UPDATE_FAIL_NO_HN      8       /* failure, no previous Start HN issued */
#define PCB_RC_QUERY_UPDATE_FAIL_SYS        9       /* failure, system error */
#define PCB_RC_QUERY_UPDATE_OK_OIA         21       /* successful, OIA updated */
#define PCB_RC_QUERY_UPDATE_OK_PS          22       /* successful, ps updated */
#define PCB_RC_QUERY_UPDATE_OK_BOTH        23       /* successful, both updated */

/* 25 - Stop Host Notification */
#define PCB_RC_STOP_H_NTFY_OK               0       /* successful */
#define PCB_RC_STOP_H_NTFY_FAIL_SESS        1       /* failure, invalid session */
#define PCB_RC_STOP_H_NTFY_FAIL_NO_HN       8       /* failure, no previous Start HN issued */
#define PCB_RC_STOP_H_NTFY_FAIL_SYS         9       /* failure, system error */

/* 30 - Search Field */
#define PCB_RC_SEARCH_FLD_OK                0       /* successful */
#define PCB_RC_SEARHC_FLD_FAIL_SESS         1       /* failure, invalid session */
#define PCB_RC_SEARCH_FLD_FAIL_POS          7       /* failure, invalid position */
#define PCB_RC_SEARCH_FLD_FAIL_SYS          9       /* failure, system error */
#define PCB_RC_SEARCH_FLD_FAIL_NOT_FND     24       /* failure, string not found */

/* 31 - Find Field Position */
#define PCB_RC_FND_FLD_POS_OK               0       /* successful */
#define PCB_RC_FND_FLD_POS_FAIL_SESS        1       /* failure, invalid session */
#define PCB_RC_FND_FLD_POS_FAIL_PARAMS      2       /* failure, bad parameters */
#define PCB_RC_FND_FLD_POS_FAIL_POS         7       /* failure, invalid position */
#define PCB_RC_FND_FLD_POS_FAIL_SYS         9       /* failure, system error */
#define PCB_RC_FND_FLD_POS_FAIL_NOTFND     24       /* failure, string not found */

/* 32 - Find Field Length */
#define PCB_RC_FND_FLD_LEN_OK               0       /* successful */
#define PCB_RC_FND_FLD_LEN_FAIL_SESS        1       /* failure, invalid session */
#define PCB_RC_FND_FLD_LEN_FAIL_PARAMS      2       /* failure, bad parameters */
#define PCB_RC_FND_FLD_LEN_FAIL_POS         7       /* failure, invalid position */
#define PCB_RC_FND_FLD_LEN_FAIL_SYS         9       /* failure, system error */
#define PCB_RC_FND_FLD_LEN_FAIL_NOTFND     24       /* failure, string not found */

/* 33 - Copy String to Field */
#define PCB_RC_COPY_STRTOFLD_OK             0       /* successful */
#define PCB_RC_COPY_STRTOFLD_FAIL_SESS      1       /* failure, invalid session */
#define PCB_RC_COPY_STRTOFLD_FAIL_BUSY      2       /* failure, none copied, keyboard busy  */
#define PCB_RC_COPY_STRTOFLD_FAIL_LOCKED    3       /* failure, none copied, keyboard locked */
#define PCB_RC_COPY_STRTOFLD_FAIL_PROT      4       /* failure, none copied, target ps is protected */
#define PCB_RC_COPY_STRTOFLD_FAIL_ATTR      5       /* failure, none copied, copying of field attrb not allowed */     
#define PCB_RC_COPY_STRTOFLD_OK_SIZE        6       /* successful, length not equal to fld size */
#define PCB_RC_COPY_STRTOFLD_FAIL_POS       7       /* failure, invalid position */
#define PCB_RC_COPY_STRTOFLD_FAIL_SYS       9       /* failure, system error */

/* 34 - Copy Field to String */
#define PCB_RC_COPY_FLDTOSTR_OK             0   /* successful */
#define PCB_RC_COPY_FLDTOSTR_FAIL_SESS      1   /* failure, invalid session */
#define PCB_RC_COPY_FLDTOSTR_FAIL_PARMS     2   /* failure, invalid parameters */
#define PCB_RC_COPY_FLDTOSTR_OK_SIZE        6   /* successful, length not equal to fld size */
#define PCB_RC_COPY_FLDTOSTR_FAIL_POS       7   /* failure, invalid position */
#define PCB_RC_COPY_FLDTOSTR_FAIL_SYS       9   /* failure, system error */

/* 90 - Send File - other return codes are returned from Send */
#define PCB_RC_SEND_FILE_FAIL_PARAMS        2   /* failure, bad parameters */
#define PCB_RC_SEND_FILE_FAIL_SYSTEM        9   /* failure, system error */

/* 91 - Receive File - other return codes are returned from Receive */
#define PCB_RC_RECV_FILE_FAIL_PARAMS        2   /* failure, bad parameters */
#define PCB_RC_RECV_FILE_FAIL_SYSTEM        9   /* failure, system error */

/* 90 through 93 - Invoke DOS programs - DOS Return Codes */
#define PCB_RC_DOS_FAIL_INV_FUNC          301   /* failure, invalid function number */
#define PCB_RC_DOS_FAIL_FILE_NOT_FND      302   /* failure, file not found */
#define PCB_RC_DOS_FAIL_PATH_NOT_FND      303   /* failure, path not found */
#define PCB_RC_DOS_FAIL_NO_ACCESS         305   /* failure, access denied */
#define PCB_RC_DOS_FAIL_INSUFF_MEMORY     308   /* failure, insufficient memory */
#define PCB_RC_DOS_FAIL_INV_ENVIRON       310   /* failure, invalid environment */
#define PCB_RC_DOS_FAIL_INV_FORMAT        311   /* failure, invalid format */

/* 99 - Convert Position or RowCol */
#define PCB_RC_CONVERT_FAIL_INPUT           0   /* failed, bad input */
#define PCB_RC_CONVERT_FAIL_SESSION      9998   /* failed, invalid session */
#define PCB_RC_CONVERT_FAIL_PARAMS       9999   /* failed, invalid parameters */

/* 255 - DCA query */
#define PCB_RC_DCA_QUERY_OK                 0   /* DCA Query - successful */

/* Miscellaneous */
#define PCB_VALIDATION_FAILURE              2   /* invalid pcb passed */
