#include <string.h>
#include "funcs.h"
extern int FG, BG;

/*---------------------finddate---------------------------------*/
/*DESCRIPTION:	Puts the system date or a user entered date into*/
/*	datestr according to the value of format.		*/
/*								*/
/*INPUT: 							*/
/*  ReturnFormat -- format to return the date in according to	*/
/*	ConvertDate formats.					*/
/*  IncomingFormat -- format the date is in when passed to the  */
/*      function.  This is the date that will be displayed	*/
/*								*/
/*  If the incoming date is invalid (an empty string) the system*/
/*	date will be used.					*/
/*                                                              */
/*RETURNS: 0 on sucess						*/
/*	   -1 on failure					*/
/*USES: Frame, inout, ConvertDate,				*/
/*--------------------------------------------------------------*/

finddate(void *the_date, int ReturnFormat, int IncomingFormat, char *prompt)
{
	int   ret;
	char  datestr[9];
	char  PromptLine[40];
	FrameDataType	Fr;

	/* if incoming date is bad or invalid, take system date */
	if(ConvertDate(datestr, the_date, 6, IncomingFormat) ||
            IncomingFormat==0 && *((unsigned *)the_date)==0)
		ConvertDate(datestr, &ret, 6, 1);

	do{
		Fr.X = 23; Fr.Y = 7;
		Fr.F = (FG==-1)? 1: FG;
		Fr.B = (BG==-1)? 2: BG;
		Fr.L = 11; Fr.W = 34;
		Fr.clear = 2;
		Frame(&Fr);

		if((ret=strlen(prompt)) >= Fr.W)
			Fr.txt[0] = prompt;
		else
		{
			strspc(PromptLine, (Fr.W-ret)/2);
			Fr.txt[0] = strcat(PromptLine, prompt);
			/*sprintf(PromptLine, "%*s%s", (Fr.W-ret)/2, "",
				prompt);
			Fr.txt[0] = PromptLine;*/
		}

		Fr.txt[4] = "        -> Enter another Date";
		Fr.txt[5] = "  ENTER -> Accept Date";
		Fr.txt[6] = "    Esc -> Previous Screen";
		Frame(&Fr);
		inout(35, 10, 8, (FG==-1)? 1: FG, (BG==-1)? 2: BG, datestr, 2, 4, 1, "   ", &ret);
		if(ret == 14) return(-1);
	} while (ConvertDate(the_date, datestr, ReturnFormat, 6));

	return(0);
}
/*
void main(void)
{
   char the_date[9]="";

   finddate(the_date, 6, 6, "Mail Received Date");
}*/