#include <conio.h>
#include <alloc.h>
#include <stdio.h>
#include <funcs.h>

unsigned MaxList = 500;
extern void (*idle_func) (void);

/*----------------------dwedit-----------------------------*/
/*	         DOUBLE WINDOW EDIT                        */
/*							   */
/*DESCRIPTION: Sets up two windows on the console and 	   */
/*      allows for data entry in the windows and number	   */
/*	checking.					   */
/*							   */
/*INPUT:                                                   */
/*     filename - name for output file			   */
/*     width1   - width of window 1			   */
/*     width2   - width of window 2			   */
/*     length   - length of windows                        */
/*     fcheck1 & fcheck2  - functions that check for a     */
/*		  a valid number.  Return 1 for pass, 0    */
/*		  for fail.  Passing NULL means no check.  */
/*							   */
/* USES: Frame, OnCursor, OffCursor			   */
/*---------------------------------------------------------*/

dwedit( const char *filename, char action, int width1, int width2,
	int length, int (*fcheck1) (const char *),
	int (*fcheck2) (const char *))

{

  int i, CurWin = 0, key = '', LinMod, done = 1, MovWin = 0;
  int y, cursorx = 0, cursory = 0, index = 0, count = 0, move = 1;
  int TopWinElt = 0, OldWin= 3, movey =0, movex= 0, tmp;
  int x[2], width[2];
  int (*fcheck[2]) (const char *);
  FILE *fp;
  char *list[2];
  char buffer[1300], *ptr;
  FrameDataType Fr;
  void DisplayDweditWindows(char *list[2], int TopOfWin, int X1,
		int X2, int Y, int W1, int W2, int Length, int Count);
  void BuildWeditScreen();

/* end data declarations  */

  if (action == 'X')
    return(0);

 /*   initialize vars  */
  width[0] = width1;
  width[1] = width2;
  y = 14 - (length / 2);
  x[0] = 36 - ((width[0] + width[1]) /2);
  x[1] = x[0] + width[0] + 3;
  fcheck[0] = fcheck1;
  fcheck[1] = fcheck2;

  /*------ALLOCATE MEMORY FOR DATA------*/
  if((list[0] = (char *)calloc(MaxList, width1+1)) == NULL ||
     (list[1] = (char *)calloc(MaxList, width2+1)) == NULL)
  {
     message(2, "Not Enough Memory Available");
     if(list[0]!=NULL)
	free(list[0]);
     return(0);
  }

/*---------------READ IN DATA FROM FILE ------*/
  if (action != 'O' && action != 'A')
    action = 'A';
  if (action == 'A')
  {
    if ((fp = fopen(filename, "rt")) != NULL)
    {
      while (fgets(buffer, 60, fp) != NULL)
      {
	 memcpy(list[0]+count*(width1+1), buffer, width1);
	 memcpy(list[1]+(count++)*(width2+1), buffer + width1 + 1, width2);
      }
      TopWinElt = (count /length) * length;
      cursory = count % length;
      index = TopWinElt + cursory;
      fclose(fp);
    }
    else  /* file not found */
	action = 'O';
  } /* append */

  BuildWeditScreen();

 /*----------DISPLAY FRAME ---------*/
  Fr.clear = 2;
  Frame(&Fr);

  Fr.X = x[0]-1; Fr.Y = y-1;
  Fr.L = length+2; Fr.W = width[0]+2;
  Fr.F = CYAN; Fr.B = BLACK;
  Fr.BorderType = 0;
  Frame(&Fr);
  Fr.X = x[1]-1; Fr.F = BROWN;
  Fr.W = width[1]+2;
  Frame(&Fr);
  OnCursor();

/*---------------MAIN LOOP--------------*/
  while (done != 0)
  {
/*----------- DISPLAY STATS ------------*/
    if (move != 0)
    {
      WriteAt(20, 15, YELLOW, BLACK, ptr="%-4d", index+1);
      Write(ptr, count);
      Write(ptr, MaxList-count);
      move = 0;
    }

/*--------- DISPLAY WINDOWS ----------------*/
    if(OldWin != TopWinElt)
	DisplayDweditWindows(list, TopWinElt, x[0], x[1], y, width[0], width[1],
			 length, count);
    gotoxy(x[CurWin] + cursorx, y+cursory);
    OldWin = TopWinElt;
    if(CurWin==0)
      textattr(CYAN);
    else
      textattr(BROWN);

/*------------- GET KEY STROKE ----------------*/
    key = GetIdleCh();

    if (key == '\0')
      key = 256 + getch();
    else if (key >= 32 && key <= 256)
    {
	putch(key);
	*(list[CurWin]+index*(width[CurWin]+1) +cursorx) = key;
	movex++;
    }

    switch (key){
	case 13:   /* Enter asc 13       */
	  MovWin++;
	  break;
	case 324:   /* F10 asc 0, 68 - save data & exit  */
	case 323:   /* F9 asc 0, 67  - save data */
		gettext(29, 23, 46, 24, buffer);
		//fflush(&buffer);
		WriteAt(29, 24, YELLOW, DARKGRAY, " Saving Data ... ");
		/*-----------WRITE TO THE FILE-------------*/
		if ((fp = fopen(filename, "wt")) != NULL)
		for (i = 0; i < count; i++)
			if(!blanks(list[0]+i*(width[0]+1)) || !blanks(list[1]+i*(width[1]+1)))
				fprintf( fp, "%*s %*s\n",
					width[0],
					list[0]+i*(width[0]+1),
					width[1],
					list[1]+i*(width[1]+1));
		fclose(fp);
		puttext(29, 23, 46, 24, buffer);

		if(key==324)  /* F10 - done */
			done=0;
		break;
	case 322: /* F8 - abort */
		idle_func = nothing;
		i = toupper(message(0," Recent Modifications Will Be Lost, Are You Sure? (Y/N)"));
		if(i=='Y')
			done = 0;
		break;
	case 328:   /* Up arrow asc 0, 72    */
	  --movey;
	  break;
	case 336:   /* Down arrow asc 0, 80  */
	  movey++;
	  break;
	case 333:   /* Right arrow asc 0, 77 */
	  movex++;
	  break;
	case 331:   /* Left arrow asc 0, 75  */
	  movex--;
	  break;
	case 9:   /* Tab key */
	   MovWin++;
	   break;
	case 271: /* backtab key */
	   MovWin--;
	   break;
	case 327:   /* Home asc 0, 71        */
	  movey = -index;
	  movex = -cursorx;
	  break;
	case 335:   /* End Key asc 0, 79        */
	  movey = count - index -1;
	  movex = -cursorx;
	  break;
	case 329:   /* Pageup Key asc 0, 73        */
	  movey -= length;
	  break;
	case 337:   /* Page down Key asc 0, 81        */
	  movey += length;
	  break;
	case  8:   /* BackSpace asc 8    */
	  if(cursorx != 0) {
	     gotoxy(x[CurWin] + cursorx-1, y + cursory);
	     for(i = cursorx-1; i< width[CurWin] -1; ++i) {
		*(list[CurWin]+index*(width[CurWin]+1)+i) = *(list[CurWin]+index*(width[CurWin]+1)+i+1);
		putch(*(list[CurWin]+index*(width[CurWin]+1)+i)); }
	     *(list[CurWin]+index*(width[CurWin]+1)+i) = ' ';
	     putch(' ');
	     movex--; }
	  break;
	case 339:  /*  Del key  asc 0, 83*/
	  for(i = cursorx; i< width[CurWin] -1; ++i) {
	     *(list[CurWin]+index*(width[CurWin]+1)+i) = *(list[CurWin]+index*(width[CurWin]+1)+i+1);
	     putch(*(list[CurWin]+index*(width[CurWin]+1)+i)); }
	  *(list[CurWin]+index*(width[CurWin]+1)+i) = ' ';
	  putch(' ');
	  break;
	default:
	  break;
    } /* end switch */

/*------------- PROCESS KEY STROKE ---------------------*/
    if(movex + cursorx >= width[CurWin])
       MovWin++;
    if(movex + cursorx < 0)
       MovWin--;

 /*---------- CHECK FOR A VALID NUMBER --------*/
    if (fcheck[CurWin] != NULL)
    {
       if (key >= 48 && key <= 125)  LinMod = 1;
       if (LinMod && (movey || MovWin))
       {   if( !CkBeep(fcheck[CurWin](list[CurWin]+index*(width[CurWin]+1))))
		movex = movey = MovWin = 0;
	   LinMod = 0;
       }
    } /* end check */

    if(MovWin < 0 && CurWin == 0) movey--;
    if(MovWin > 0 && CurWin == 1) movey++;

    if(movey + cursory > length -1)
    {   /* past bottom of window */
       if((tmp = (index + movey) / length * length ) < MaxList)
       {
		TopWinElt = tmp;
		movey = -(cursory - (cursory+movey) % length);
       }
    }
    else if(movey + cursory < 0)    /* past top of window */
       if(index + movey >= 0) {      /* check for top of list */
	  TopWinElt = (index + movey)/length *length;
	  movey = -(cursory - (index + movey) % length); }
	else
	  movey = 0;

    if(index +1 > count && !blanks(list[CurWin]+index*(width[CurWin]+1))) {
       count = index +1;
       ++move; }

    cursorx += movex;
    if(TopWinElt+cursory+movey< MaxList)
	cursory += movey;
    else /* tried to go past max limit */
    {
	Beep(250, 2); delay(100);
	Beep(250, 2); delay(100);
	Beep(250, 2);
    }

    CurWin += MovWin;

    if(movey || OldWin != TopWinElt) ++move;
    if(CurWin < 0) CurWin = 1;
    if(CurWin > 1) CurWin = 0;
    if(MovWin < 0) cursorx = width[CurWin] -1;
    if(MovWin > 0) cursorx = 0;

    MovWin = movex = movey = 0;

    index = TopWinElt + cursory;

  } /* end while */

  /*------FREE MEMORY-------*/
  free(list[0]);
  free(list[1]);

  OffCursor();

  return(1);

}  /* end wedit */

void BuildWeditScreen()
{

  FrameDataType Fr;

  NewClear (CYAN, BLACK);


  Fr.clear = 2;
  Frame (&Fr);

  Fr.X = 49; Fr.Y =  8;
  Fr.L = 13; Fr.W = 31;
  Fr.F = GREEN; Fr.B = BLACK;
  Fr.BorderType = 1;
  Fr.txt[0] = "  Use Cursor Keys to Edit";
  Fr.txt[2] = " Home  .. Top of List";
  Fr.txt[3] = " End   .. Bottom of List";
  Fr.txt[4] = " Up    .. Move Cursor Up";
  Fr.txt[5] = " Down  .. Move Cursor Down";
  Fr.txt[6] = " Left  .. Move Cursor Left";
  Fr.txt[7] = " Right .. Move Cursor Right";
  Fr.txt[8] = " PgUp  .. Goto Prev Screen";
  Fr.txt[9] = " PgDn  .. Goto Next Screen";
  Frame(&Fr);

  Fr.X =  3;    Fr.Y =  7;
  Fr.L =  6;    Fr.W = 22;
  Fr.F = GREEN; Fr.B = BLACK;
  Fr.BorderType = 1;
  Fr.txt[0] = "      OPTIONS";
  Fr.txt[1] = " F10 to Save & Exit";
  Fr.txt[2] = " F9 to Save";
  Fr.txt[3] = " F8 to Abort";
  Frame ( &Fr );


  Fr.X = 26;    Fr.Y =  2;
  Fr.L =  3;    Fr.W = 24;
  Fr.F = GREEN; Fr.B = BLACK;
  Fr.BorderType = 2;
  Fr.txt[0] = "  Data Entry Screen ";
  Frame ( &Fr );


  Fr.X =  2;     Fr.Y = 14;
  Fr.L =  5;     Fr.W = 24;
  Fr.F = YELLOW; Fr.B = BLACK;
  Fr.BorderType = 1;
  Fr.txt[0] = " Current Number: ";
  Fr.txt[1] = "          Count: ";
  Fr.txt[2] = "    Memory Left: ";
  Frame( &Fr );

}

void DisplayDweditWindows(char *list[2], int TopOfWin, int X1,
		int X2, int Y, int W1, int W2, int Length, int Count)
{

  int i;

  if (TopOfWin < 0) TopOfWin = 0;

  for (i = TopOfWin; i < TopOfWin + Length; i++)
      if(i<Count)
      {     /* data exists, so just print it */
	WriteAt(X1, Y+i-TopOfWin, CYAN, BLACK, list[0]+i*(W1+1));
	WriteAt(X2, Y+i-TopOfWin, BROWN, BLACK, list[1]+i*(W2+1));
      }
      else
      {
	/*  write spaces in window */
	WriteAt(X1, Y+i-TopOfWin, CYAN, BLACK, "%*s", W1, " ");
	WriteAt(X2, Y+i-TopOfWin, BROWN, BLACK, "%*s", W2, " ");
      }
}


int Chk(const char *num)
{ int result;
  result = strcmp(num, "dd");
  return(result==0);
}
/*
void main(void)
{
  dwedit("DATA.fil", AddAppend("data.fil"), 9, 2, 12, CheckNum, Chk);
}

 */