/*******************************************************************************/
/*									       */
/*  Win.C								       */
/*									       */
/*  Written By Jeff McElroy 6/21/89					       */
/*									       */
/*******************************************************************************/

#include <malloc.h>
#include <memory.h>
#include <stdlib.h>
#include <stdio.h>
#include "win.h"

/*******************************************************************************/
/* Curses Routines Available						       */
/*******************************************************************************/
#define ANSI_SEQ		0	/* Use Ansi Sequences		       */
#define OS2_V12 		0	/* Use OS2 v1.2 Kernal		       */
					/* This Stays within FAPI	       */
#define DOS_BIOS		0	/* Use Bios Int 10h		       */
#define DOS_DIRECT		1	/* Write Directly Using Bios to Figure */
					/* The Screen buffer's Location        */
/*******************************************************************************/
/* Frame Characters Set's Available                                            */
/*******************************************************************************/
#define IBM_EXTENDED		1	/* Use IBM Extended Ascii Codes        */
#define STANDARD_ASCII		0	/* Use Standard Ascii Codes	       */
/*******************************************************************************/
/* Constants								       */
/*******************************************************************************/

#if IBM_EXTENDED
/*******************************************************************************/
/*  IBM EXTENDED ASCII SET						       */
/*******************************************************************************/
    #define HORIZONTAL_CHAR	    '\xc4'
					/* Character used for the horizontal   */
					/* bar in each window's frame.         */
    #define VERTICAL_CHAR	    '\xba'
					/* Character used for the vertical bar */
					/* in each window's frame.             */
    #define UPPER_LEFT_CHAR	    '\xd6'
					/* Character used as the upper left    */
					/* corner in each window's frame.      */
    #define LOWER_LEFT_CHAR	    '\xd3'
					/* Character used as the lower left    */
					/* corner in each window's frame.      */
    #define UPPER_RIGHT_CHAR	    '\xb7'
					/* Character used as the upper right   */
					/* corner in each window's frame.      */
    #define LOWER_RIGHT_CHAR	    '\xbd'
					/* Character used as the lower right   */
					/* corner in each window's frame.      */
    #define BACKSPACE_CHAR	    '\b'
					/* BackSpace Character		       */
    #define TAB_CHAR		    '\t'
					/* Tab Character		       */
    #define LINEFEED_CHAR	    '\n'
					/* Line Feed Character		       */
    #define RETURN_CHAR 	    '\r'
					/* Return Character		       */
    #define BELL_CHAR		    '\a'
					/* Bell Character		       */
    #define SPACE_CHAR		    ' '
					/* Space Character		       */

    #define DEFAULT_TAB 	    8
					/* Default Tabs 		       */
    #define DEFAULT_BACKGROUNDCHAR  SPACE_CHAR
					/* Default BackGround Character        */
/*******************************************************************************/
#elif STANDARD_ASCII
/*******************************************************************************/
/*  STANDARD ASCII SET							       */
/*******************************************************************************/

    #define HORIZONTAL_CHAR	    '-'
					/* Character used for the horizontal   */
					/* bar in each window's frame.         */
    #define VERTICAL_CHAR	    '|'
					/* Character used for the vertical bar */
					/* in each window's frame.             */
    #define UPPER_LEFT_CHAR	    '/'
					/* Character used as the upper left    */
					/* corner in each window's frame.      */
    #define LOWER_LEFT_CHAR	    '\\'
					/* Character used as the lower left    */
					/* corner in each window's frame.      */
    #define UPPER_RIGHT_CHAR	    '\\'
					/* Character used as the upper right   */
					/* corner in each window's frame.      */
    #define LOWER_RIGHT_CHAR	    '/'
					/* Character used as the lower right   */
					/* corner in each window's frame.      */
    #define BACKSPACE_CHAR	    '\b'
					/* BackSpace Character		       */
    #define TAB_CHAR		    '\t'
					/* Tab Character		       */
    #define LINEFEED_CHAR	    '\n'
					/* Line Feed Character		       */
    #define RETURN_CHAR 	    '\r'
					/* Return Character		       */
    #define BELL_CHAR		    '\a'
					/* Bell Character		       */
    #define SPACE_CHAR		    ' '
					/* Space Character		       */
/*******************************************************************************/
#else
    #error Must Select Character Set To Use
#endif

#define DEFAULT_BACKGROUNDCHAR	SPACE_CHAR
					/* Default BackGround Character        */
#define DEFAULT_TAB		8	/* Default Tabs 		       */

/*******************************************************************************/
/* Defintition Of Character Cells					       */
/*******************************************************************************/
struct CHARCELL
{
    unsigned char ucChar;		/* Character			       */
    enum eWinColors eForeAttr;		/* Foreground attribute 	       */
    enum eWinColors eBackAttr;		/* Background attribute 	       */
};
/*******************************************************************************/
/* Defintition Windows							       */
/* All Origins at ( 0,0 )						       */
/*******************************************************************************/
struct WINDOW
{
    unsigned long ulFlags;		/* Type and current status of window   */
    short sViewX, sViewY;		/* Location of the upper left corner   */
					/* corner of the window's viewport     */
					/* relative of the screen origin.      */
    short sPhysX, sPhysY;		/* Location of the upper left corner   */
					/* of the window relative of the       */
					/* screen origin.		       */
    short sCursX, sCursY;		/* Location of the window's cursor     */
					/* in the window's data buffer.        */
    short sOrigX, sOrigY;		/* Location of the upper left corner   */
					/* of the window's viewport in the     */
					/* window's data buffer.               */
    unsigned short usTabStop;		/* Number of space each tab sent to    */
					/* this window represents.	       */
    unsigned short usPhysW, usPhysL;	/* The Physical dimensions of the      */
					/* window.			       */
    unsigned short usViewW, usViewL;	/* The physical dimensions of the      */
					/* windows viewport.		       */
    unsigned short usLogcW, usLogcL;	/* The dimensions of the window's data */
					/* buffer.			       */
    struct CHARCELL *pData;		/* Pointer to the window's data buffer.*/
    unsigned char ucBackGroundChar;	/* Character to use when the view port */
					/* exceeds the window's data buffer.   */
    enum eWinColors eForeAttr;		/* Current foreground attribute for    */
					/* the window's viewport.              */
    enum eWinColors eBackAttr;		/* Current background attribute for    */
					/* the window's viewport.              */
    enum eWinColors eForeBord;		/* Foreground attribute for the        */
					/* window's border.                    */
    enum eWinColors eBackBord;		/* Background attribute for the        */
					/* window's border.                    */
};

unsigned char ucBackGroundChar;
enum eWinColors eForeBackGrnd;
enum eWinColors eBackBackGrnd;

enum eWinColors eForeShadow;
enum eWinColors eBackShadow;


unsigned short usScreenWidth;
unsigned short usScreenLength;

short sScreenOriginX;
short sScreenOriginY;

struct WINDOW *pWindows[MAX_WINDOW_COUNT];

WINHANDLE ahActiveWindows[MAX_WINDOW_COUNT];
unsigned short usActiveWindowTop;

/* This Is THe Current State Of The Screen */
short sCurrentX;
short sCurrentY;
enum eWinColors eCurrentForeAttr;
enum eWinColors eCurrentBackAttr;

#if ANSI_SEQ

    #include <stdio.h>

    unsigned short usColor[eWinColorCount] = { 0, 1, 2, 3, 4, 5, 6, 7 };

    void vTTYGotoXY(unsigned short usX, unsigned short usY)
    {
	fprintf( stdout,"%c[%d;%df",(char) 27, usY+1 , usX+1);
    }

    void vTTYSetColor( enum eWinColors eForeAttr, enum eWinColors eBackAttr )
    {
	fprintf(stdout,"%c[%d;%dm",(char) 27, usColor[eForeAttr] + 30, usColor[eBackAttr] + 40);
    }

    void vTTYPutc ( char cChar )
    {
	fputc(cChar, stdout);
    }

    void vTTYInit(void)
    {
    }

    void vTTYEnd(void)
    {
    }

#elif OS2_V12

    #define INCL_SUB
    #include <os2.h>

    struct OS2_CHAR_CELL
    {
	char	cChar;
	char	cAttr;
    };

    PBYTE		    pbLVB;

    struct OS2_CHAR_CELL *  pCursor;
    unsigned short	    usLVB;
    char		    cCurAttr;

    void vTTYInit(void)
    {
	VioGetBuf( (PULONG) &pbLVB, (PUSHORT) &usLVB, 0);
    }

    void vTTYEnd(void)
    {
    }

    void vTTYGotoXY(unsigned short usX, unsigned short usY)
    {
	pCursor = (struct OS2_CHAR_CELL *) pbLVB + usX + usY * usScreenWidth;
    }

    void vTTYPutc ( char cChar )
    {

	pCursor->cChar = cChar;
	pCursor->cAttr = cCurAttr;

	VioShowBuf ( (USHORT) ( (PBYTE) pCursor - pbLVB), sizeof(struct OS2_CHAR_CELL), 0);
	pCursor += 1;

    }

    void vTTYSetColor( enum eWinColors eForeAttr, enum eWinColors eBackAttr )
    {
	cCurAttr = (char) (eForeAttr + eBackAttr * 16);
    }


#elif DOS_BIOS

    #include <dos.h>
    char	    cCurAttr;
    unsigned short  usCurX;
    unsigned short  usCurY;

    void vTTYInit(void)
    {
    }

    void vTTYEnd(void)
    {
    }

    void vTTYGotoXY(unsigned short usX, unsigned short usY)
    {
	union REGS  regs;

	regs.h.ah = 0x02;	/* Function Type */
	regs.h.bh = 0x00;	/* Current Page  */
	regs.h.dh = (char) usY;	/* Row		 */
	regs.h.dl = (char) usX;	/* Column	 */
	int86 ( 0x10, &regs, &regs);
	usCurX = usX;
	usCurY = usY;
    }

    void vTTYPutc ( char cChar )
    {

	union REGS  regs;

	regs.h.ah = 0x09;	/* Function Type */
	regs.h.al = cChar;	/* Char to Print */
	regs.h.bh = 0x00;	/* Current Page  */
	regs.h.bl = cCurAttr;	/* Attr to Use	 */
	regs.x.cx = 1;		/* Count	 */

	int86 ( 0x10, &regs, &regs);

	vTTYGotoXY( usCurX+1, usCurY);
    }

    void vTTYSetColor( enum eWinColors eForeAttr, enum eWinColors eBackAttr )
    {
	cCurAttr = (char) (eForeAttr + eBackAttr * 16);
    }

#elif DOS_DIRECT

    #include <dos.h>

    char far *	pcVideoBase;
    char far *	pCursor;
    char	cCurAttr;

    void vTTYInit(void)
    {
	union REGS  regs;

	regs.h.ah = 0x0F;	/* Function Type (Get Video Mode) */
	int86 ( 0x10, &regs, &regs);

	switch( regs.h.al)
	{
	    case 7:
		    pcVideoBase = (char far *) 0xb0000000;
		    break;
	    default:
		    pcVideoBase = (char far *) 0xb8000000;
		    break;
	}
    }

    void vTTYGotoXY(unsigned short usX, unsigned short usY)
    {
	pCursor = pcVideoBase + 2 * (usX + usY * usScreenWidth);
    }

    void vTTYPutc ( char cChar )
    {

	*(pCursor++) = cChar;
	*(pCursor++) = cCurAttr;
    }

    void vTTYSetColor( enum eWinColors eForeAttr, enum eWinColors eBackAttr )
    {
	cCurAttr = (char) (eForeAttr + eBackAttr * 16);
    }

    void vTTYEnd(void)
    {
    }

#else

    #error Must Select Curses Routines

#endif

int IsWinHandleValid (WINHANDLE hWin)
{
    return
    (
	hWin < MAX_WINDOW_COUNT &&
	pWindows[hWin] != NULL
    );
}

unsigned short usWinGetBackGroundZ(void)
{
    return usActiveWindowTop;
}

int IsXYOverLapping ( short sTestX, short sTestY, short sAreaX, short sAreaY, unsigned short usAreaW, unsigned short usAreaL)
{
    return
    (
	sTestX >= sAreaX && sTestX < sAreaX + usAreaW &&
	sTestY >= sAreaY && sTestY < sAreaY + usAreaL
    );
}

int IsAreaOverLapping ( short sTestX, short sTestY, unsigned short usTestW, unsigned short usTestL, short sAreaX, short sAreaY, unsigned short usAreaW, unsigned short usAreaL)
{
    return
    (
	IsXYOverLapping ( sTestX	  , sTestY	    , sAreaX, sAreaY, usAreaW, usAreaL) ||
	IsXYOverLapping ( sTestX + usTestW, sTestY	    , sAreaX, sAreaY, usAreaW, usAreaL) ||
	IsXYOverLapping ( sTestX	  , sTestY + usTestL, sAreaX, sAreaY, usAreaW, usAreaL) ||
	IsXYOverLapping ( sTestX + usTestW, sTestY + usTestL, sAreaX, sAreaY, usAreaW, usAreaL)
    );
}

short sWinGetOrgX(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sOrigX;
    }
    else
    {
	return 0;
    }
}

short sWinGetOrgY(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sOrigY;
    }
    else
    {
	return 0;
    }
}

short sWinGetCurX(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sCursX;
    }
    else
    {
	return 0;
    }
}

short sWinGetCurY(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sCursY;
    }
    else
    {
	return 0;
    }
}

short sWinGetLocX(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sPhysX;
    }
    else
    {
	return 0;
    }
}

short sWinGetLocY(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->sPhysY;
    }
    else
    {
	return 0;
    }
}

unsigned short usWinGetLocZ(WINHANDLE hWin)
{
    unsigned short usIndex;
    if (IsWinHandleValid(hWin))
    {
	usIndex = 0;
	while
	(
	    usIndex < usActiveWindowTop &&
	    ahActiveWindows[usIndex] != hWin
	)
	    usIndex += 1;
    }

    return usIndex;
}

unsigned short usWinGetLocW(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->usViewW;
    }
    else
    {
	return 0;
    }
}

unsigned short usWinGetLocL(WINHANDLE hWin)
{
    if (IsWinHandleValid(hWin))
    {
	return pWindows[hWin]->usViewL;
    }
    else
    {
	return 0;
    }
}

void vWinPutCellAt(short sX, short sY, char character, enum eWinColors eForeAttr, enum eWinColors eBackAttr)
{
    if
    (
	eCurrentForeAttr != eForeAttr ||
	eCurrentBackAttr != eBackAttr
    )
    {
	vTTYSetColor( eForeAttr, eBackAttr);
	eCurrentForeAttr = eForeAttr;
	eCurrentBackAttr = eBackAttr;
    }

    if
    (
	sX >= sScreenOriginX			&&
	sY >= sScreenOriginY			&&
	(unsigned short)(sX - sScreenOriginX) < usScreenWidth	&&
	(unsigned short)(sY - sScreenOriginY) < usScreenLength
    )
    {
	if
	(
	    sCurrentX != sX + sScreenOriginX ||
	    sCurrentY != sY + sScreenOriginY
	)
	{
	    sCurrentX = sX + sScreenOriginX;
	    sCurrentY = sY + sScreenOriginY;
	    vTTYGotoXY ( (unsigned short) sCurrentX, (unsigned short) sCurrentY);
	}

	vTTYPutc ( character );
	sCurrentX += 1;
    }

}

int IsWinCharActive(short sX, short sY, unsigned short usZ)
{
    unsigned short usIndex;
    int IsValid;

    IsValid = ( 1==0 );

    if ( usZ <= usWinGetBackGroundZ() )
    {
	IsValid = ( 1==1 );
	for ( usIndex = 0; usIndex < usZ && IsValid; ++usIndex)
	{
	    IsValid &= !IsXYOverLapping
	    (
		sX, sY,
		pWindows[ahActiveWindows[usIndex]]->sPhysX,
		pWindows[ahActiveWindows[usIndex]]->sPhysY,
		pWindows[ahActiveWindows[usIndex]]->usPhysW,
		pWindows[ahActiveWindows[usIndex]]->usPhysL
	    );
	}
    }

    return IsValid;
}

void vWinInvalidateRec( short sX, short sY, unsigned short usW, unsigned short usL)
{
    unsigned short  usTopZ;
    short  sTmpX;
    short  sTmpY;
    unsigned short  sTmpZ;

    unsigned char ucChar;
    int fFoundFlag;
    enum eWinColors eForeAttr;
    enum eWinColors eBackAttr;
    struct CHARCELL *pCurCell;
    struct WINDOW *pCurWindow;

    usTopZ = usWinGetBackGroundZ();

    for ( sTmpY = sY; sTmpY < sY + (signed short) usL; ++sTmpY)
    {
	for ( sTmpX = sX; sTmpX < sX + (signed short) usW; ++sTmpX)
	{
	    ucChar = ucBackGroundChar;
	    eForeAttr = eForeBackGrnd;
	    eBackAttr = eBackBackGrnd;
	    fFoundFlag = (1==0);
	    for
	    (
		sTmpZ = 0;
		sTmpZ < usTopZ && !fFoundFlag;
		++sTmpZ
	    )
	    {
		pCurWindow = pWindows[ahActiveWindows[sTmpZ]];
		if
		(
		    IsXYOverLapping
		    (
			sTmpX,
			sTmpY,
			pCurWindow->sViewX,
			pCurWindow->sViewY,
			pCurWindow->usViewW,
			pCurWindow->usViewL
		    )
		)
		{
		    fFoundFlag = (1==1);
		    if
		    (
			sTmpY + pCurWindow->sOrigY - pCurWindow->sViewY >= 0 &&
			(unsigned short) sTmpY + pCurWindow->sOrigY - pCurWindow->sViewY < pCurWindow->usLogcL &&
			sTmpX + pCurWindow->sOrigX - pCurWindow->sViewX >= 0 &&
			(unsigned short) sTmpX + pCurWindow->sOrigX - pCurWindow->sViewX < pCurWindow->usLogcW
		    )
		    {
			pCurCell = pCurWindow->pData + (sTmpY + pCurWindow->sOrigY - pCurWindow->sViewY) * pCurWindow->usLogcW + sTmpX + pCurWindow->sOrigX - pCurWindow->sViewX;
			ucChar = pCurCell->ucChar;
			eForeAttr = pCurCell->eForeAttr;
			eBackAttr = pCurCell->eBackAttr;
		    }
		}
		else if ( pCurWindow->ulFlags & FRAME_SWITCH)
		{
		    if (sTmpY == pCurWindow->sPhysY)
		    {
			if ( sTmpX == pCurWindow->sPhysX )
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = UPPER_LEFT_CHAR;
			    fFoundFlag = (1==1);
			}
			else if ( sTmpX == pCurWindow->sPhysX + pCurWindow->usPhysW - 1)
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = UPPER_RIGHT_CHAR;
			    fFoundFlag = (1==1);
			}
			else if ( sTmpX > pCurWindow->sPhysX && sTmpX < pCurWindow->sPhysX + (signed short) pCurWindow->usPhysW - 1)
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = HORIZONTAL_CHAR;
			    fFoundFlag = (1==1);
			}

		    }
		    else if (sTmpY == pCurWindow->sPhysY + pCurWindow->usPhysL - 1)
		    {
			if ( sTmpX == pCurWindow->sPhysX )
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = LOWER_LEFT_CHAR;
			    fFoundFlag = (1==1);
			}
			else if ( sTmpX == pCurWindow->sPhysX + pCurWindow->usPhysW - 1)
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = LOWER_RIGHT_CHAR;
			    fFoundFlag = (1==1);
			}
			else if ( sTmpX > pCurWindow->sPhysX && sTmpX < pCurWindow->sPhysX + (signed short) pCurWindow->usPhysW - 1)
			{
			    eForeAttr = pCurWindow->eForeBord;
			    eBackAttr = pCurWindow->eBackBord;
			    ucChar = HORIZONTAL_CHAR;
			    fFoundFlag = (1==1);
			}

		    }
		    else if
		    (
			sTmpY > pCurWindow->sPhysY &&
			sTmpY < pCurWindow->sPhysY + (signed short) pCurWindow->usPhysL - 1 &&
			(
			    sTmpX == pCurWindow->sPhysX ||
			    sTmpX == pCurWindow->sPhysX + pCurWindow->usPhysW - 1
			)
		    )
		    {
			eForeAttr = pCurWindow->eForeBord;
			eBackAttr = pCurWindow->eBackBord;
			ucChar = VERTICAL_CHAR;
			fFoundFlag = (1==1);
		    }
		}
	    }

	    vWinPutCellAt(sTmpX, sTmpY, ucChar, eForeAttr, eBackAttr);
	}
    }
}



void vWinInvalidate( WINHANDLE hWin )
{

    vWinInvalidateRec
    (
	pWindows[hWin]->sPhysX,
	pWindows[hWin]->sPhysY,
	pWindows[hWin]->usPhysW,
	pWindows[hWin]->usPhysL
    );

}

void vWinDeleteZ(unsigned short usPos)
{
    unsigned short usIndex;
    short sX;
    short sY;
    unsigned short usW;
    unsigned short usL;

    if (usPos < usActiveWindowTop)
    {

	sX = pWindows[ahActiveWindows[usPos]]->sPhysX;
	sY = pWindows[ahActiveWindows[usPos]]->sPhysY;
	usW = pWindows[ahActiveWindows[usPos]]->usPhysW;
	usL = pWindows[ahActiveWindows[usPos]]->usPhysL;

	for ( usIndex = usPos; usIndex < usActiveWindowTop; ++usIndex)
	{
	    ahActiveWindows[usIndex] = ahActiveWindows[usIndex+1];
	}
	ahActiveWindows[usActiveWindowTop] = NULL_WINDOW;
	usActiveWindowTop -= 1;

    }
}

void vWinInsertAtZ(unsigned short usPos, WINHANDLE hWin)
{
    unsigned short usIndex;
    if
    (
	hWin < MAX_WINDOW_COUNT     &&
	IsWinHandleValid(hWin)	    &&
	usPos <= usActiveWindowTop
    )
    {
	for ( usIndex = usActiveWindowTop; usIndex > usPos; --usIndex)
	{
	    ahActiveWindows[usIndex] = ahActiveWindows[usIndex-1];
	}
	    usActiveWindowTop += 1;

	ahActiveWindows[usPos] = hWin;

    }

}

void vWinSetLocZ (WINHANDLE hWin, unsigned short usPos)
{

    if
    (
	hWin < MAX_WINDOW_COUNT 		    &&
	IsWinHandleValid(hWin)			    &&
	usPos <= usActiveWindowTop		    &&
	pWindows[hWin]->ulFlags & ACTIVATED_SWITCH
    )
    {
	vWinDeleteZ(usWinGetLocZ(hWin));
	vWinInsertAtZ(usPos, hWin);
	vWinInvalidate( hWin );
    }
}

void vWinSetLocXY ( WINHANDLE hWin, short sX, short sY)
{
    short sSaveX, sSaveY;

    if ( IsWinHandleValid ( hWin ) )
    {
	sSaveX = pWindows[hWin]->sPhysX;
	sSaveY = pWindows[hWin]->sPhysY;

	pWindows[hWin]->sPhysX = sX;
	pWindows[hWin]->sPhysY = sY;
	pWindows[hWin]->sViewX = sX;
	pWindows[hWin]->sViewY = sY;

	if ( pWindows[hWin]->ulFlags & FRAME_SWITCH )
	{
	    pWindows[hWin]->sViewX += 1;
	    pWindows[hWin]->sViewY += 1;
	}

	if ( pWindows[hWin]->ulFlags & ACTIVATED_SWITCH )
	{
	    vWinInvalidateRec
	    (
		sSaveX,
		sSaveY,
		pWindows[hWin]->usPhysW,
		pWindows[hWin]->usPhysL
	    );

	    vWinInvalidate (hWin);
	}
    }

}

void vWinSetLocWL ( WINHANDLE hWin, unsigned short usW, unsigned short usL)
{

    unsigned short usSaveW, usSaveL;

    if (IsWinHandleValid ( hWin ))
    {
	/*
	    Note: since usW & usL are unsigned This Check will also fail
	    if a negative number is sent
	*/
	if
	(
	    usW <= pWindows[hWin]->usLogcW &&
	    usL <= pWindows[hWin]->usLogcL
	)
	{
	    usSaveW = pWindows[hWin]->usPhysW;
	    usSaveL = pWindows[hWin]->usPhysL;

	    pWindows[hWin]->usViewW = usW;
	    pWindows[hWin]->usViewL = usL;
	    pWindows[hWin]->usPhysW = usW;
	    pWindows[hWin]->usPhysL = usL;

	    if ( pWindows[hWin]->ulFlags & FRAME_SWITCH )
	    {
		pWindows[hWin]->usPhysW += 2;
		pWindows[hWin]->usPhysL += 2;
	    }

	    if ( pWindows[hWin]->ulFlags & ACTIVATED_SWITCH )
	    {
		vWinInvalidateRec
		(
		    pWindows[hWin]->sPhysX,
		    pWindows[hWin]->sPhysY,
		    usSaveW,
		    usSaveL
		);

		vWinInvalidate (hWin);
	    }
	}
    }
}

void vWinSetCurXY( WINHANDLE hWin, short sX, short sY)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	pWindows[hWin]->sCursX = sX;
	pWindows[hWin]->sCursY = sY;

    }
}


void vWinSetOrgXY ( WINHANDLE hWin, short sX, short sY)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	pWindows[hWin]->sOrigX = sX;
	pWindows[hWin]->sOrigY = sY;

	vWinInvalidate(hWin);
    }

}

void vWinActivate(WINHANDLE hWin)
{
    if
    (
	IsWinHandleValid(hWin)	&&
	(pWindows[hWin]->ulFlags & ACTIVATED_SWITCH) != ACTIVATED_SWITCH
    )
    {
	pWindows[hWin]->ulFlags |= ACTIVATED_SWITCH;
	vWinInsertAtZ(0, hWin);
	vWinInvalidate( hWin );
    }
}

void vWinDeactivate(WINHANDLE hWin)
{
    if
    (
	IsWinHandleValid(hWin) &&
	pWindows[hWin]->ulFlags & ACTIVATED_SWITCH
    )
    {

	pWindows[hWin]->ulFlags &= ~ACTIVATED_SWITCH;
	vWinDeleteZ(usWinGetLocZ(hWin));
	vWinInvalidate( hWin );
    }
}

void vWinOpen (short sX, short sY, unsigned char ucBackChar, enum eWinColors eForeGrnd, enum eWinColors eBackGrnd)
{

    unsigned short usIndex;

    usActiveWindowTop = 0;
    for
    (
	usIndex = 0;
	usIndex < MAX_WINDOW_COUNT;
	++usIndex
    )
    {
	pWindows[usIndex] = NULL;
	ahActiveWindows[usIndex] = NULL_WINDOW;
    }
    ucBackGroundChar = ucBackChar;
    eForeBackGrnd = eForeGrnd;
    eBackBackGrnd = eBackGrnd;
    eForeShadow = eWinWhite;
    eBackShadow = eWinBlack;

    sScreenOriginX = 0;
    sScreenOriginY = 0;
    usScreenWidth = sX;
    usScreenLength= sY;

    vTTYInit();
    vTTYGotoXY ( 0, 0);
    vTTYSetColor( eWinWhite, eWinBlack);

    vWinInvalidateRec ( 0, 0, usScreenWidth, usScreenLength-1);

}

void vWinClose(void)
{
    vTTYEnd();
}

WINHANDLE hWinFindNextFree( WINHANDLE hStartWith )
{
    WINHANDLE hWin;
    for
    (
	hWin = hStartWith;
	hWin < MAX_WINDOW_COUNT &&
	pWindows[hWin] != NULL;
	++hWin
    )
	;

    return hWin;

}

void vWinClear( WINHANDLE hWin )
{
    struct CHARCELL *pCharCell;
    short sX;
    short sY;

    if ( IsWinHandleValid ( hWin ) )
    {
	vWinSetCurXY( hWin, 0, 0);
	vWinSetOrgXY ( hWin, 0, 0);

	for ( sY = 0; (unsigned short) sY < pWindows[hWin]->usLogcL; ++sY)
	    for ( sX = 0; (unsigned short) sX < pWindows[hWin]->usLogcW; ++sX)
	    {
		pCharCell = (pWindows[hWin]->pData + sX + sY * pWindows[hWin]->usLogcW);
		pCharCell->ucChar = pWindows[hWin]->ucBackGroundChar;
		pCharCell->eForeAttr = pWindows[hWin]->eForeAttr;
		pCharCell->eBackAttr = pWindows[hWin]->eBackAttr;
	    }
	vWinInvalidate(hWin);
    }
}

void vWinSetTextColor(WINHANDLE hWin, enum eWinColors eForeAttr, enum eWinColors eBackAttr)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	pWindows[hWin]->eForeAttr = eForeAttr;
	pWindows[hWin]->eBackAttr = eBackAttr;
    }

}

void vWinSetBorderColor(WINHANDLE hWin, enum eWinColors eForeAttr, enum eWinColors eBackAttr)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	pWindows[hWin]->eForeBord = eForeAttr;
	pWindows[hWin]->eBackBord = eBackAttr;

	if ( pWindows[hWin]->ulFlags & ACTIVATED_SWITCH )
	    vWinInvalidate(hWin);
    }

}


WINHANDLE vWinCreate (unsigned short sPhysX, unsigned short sPhysY, unsigned short usViewW, unsigned short usViewL, unsigned short usLogcW, unsigned short usLogcL, unsigned long ulFlags)
{
    WINHANDLE hWin;
    hWin = hWinFindNextFree( (WINHANDLE) 0 );
    if ( hWin != NULL_WINDOW )
    {
	pWindows[hWin] = malloc ( sizeof(struct WINDOW) );
	if( pWindows[hWin] == NULL )
	{
	    hWin = NULL_WINDOW;
	}
	else
	{
	    pWindows[hWin]->ulFlags = ulFlags;
	    pWindows[hWin]->usLogcW = usLogcW;
	    pWindows[hWin]->usLogcL = usLogcL;
	    pWindows[hWin]->usTabStop = DEFAULT_TAB;
	    pWindows[hWin]->ucBackGroundChar = DEFAULT_BACKGROUNDCHAR;
	    pWindows[hWin]->pData = malloc( sizeof(struct CHARCELL) * usLogcW * usLogcL);

	    if ( pWindows[hWin]->pData == NULL )
	    {
		free ( pWindows[hWin] );
		hWin = NULL_WINDOW;
	    }
	    else
	    {
		    vWinSetTextColor( hWin, eWinWhite, eWinBlack);
		    vWinSetBorderColor( hWin, eWinWhite, eWinBlack);
		    vWinSetLocXY ( hWin, sPhysX, sPhysY);
		    vWinSetLocWL ( hWin, usViewW, usViewL);
		    vWinSetOrgXY ( hWin, 0, 0);
		    vWinSetCurXY( hWin, 0, 0);

		    vWinClear( hWin );
	    }

	}
    }

    return hWin;

}

void vWinDestroy(WINHANDLE hWin)
{
    if (pWindows[hWin] != NULL)
    {
	vWinDeactivate(hWin);
	free(pWindows[hWin]);
	pWindows[hWin] = NULL;
    }
}

void vWinScrollDown(WINHANDLE hWin, unsigned short usCount)
{
    struct CHARCELL *pFromCell;
    struct CHARCELL *pToCell;
    unsigned short usIndex;
    if ( IsWinHandleValid ( hWin ) )
    {
	pToCell = pWindows[hWin]->pData;
	pFromCell = (pWindows[hWin]->pData + usCount * pWindows[hWin]->usLogcW);
	usIndex = 0;
	while ( usIndex < (pWindows[hWin]->usLogcL - usCount) * pWindows[hWin]->usLogcW)
	{
	    memcpy
	    (
		  pToCell + usIndex,
		pFromCell + usIndex,
		sizeof(struct CHARCELL)
	    );
	    ++usIndex;
	}

	while ( usIndex < pWindows[hWin]->usLogcL * pWindows[hWin]->usLogcW )
	{
	    (pToCell + usIndex)->ucChar = ' ';
	    (pToCell + usIndex)->eForeAttr = pWindows[hWin]->eForeAttr;
	    (pToCell + usIndex)->eBackAttr = pWindows[hWin]->eBackAttr;
	     ++usIndex;
	}

	if ( pWindows[hWin]->ulFlags & ACTIVATED_SWITCH )
	    vWinInvalidate(hWin);
    }
}

void vWinCurUpdate(WINHANDLE hWin)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	if ( (unsigned short) pWindows[hWin]->sCursX >= pWindows[hWin]->usLogcW )
	{
	    pWindows[hWin]->sCursX = 0;
	    pWindows[hWin]->sCursY += 1;
	}

	if ( (unsigned short) pWindows[hWin]->sCursY >= pWindows[hWin]->usLogcL )
	{
	    vWinScrollDown( hWin, pWindows[hWin]->sCursY - pWindows[hWin]->usLogcL + 1);
	    pWindows[hWin]->sCursY = pWindows[hWin]->usLogcL - 1;
	}

    }
}

void WinSetCharAt(short sX, short sY, unsigned short usZ, char character, enum eWinColors eForeAttr, enum eWinColors eBackAttr)
{
    if
	(IsWinCharActive(sX, sY, usZ))
    {
	vWinPutCellAt(sX, sY, character, eForeAttr, eBackAttr);
    }
}

int IsWinPosVisible(WINHANDLE hWin, short sX, short sY)
{
    if ( IsWinHandleValid ( hWin ) )
    {
	return
	(
	    pWindows[hWin]->ulFlags & ACTIVATED_SWITCH &&
	    sX >= pWindows[hWin]->sOrigX &&
	    sY >= pWindows[hWin]->sOrigY &&
	    (unsigned short) sX - pWindows[hWin]->sOrigX < pWindows[hWin]->usViewW &&
	    (unsigned short) sY - pWindows[hWin]->sOrigY < pWindows[hWin]->usViewL
	);
    }
    else
    {
	return ( 1==0 );
    }

}

void vWinPutC (WINHANDLE hWin, char cChar)
{
    struct CHARCELL *pCharCell;

    if ( IsWinHandleValid ( hWin ) )
    {
	switch(cChar)
	{
	    /* BackSpace*/
	    case '\b':
		    if (pWindows[hWin]->sCursX > 0)
			--pWindows[hWin]->sCursX;
		    break;

	    /* Tab */
	    case '\t':
		    pWindows[hWin]->sCursX += pWindows[hWin]->sCursX % pWindows[hWin]->usTabStop;
		    break;

	    /* LineFeed */
	    case '\n':
		    pWindows[hWin]->sCursY += 1;
		    pWindows[hWin]->sCursX = 0;
		    break;

	    /* Return */
	    case '\r':
		    pWindows[hWin]->sCursX = 0;
		    break;

	    /* Bell */
	    case '\a':
		    break;

	    default:
		    if (IsWinPosVisible(hWin, pWindows[hWin]->sCursX, pWindows[hWin]->sCursY) )
		    {
			WinSetCharAt
			(
			    pWindows[hWin]->sViewX + pWindows[hWin]->sCursX - pWindows[hWin]->sOrigX,
			    pWindows[hWin]->sViewY + pWindows[hWin]->sCursY - pWindows[hWin]->sOrigY,
			    usWinGetLocZ(hWin),
			    cChar,
			    pWindows[hWin]->eForeAttr,
			    pWindows[hWin]->eBackAttr
			);
		    }

		    pCharCell = (pWindows[hWin]->pData + pWindows[hWin]->sCursX + pWindows[hWin]->sCursY * pWindows[hWin]->usLogcW);
		    pCharCell->ucChar = cChar;
		    pCharCell->eForeAttr = pWindows[hWin]->eForeAttr;
		    pCharCell->eBackAttr = pWindows[hWin]->eBackAttr;

		    pWindows[hWin]->sCursX += 1;
		    break;
	}
	vWinCurUpdate(hWin);
    }

}


void vWinPutS ( WINHANDLE hWin, char * pszString )
{
    char *pszTmp;
    pszTmp = pszString;
    while ( *pszTmp != '\0' )
    {
	vWinPutC ( hWin, *pszTmp);
	pszTmp += 1;
    }
}
