#include <ctype.h>
/*----------------------------------------------------------------*/
/*-----------------------------blanks-----------------------------*/
/*DESCRIPTION: tests whether a string consists entirely of blanks */
/*								  */
/*INPUT: a null terminated string				  */
/*RETURNS: 1 if the string is blank				  */
/*         0 if the string is not blank				  */
/*USES: nothing							  */
/*IN: string.c							  */
/*----------------------------------------------------------------*/

blanks(char *string)

{
	while(isspace(*string) && *string != '\0')
	  ++string;

	return(*string == '\0');
}

/*-----------------------------------------------------------*/
/*----------------------strspc-------------------------------*/
/*DESCRIPTION: Puts len spaces into string and adds a	     */
/*	terminating null char.				     */
/*							     */
/*RETURNS: the address of string			     */
/*USES: nothing						     */
/*IN: string.c						     */
/*-----------------------------------------------------------*/

char *strspc(char *string, int len)
{
	string[len] = '\0';
	while(len > 0)
	   string[--len] = ' ';

	return(string);
}

/*-----------------------------------------------------*/
/*---------------strnchr-------------------------------*/
/*DESCRIPTION: puts len copies of ch into string and   */
/*	adds a terminating null ch.		       */
/*						       */
/*RETURNS: the address of string		       */
/*USES: nothing.				       */
/*IN: string.c					       */
/*-----------------------------------------------------*/

char *strnchr(char *string, int ch, int len)
{
	string[len] = '\0';
	while(len>0)
		string[--len] = ch;

        return(string);
}

/*------------------------------------------------------*/
/*---------------------rtrim----------------------------*/
/*DESCRIPTION: Puts a null char directly after the last */
/*	non-blank char in a null terminated string.	*/
/*							*/
/*RETURNS: the address of string			*/
/*USES: nothing						*/
/*IN: string.c						*/
/*------------------------------------------------------*/

char *rtrim(char *string)
{
	int     nonblank = -1, i=0;

	for(; string[i] != '\0'; ++i)
	  if(string[i] != ' ')
	     nonblank = i;

	string[nonblank+1] = '\0';

	return(string);
}

/*------------------------------------------------------*/
/*---------------------rtrimlen-------------------------*/
/*RETURNS: the length of s not counting trailing blanks */
/*USES: nothing						*/
/*IN: string.c						*/
/*------------------------------------------------------*/

int rtrimlen(const char *s)
{
	int  nonblank=-1, i=0;

	for(; s[i] != '\0'; ++i)
	   if(s[i] != ' ')
		nonblank = i;

	return(nonblank+1);
}

/*------------------------------------------------------------ */
/*-----------------------MidStr------------------------------- */
/*DESCRIPTION: Copies n chars from src to dest followed by the */
/*	null ch.					       */
/*							       */
/*RETURNS: the address of dest  			       */
/*USES: nothing						       */
/*IN: string.c						       */
/*------------------------------------------------------------ */

char *MidStr (char *dest, const char *src, int n)
{
   int i;

   for(i=0; i < n; ++i)
     dest[i] = src[i];

   dest[n] = '\0';
   return(dest);
}

/*------------------------------------------------------*/
/*---------------ltrim----------------------------------*/
/*DESCRIPTION: Takes the leading spaces out of a string.*/
/*							*/
/*RETURNS: the address of string			*/
/*USES: MidStr						*/
/*IN: string.c					 	*/
/*------------------------------------------------------*/

char *ltrim(char *string)
{
	int     FirstNonBlank=0, i = -1;

	do
	{
	   ++i;
	   if(!FirstNonBlank && string[i] != ' ')
	      if((FirstNonBlank = i)==0)
			break;
	   if(FirstNonBlank)
	      string[i-FirstNonBlank] = string[i];
	}while(string[i] != '\0');

	return(string);
}

/*------------------------------------------------------*/
/*---------------charpos--------------------------------*/
/*DESCRIPTION: Finds the position of ch in src.         */
/*                                                      */
/*RETURNS: The the address of string			      */
/*USES: Nothing                                         */
/*IN: string.c					 	                */
/*------------------------------------------------------*/
int charpos( const char *src, char ch)
{
     int p = 0;
     if (strlen(src) == 0)
	 return(1 == 0);

     while( src[p] != ch )
	 if (src[p++] == '\x0')
	      return (1 == 0);

     return(p);
}

/*------------------------------------------------------*/
/*---------------Add_Comma------------------------------*/
/*DESCRIPTION: Converts a real number into a formatted  */
/*             string with commas and decimals          */
/*                                                      */
/*EXAMPLE: 1000.23 becomes $1,000.23                    */
/*RETURNS: The the address of string			*/
/*USES: Nothing                                         */
/*IN: string.c					 	*/
/*------------------------------------------------------*/
char *add_comma(double x, int dec, int dolsign)
{
     char buffer[40] = "";
     char dblstr[40] = "";
     int i, l, cnt, index;

     sprintf(dblstr, "%30.*f", dec, x);
     ltrim(dblstr);

     l = strlen(dblstr);
     strspc(buffer, 39);

     if (dec)
         {
         for (i=l-1 ,cnt=0; cnt<dec+1; --i, ++cnt)
              buffer[cnt] = dblstr[i];

         for (i=l-dec-2,cnt=dec+1,index=0; i>=0; --i, ++cnt)
              {
              buffer[cnt] = dblstr[i];
              index++;
              if (index == 3 && i>0)
                   {
	           buffer[++cnt] = ',';
	           index=0;
                   }
              }
         }/* End If Dollar Sign */
     else
         for (i=l-1,cnt=0, index=0; i>=0; --i, ++cnt)
              {
              buffer[cnt] = dblstr[i];
              index++;
              if (index == 3 && i>0)
                   {
	           buffer[++cnt] = ',';
	           index=0;
                   }
              }
     buffer[cnt] = '\0';

     if (dolsign)
         strcat(buffer, "$");

     strrev(buffer);

     return(buffer);
}

/*
void main(void)
{
    double batchbal=5000;

    printf("%s\n", add_comma(batchbal, 10, 0));

}
 */