
#include <dos.h>

char far *VIDEO_BASE = 0;

void dma_init(int mode);
void SaveScrn (int, int, int, int, char *);
void RestScrn (int, int, int, int, char *);
void dma_init(int video_mode)
{

	if (video_mode == 7)

                VIDEO_BASE = (char far *) 0xb0000000;
        else
                VIDEO_BASE = (char far *) 0xb8000000;
}

void dma_puts (int x, int y, int attr, char *pointer)
{
        char far *current_pos;

	if(!VIDEO_BASE)
	    dma_init(video_mode());

	current_pos = VIDEO_BASE + (y-1)*160 + (x-1)*2;

	while ( *pointer  != '\0' )
        {
                *current_pos++ = *pointer++;
                *current_pos++ = (char) attr;
        }
}


void SaveScrn (x, y, width, length, buffer)
int x, y, width, length;
char *buffer;
{

        char x1, y1;
        char far *current_pos;
	width += --x;
	length += --y;

	if(!VIDEO_BASE)
	    dma_init(video_mode());

	for ( y1= y; y1 < length ; y1++ )
        {
                current_pos = VIDEO_BASE + (y1*160) + x*2;
		for ( x1 = x; x1 < width; x1++ )
                {
                        *buffer++ = *current_pos ++;
                        *buffer++ = *current_pos ++;
                }
        }
}

void RestScrn (x, y, width, length, buffer)
int x, y, width, length;
char *buffer;
{

        char x1, y1;
        char far *current_pos;
	width += --x;
	length += --y;

	if(!VIDEO_BASE)
	    dma_init(video_mode());

	for ( y1= y; y1 < length ; y1++ )
        {
                current_pos = VIDEO_BASE + (y1*160) + x*2;
		for ( x1 = x; x1 < width; x1++ )
                {
                        *current_pos ++ = *buffer++;
                        *current_pos ++ = *buffer++;
                }
         }
}

/*------------------------NewClear--------------------------*/
/*DESCRIPTION: Clears the screen by filling it with  chars.*/
/*							    */
/*INPUT: foreground - color of foreground in design	    */
/*       backgound - color of backgound in design	    */
/*USES: nothing						    */
/*----------------------------------------------------------*/

void NewClear(int foreground, int background)
{
	char far *current_pos;
	char fillchar = '';
	unsigned short	attr, i;

	if(!VIDEO_BASE)
	    dma_init(video_mode());

	current_pos = VIDEO_BASE;

	attr = foreground + (background << 4);

	for(i = 0; i<2000; ++i)
	{
		*current_pos++ = fillchar;
		*current_pos++ = attr;
	}
}

int video_mode (void)
{
    union REGS r;
    r.h.ah = 15;
    return ( int86(0x10, &r, &r) & 255 );
}

/* main()
{
	char buff[500];

	NewClear(1, 7);
	dma_puts(5, 5, 1, "hello");
	SaveScrn(1, 2, 10, 10, buff);
	dma_puts(2, 3, 1, "hi there");
	RestScrn(1, 2, 10, 10, buff);

} */

