#include <alloc.h>
#include <mem.h>

char *temp;
size_t Width;
int (*Fcmp) (const void huge *, const void huge *);

void exchange(char huge *elt1, char huge *elt2)
{
   int i;

   for(i=0; i<Width; ++i)
      temp[i] = elt1[i];
   for(i=0; i<Width; ++i)
      elt1[i] = elt2[i];
   for(i=0; i<Width; ++i)
      elt2[i] = temp[i];
}

size_t partition(char huge *base, size_t first, size_t last)
{

   void huge *pivot;
   size_t up, down;

   pivot = base+(long)first*Width;
   up = first;
   down = last;

   do
   {
      while (Fcmp(base+(long)up*Width, pivot) <= 0 && up < last)
	++up;

      while(Fcmp(base+(long)down*Width, pivot) > 0)
	--down;

      if(up < down)
      {
	 exchange(base+(long)up*Width, base+(long)down*Width);
      }
   } while( up < down);

   exchange(base+(long)first*Width, base+(long)down*Width);

   return(down);
}

void QuickSort(void huge *base, size_t first, size_t last)
{
    size_t  PivIndex;

    if(first < last)
    {
       PivIndex = partition(base, first, last);
       QuickSort(base, first, PivIndex-1);
       QuickSort(base, PivIndex+1, last);
    }
}

/*--------------------------HugeQsort-------------------------*/
/*DESCRIPTION: the QuickSort algorithm using huge pointers    */
/*							      */
/* paramaters and returns are the same as the C qsort excpt   */
/* all pointers are huge				      */
/*------------------------------------------------------------*/

void HugeQsort(void huge *base, size_t nelem, size_t width, int (*fcmp)
		(const void huge *, const void huge *))
{
    temp = malloc(width);
    Width = width;
    Fcmp = fcmp;

    QuickSort(base, 0, nelem-1);

    free(temp);
}

void huge *HugeBsearch(const void *key, const void huge *base, size_t nelem,
	size_t width, int (*fcmp)(const huge void*, const void*))
{
   int   cmp;
   long last;    /* because last may be negative & int is too small */
   size_t middle, first;

   first = 0;
   last = nelem-1;

   do
   {
      middle = ((long)first+last)/2;
      if((cmp = fcmp((char huge *)base+(long)middle*width, key)) > 0)
	last = middle -1l;
      else
	first = middle +1;
   }while(first <= last && cmp != 0);

   if(cmp==0)
	return((char huge *)base+(long)middle*width);
   else
	return(NULL);
}

/*
int Fstrcmp(const char *str1, const char *str2)
{
    int i = -1;

    while(!(str1[++i]-str2[i]) && str1[i])
    ;
    return(str1[i] - str2[i]);
} */


