#include <funcs.h>
char	nullc[] = "\0";
int FG = -1, BG = -1;

/*-----------------------Frame-----------------------------------*/
/*DESCRIPTION:  Displays a frame of specified colors, dimensions */
/*	and text on the console					 */
/*								 */
/*INPUT: type FrameDataType defined in funcs.h			 */
/*   .X  x coordinate of upper left corner of frame		 */
/*   .Y  y coordinate of upper left corner of frame		 */
/*   .L  length of frame					 */
/*   .W  width of frame						 */
/*   .F  foreground color					 */
/*   .B  background color					 */
/*   .BorderType   0 =  border		     		 */
/*  		    1 =  border		     		 */
/*  		    2 =  top,  sides			     	 */
/*  		    3 =  top,  sides             		 */
/*  		    4 = plain border		     		 */
/*   .txt[X] pointer to char.  X range 0-24			 */
/*   .clear - 0 clear .txt after displaying			 */
/*            1 leave .txt unchanged				 */
/*	      2 initialize .txt array (no display)		 */
/*	      0 or 1 + 10 -- don't disp a shadow around the frame*/
/*USES: strspc, writeat						 */
/*---------------------------------------------------------------*/

void Frame ( FrameDataType *Framedat )

{
    int i, len;

    char line[160];
    char BorderCh[5][7] = {"ͻȼ", "Ŀٳ", "͸Ծ", "ķӽ", "      "};


    if(Framedat->clear == 2)
    {	for (i = 0; i < 24; ++i)
		Framedat->txt[i] = nullc;
	Framedat->clear = 0;
	return;
    }
    if(Framedat->BorderType >4 || Framedat->BorderType < 0)
       Framedat->BorderType = 0;

/**********************************
     check and evaluate input data
***********************************/

    if (Framedat->X <= 0  || Framedat->X >= 80 )

     {
      printf("\nBad X Range For Frame");
      exit(1);
     }

    if (Framedat->Y <= 0  || Framedat->Y >= 25 )
     {
      printf("\nBad Y Range For Frame");
      exit(1);
     }

    if (Framedat->W <= 1  || Framedat->X+Framedat->W > 80 )
     {
      printf("\nBad Width Range For Frame");
      exit(1);
     }

    if (Framedat->L <= 1  || Framedat->Y+Framedat->L + (Framedat->clear >= 10) ? 0:1 > 25 )
     {
      printf("\nBad Length Range For Frame");
      exit(1);
     }

/******************
    Print Top Line
*******************/

    line[0] = BorderCh[Framedat->BorderType][0];
    strnchr(line+1, BorderCh[Framedat->BorderType][1], Framedat->W-2);
    *(line+Framedat->W-1) = BorderCh[Framedat->BorderType][2];
    *(line+Framedat->W) = '\0';
    WriteAt(Framedat->X, Framedat->Y, Framedat->F, Framedat->B, line);

/*    gotoxy ( Framedat->X, Framedat->Y );

    putch(BorderCh[Framedat->BorderType][0]);

    for ( i=Framedat->X+1; i<=Framedat->X+Framedat->W-1; i++)
      putch(BorderCh[Framedat->BorderType][1] );

    putch  (BorderCh[Framedat->BorderType][2]);
*/
/***************
    Print Middle
****************/
    for ( i = 0; i < Framedat->L-2; i++)
     {
      strcpy(line, BorderCh[Framedat->BorderType]+5);
      if(!Framedat->txt[i]) Framedat->txt[i] = nullc;
      strcat(line, Framedat->txt[i]);
      len = strlen(line);
      strspc(line + len, Framedat->W - len);
      strcpy(line + Framedat->W-1, BorderCh[Framedat->BorderType]+5);

      Write(line);

      if (Framedat->clear % 10 != 1)
	Framedat->txt[i] = nullc;

     }

/*********************
    Print Bottom Line
***********************/
    line[0] = BorderCh[Framedat->BorderType][3];
    strnchr(line+1, BorderCh[Framedat->BorderType][1], Framedat->W-2);
    *(line+Framedat->W-1) = BorderCh[Framedat->BorderType][4];
    *(line+Framedat->W) = '\0';
    Write(line);

    if(Framedat->clear >=10) return;

/***********************
    Print bottom shadow
************************/

   SaveScrn(Framedat->X, Framedat->Y+Framedat->L, Framedat->W-1, 1, line);

/* make every other char (the attribute bytes) = DARKGRAY fg, BLACK bg */
   for(i=1; i < (Framedat->W-1)*2; i +=2)
     line[i] = 8;
   RestScrn(Framedat->X, Framedat->Y+Framedat->L, Framedat->W-1, 1, line);


/*    gettext(Framedat->X-1, Framedat->Y+Framedat->L+1, Framedat->X+Framedat->W,
                          Framedat->Y+Framedat->L+1, line );

    gotoxy(Framedat->X-1,Framedat->Y+Framedat->L+1);

    j = (Framedat->W) * 2;

    for ( i=0; i<=j; i+=2)
      putch(line[i]); */

/***********************
   print side shadow
************************/

   SaveScrn(Framedat->X-1, Framedat->Y+1, 1, Framedat->L, line);

/* make every other char (the attribute bytes) = DARKGRAY fg, BLACK bg */
   for(i=1; i < (Framedat->L)*2; i +=2)
     line[i] = 8;
   RestScrn(Framedat->X-1, Framedat->Y+1, 1, Framedat->L, line);

}
/*main()
{
    int i, j;
    FrameDataType  Fr;

    textcolor(4);
    textbackground(2);
    for(i=0; i<80; ++i)
      for(j=65; j<90; ++j)
	putch(j);
    Fr.X  = 20; Fr.Y = 8;
    Fr.L = 8; Fr.W = 40;
    Fr.F = 7; Fr.B = 1;
    Fr.clear = 2;
    Frame(&Fr);
    Fr.txt[1] = "  hello world";
    Fr.txt[2] = "from this little frame.";
    Frame(&Fr);
} */
