#include <dos.h>
#include <string.h>
#include <stdlib.h>
#include <funcs.h>

unsigned int DateToVal(struct date date1)
{
   unsigned int yrdays, modays;
   int mo, dy, yr;
   int md[] = {0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};

   mo = date1.da_mon;
   dy = date1.da_day;
   yr = date1.da_year - 1900;

   if(yr == 0 && mo == 0 && dy == 0)   return(0);

/*   yrdays = (yr - 1) * 365.25; */
   yrdays = ((yr - 1) * 36525l)/100;
   --mo;
   modays = (mo>=0 && mo<=11) ? md[mo] : 0;

   if(mo > 1 && (yr % 4) == 0) ++modays;  /* leap year */

   return(yrdays + modays + dy);
} /* Date to value */

void ValToDate(unsigned int Value, struct date *the_date)
{
	int  lb[] = {1, 32, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
	int yr, mo, days, leapday, year;

	if(Value == 0) {
	  the_date->da_day = 0;
	  the_date->da_mon = 0;
	  the_date->da_year = 0;
	  return;  }

	/* floating point stuff doesn't always work in Turbo C so don't
	   use it unless you have to. */

	year =  Value * 100l / 36525l;

	if(year *100l == Value*10000l / 36525l) {
	   the_date->da_day = 31;
	   the_date->da_mon = 12;
	   the_date->da_year = year+1900;
	   return;  }

	days = Value - year * 36525l / 100;
	yr = year;
	++yr;

	leapday = (yr % 4 == 0 && days == 60);

	if(yr % 4 == 0 && days >= 60) --days;

	if(days <1 || days > 365) {
	   the_date->da_day = 0;
	   the_date->da_mon = 0;
	   the_date->da_year = 0;
	   return;  }

	for(mo=0; mo<12; ++mo)
	{
	  if(days < lb[mo])
	    break;
	}

	days -= lb[mo-1] - 1;
	if(leapday) days = 29;

	the_date->da_day = days;
	the_date->da_mon = mo;
	the_date->da_year = yr+1900;
	return;
} /* value to date */

validdate(int dd, int mm, int yy)
{
	if (dd < 1 || dd > 31)
		return(0);
	if (mm < 1 || mm > 12)
		return(0);
	if ((mm == 4 || mm == 6 || mm == 0 || mm == 11) && dd > 30)
		return(0);
/*	if (yy <= 80)
		return(0); */
	if (mm == 2 && dd > 29)
		return(0);
	if ((yy % 4 != 0) && dd > 28 && mm==2)
		return(0);

	return(1);
}

/*---------------------ConvertDate------------------------------*/
/*DESCRIPTION:	Converts a date in src_format to a date in      */
/*	dest_format.  May take the system date as input.	*/
/*								*/
/*INPUT: 							*/
/*  src_format =                                                */
/*  0 -- Julian date (unsigned int)                             */
/*  1 -- System date                                            */
/*  3 -- MMDDYY                                                 */
/*  4 -- YYMMDD							*/
/*  5 -- MM-DD-YY                                               */
/*  6 -- MM/DD/YY                                               */
/*  7 -- M-D-YYYY                                               */
/*  8 -- M/D/YYYY                                               */
/*                                                              */
/*  dest_format =  same as src_format except			*/
/*  1 -- Month D, YYYY						*/
/*  2 -- Weekday, Month D, YYYY					*/
/*  9 -- 0-6 (char) for day of week with 0 -> Sunday 		*/
/*                                                              */
/*RETURNS: 0 for a valid date					*/
/*	   -1 for an invalid date or format			*/
/*USES: MidStr, ValToDate, DateToVal, validdate 		*/
/*--------------------------------------------------------------*/

int ConvertDate(void *dest_date, void *src_date, int dest_format, int src_format)
{
     char tmp[15], *ptr;
     char *month[] = { "illegal", "January", "February", "March",
			"April", "May", "June", "July", "August",
			"September", "October", "November", "December"};
     char *day[] = { "Sunday", "Monday", "Tuesday", "Wednesday", "Thursday",
			"Friday", "Saturday"};

     struct date dte;

     switch (src_format)
     {
       case 0: ValToDate( *((unsigned int *) src_date), &dte); break;
       case 1: getdate(&dte); break;
       case 3: dte.da_day = atoi(MidStr(tmp, ((char *) src_date)+2, 2));
	       dte.da_mon = atoi(MidStr(tmp, (char *) src_date, 2));
	       dte.da_year = atoi(((char *) src_date)+4)+1900;
	       break;
       case 4: dte.da_day = atoi(((char *) src_date)+4);
	       dte.da_mon = atoi(MidStr(tmp, ((char *) src_date)+2, 2));
	       dte.da_year = atoi(MidStr(tmp, (char *) src_date, 2))+1900;
	       break;
       case 5: case 6: case 7: case 8:
	       if(strlen((char *)src_date) > 14)
		   MidStr(tmp, (char *)src_date, 14);
	       else
		   strcpy(tmp, (char *)src_date);
	       ptr = strtok(tmp, "-/ ");  dte.da_mon = atoi(ptr);
	       ptr = strtok(NULL, "-/ "); dte.da_day = atoi(ptr);
	       ptr = strtok(NULL, "-/ "); dte.da_year = atoi(ptr);
	       if(src_format==5 || src_format==6)
		  dte.da_year += 1900;
	       break;
       default: return(-1);
     }

     if(!validdate((int)dte.da_day, (int)dte.da_mon, dte.da_year-1900))
       return(-1);

     switch (dest_format)
     {
	case 0: *((unsigned int *) dest_date) = DateToVal(dte); break;
	case 1 : sprintf((char *) dest_date, "%s %1d, %d",
		month[dte.da_mon], dte.da_day,
		dte.da_year); break;
	case 2 : sprintf((char *) dest_date, "%s, %s %1d, %d",
		day[(DateToVal(dte) +1) % 7],
		month[dte.da_mon], dte.da_day,
		dte.da_year); break;
	case 3 : sprintf((char *) dest_date, "%2.2d%2.2d%2.2d",
		dte.da_mon, dte.da_day,
		(dte.da_year - 1900)); break;
	case 4 : sprintf((char *) dest_date, "%2.2d%2.2d%2.2d",
		(dte.da_year - 1900), dte.da_mon,
		dte.da_day); break;
	case 5 : sprintf((char *) dest_date, "%2.2d-%2.2d-%2.2d",
		dte.da_mon, dte.da_day,
		(dte.da_year - 1900)); break;
	case 6 : sprintf((char *) dest_date, "%2.2d/%2.2d/%2.2d",
		dte.da_mon, dte.da_day,
		(dte.da_year - 1900)); break;
	case 7 : sprintf((char *) dest_date, "%1d-%1d-%d",
		dte.da_mon, dte.da_day,
		dte.da_year); break;
	case 8 : sprintf((char *) dest_date, "%1d/%1d/%d",
		dte.da_mon, dte.da_day,
		dte.da_year); break;
	case 9 : *((char *) dest_date) = (DateToVal(dte)+1) % 7;
	default : return(-1);
     }
    return(0);
}
/*
main()
{
  char date1[40] = "";
  unsigned int d1980 = 0;
  unsigned int val = 6036;

  ConvertDate(&d1980, "01/01/80", 0, 6);

  ConvertDate(&val, "12/20/91", 0, 6);

  printf("%s\n", date1);
  getch();


}
 */