/*-------------------------- ShowClock --------------------------------*/
/*                                                                     */
/* Description:  Displays the current system time on the screen        */
/*               in the format 00:00:00 (a/p).m.                       */
/*                                                                     */
/* Input:                                                              */
/*     **  GLOBAL VARIABLES IN FUNCS.H                                 */
/*                                                                     */
/*     ClockX - x coordinate of display                                */
/*     ClockY - y coordinate of display                                */
/*     ClockF - foreground color of display                            */
/*     ClockB - background color of display                            */
/*                                                                     */
/* Uses WriteAt.                                                       */
/*                                                                     */
/*---------------------------------------------------------------------*/

#include <dos.h>

int ClockX = 1;
int ClockY = 1;
int ClockF = 14; /* YELLOW */
int ClockB = 1;  /* BLACK  */


void ShowClock(void)
{
  struct time mytime;

  gettime(&mytime);

  WriteAt( ClockX, ClockY, ClockF, ClockB, "%2d:%2.2d:%2.2d %s",
	(mytime.ti_hour>12)?(int)(mytime.ti_hour-12):(int)mytime.ti_hour,
	(int)mytime.ti_min,
	(int)mytime.ti_sec,
	(mytime.ti_hour>12)? "p.m.":"a.m.");
}

void ShowDate(void)
{
  char tmp[35] = "";

  ConvertDate(&tmp, "", 2, 1 );

  WriteAt(81-strlen(tmp), 1, ClockF, ClockB, tmp);
}
