 /***************************************************************************
 *
 *     This program contains hllapi functions to interact with the host.
 *
 *     ---------------------------------------------------------------
 *
 *     Ross Abraham	October 2, 1990
 *
 **************************************************************************/

#include <stdio.h>
#include <pcb.h>

#define DEBUG	  0			/* 1 to insert debugging code */

#define MAX_TRIES 18
#define API_File_Name  "API.ERR"
#define X_CLOCK    198
#define QUESTION    24
#define PLUS        53

int api_func;				/* function requested */
int api_null = 0;			/* null data string */
int api_len;				/* length of the string */
int api_retc;				/* return code */
char api_nullc;
int irma;
struct query
{
	char far q_short_name;
	char far q_long_name[8];
	char	 q_sess_type;
	int	 q_ps_size;
} qp[6];

char parms[] = "NEWRET NOATTRB NOEAB STRLEN CONLOG ESC=@ AUTORESET SRCHALL SRCHFRWD";

extern void CLIM (int function, char *DataString, int DataStringLen,
		int *RetCode, int SoftwareType);

extern unsigned int TCLIM(unsigned int *, unsigned char *,
						  unsigned int *, unsigned int *);

/*-----------------------------------------------------------------*/
/*--------------------- CONNECT FUNCTION --------------------------*/

Connect(char short_name)

{
	unsigned int  i;
	unsigned char date[9] = "00/00/00";
	unsigned char far *pointer;

	pointer = (char far *)0xF000FFF5;
	for(i=0; i<8; ++i)
	   date[i] = *pointer++;
	irma = strcmp(date, "11/08/82") != 0;
	if (irma)
	   short_name = 'E';

	/*  issue the connect request  */

	api_func = PCB_CONNECT;

	CLIM( api_func, &short_name, api_len, &api_retc, irma);

	switch( api_retc )
	{
	case PCB_RC_CONNECT_OK:
	case PCB_RC_CONNECT_OK_BUSY:
		break;

	default:
                API_Error(PCB_CONNECT, api_retc);
	}
	return(irma);
}

/*---------------------------------------------------------*/
/*--------------------QUERY FUNCTION-----------------------*/

void Query(char *data_string)

{
	/*
	 * issue query for session location
	 */

	 int j, i;
	api_func = PCB_QUERY;
	api_len = sizeof(qp);
	CLIM(api_func, ((unsigned char *)&qp[0]), api_len, &api_retc, irma);
	if( api_len == 0 )
	{
                message(0, "Error 005: No configured sessions");
		exit(1);
	}

	for( i = 0, j = 0; i < api_len; ++i )
	{
		if( qp[i].q_sess_type == 'H')
		{
			j = 1;
			break;
		}
	}
	if( j == 0 )
	{
                message(0, "Error 010: No configured host session");
		exit(1);
	}

	i = sizeof(qp);
	for (i = 0; i < api_len; ++i)
	{
		data_string[i] = qp[i].q_short_name;
		strcpy( (data_string + 1 + i * 12), qp[i].q_long_name);
		data_string[i* 12 + 9] = qp[i].q_sess_type;
		data_string[i* 12 + 10] = qp[i].q_ps_size;
	}
}

/*-----------------------------------------------------------*/
/*-------------------RESERVE FUNCITON------------------------*/

void Reserve()

{
	/*
	 * reserve the session
	 */
	api_func = PCB_RESERVE;
	CLIM(api_func, &api_nullc, api_len, &api_retc, irma);
	if (api_retc != PCB_RC_RESERVE_OK)
	{
		api_func = PCB_DISCONNECT;
		CLIM(api_func, &api_nullc, api_null, &api_null, irma);
                API_Error(PCB_RESERVE, api_retc);
	}
}

/*-----------------------------------------------------------*/
/*-------------------SENDKEY FUNCION-------------------------*/

void SendKey(char *send_string)
{
        int j;
        char OIA_Str[102];
        int func, len, retc;

 	api_len = strlen( send_string);

	/*
	 * send the key string to the emulator
	 */
         for (j=0; j<103; ++j) OIA_Str[j] = ' ';

         func = PCB_COPYOIA;
         len = 103;
         CLIM(func,OIA_Str,len,&retc,irma);
         //TCLIM(&func, (char *)OIA_Str, &len, &retc);

         switch( retc) {
              case PCB_RC_COPYOIA_OK:
              case PCB_RC_COPYOIA_INCOMPL_BUSY:
              case PCB_RC_COPYOIA_INCOMPL_LOCKED:
                   break;
              default:
                   API_Error(func, retc);
                   break;
              }

         if (OIA_Str[11] == QUESTION && OIA_Str[12] == PLUS)
              /* Locked key board */
              {
	      api_func = PCB_SEND_KEY;
	      CLIM(api_func, "@R", 2, &api_retc, irma);
              }

         else if( (unsigned)OIA_Str[9] == X_CLOCK)
              Wait();


	if( api_len != 0 )
	{
		api_func = PCB_SEND_KEY;
		CLIM(api_func, send_string, api_len, &api_retc, irma);
		switch (api_retc) {
		   case PCB_RC_SEND_KEY_FAIL_BUSY:
		   case PCB_RC_SEND_KEY_FAIL_LOCKED:
			Wait();
			api_len = strlen( send_string);
			api_func = PCB_SEND_KEY;
			CLIM(api_func, send_string, api_len, &api_retc, irma);
			break;

		   default:
                        break;
		 }

		if (api_retc != PCB_RC_SEND_KEY_OK )
		{
                   API_Error(api_func, api_retc);
		}
	}
}

/*-------------------------------------------------------*/
/*-----------------------WAIT FUNCTION-------------------*/

Wait()
{
     int i, j;
     int OK=0;
     char OIA_Str[102];
     int func, len, retc;

     /*
     * wait for screen to become unbusy
     */

     for(i=0; i<10000 && OK<5; ++i)
         {

         for (j=0; j<103; ++j) OIA_Str[j] = ' ';

         func = PCB_COPYOIA;
         len = 103;
         CLIM(func,OIA_Str,len,&retc,irma);
         //TCLIM(&func, (char *)OIA_Str, &len, &retc);

         switch( retc) {
              case PCB_RC_COPYOIA_OK:
              case PCB_RC_COPYOIA_INCOMPL_BUSY:
              case PCB_RC_COPYOIA_INCOMPL_LOCKED:
                   break;
              default:
                   API_Error(func, retc);
                   break;
              }

         if (OIA_Str[11] == QUESTION && OIA_Str[12] == PLUS)
              /* Locked key board */
              SendKey("@R");

         else if( (unsigned)OIA_Str[9] == X_CLOCK)
              /* Loop for a while */
              {
              for (j=-32768; j<32767; ++j) j=j;
              }
         else
              {
              OK++;
              break;
              }
         }

     api_func = PCB_WAIT;
     CLIM(api_func, &api_nullc, api_len, &api_retc, irma);

     if( api_retc != PCB_RC_WAIT_OK )
         API_Error(PCB_WAIT, api_retc);

     return(1);
}

/*
void Wait()
{
	int i;
		api_func = PCB_WAIT;
		for(i=0; i < 5; ++i)
		  CLIM(api_func, &api_nullc, api_len, &api_retc, irma);

		if( api_retc != PCB_RC_WAIT_OK )
                        API_Error(PCB_RESERVE, api_retc);
}
*/

/*-----------------------------------------------------------*/
/*-------------------SEARCH FUNCTION-------------------------*/

void Search(char *search_string, int *location)

{
	/*
	* search the presentation space for desired string
	*/
	int row, col;

	api_len = strlen(search_string);
	if( api_len > 0 )
	{
		api_func = PCB_SEARCH;

		api_retc = 1;
		CLIM(api_func, search_string, api_len, &api_retc, irma);
		if (api_retc == 0 )
			*location = 0;
		else
		{
			row = api_retc / 80 + 1;
			col = api_retc - (row - 1) * 80;
			*location = row * 100 + col;
		}
	}
	else
		*location = 0;
}

/*-----------------------------------------------------------*/
/*--------------------GET CURSOR POSITION--------------------*/

int GetPosition(void)
{
	int	row, col;
	int func, len, retc;
	char nullc;

	func = api_func = PCB_GET_POSITION;
	if(irma)
	{
        CLIM(func,&nullc,len,&retc,irma);
	   //TCLIM(&func, &nullc, &len, &retc);
	   if(retc != PCB_RC_GETPOS_OK)
	   {
              API_Error(PCB_GET_POSITION, retc);
	   }
	   api_retc = len;
	}
	else
	  CLIM(api_func, &api_nullc, api_len, &api_retc, irma);

	row = api_retc / 80 + 1;
	col = api_retc - (row - 1) * 80;
	return(row * 100 + col);
}

/*-----------------------------------------------------------*/
/*-------------------SENDSTRING FUNCION-------------------------*/

void SendString(char *send_string, int position)
{
	int row, col;
        int j;
        char OIA_Str[102];
        int func, len, retc;

	api_len = strlen( send_string);

	/*
	 * send the string to the emulator
	 */

         for (j=0; j<103; ++j) OIA_Str[j] = ' ';

         func = PCB_COPYOIA;
         len = 103;
         CLIM(func,OIA_Str,len,&retc,irma);
         //TCLIM(&func, (char *)OIA_Str, &len, &retc);

         switch( retc) {
              case PCB_RC_COPYOIA_OK:
              case PCB_RC_COPYOIA_INCOMPL_BUSY:
              case PCB_RC_COPYOIA_INCOMPL_LOCKED:
                   break;
              default:
                   API_Error(func, retc);
                   break;
              }

         if (OIA_Str[11] == QUESTION && OIA_Str[12] == PLUS)
              /* Locked key board */
              {
	      api_func = PCB_SEND_KEY;
	      CLIM(api_func, "@R", 2, &api_retc, irma);
              }

         else if( (unsigned)OIA_Str[9] == X_CLOCK)
              Wait();

	row = position /100;
	col = position - row * 100;
	api_retc = (row - 1) * 80 + col;

	api_len = strlen( send_string);

	if( api_len != 0 )
	{
		api_func = PCB_COPY_STR_TO_FLD;
		CLIM(api_func, send_string, api_len, &api_retc, irma);
		switch (api_retc) {
		   case PCB_RC_COPY_STRTOFLD_FAIL_BUSY:
		   case PCB_RC_COPY_STRTOFLD_FAIL_LOCKED:
			Wait();
			api_len = strlen( send_string);
			api_func = PCB_COPY_STR_TO_FLD;
			CLIM(api_func, send_string, api_len, &api_retc, irma);
			break;
		   default: break;
		 }

		if (api_retc != PCB_RC_SEND_KEY_OK && api_retc != PCB_RC_COPY_STRTOFLD_OK_SIZE)
		{
                   API_Error(api_func, api_retc);
		}
	}
}

/*--------------------------------------------------------------*/
/*-------------------SET SESSION PARAMETERS FUNCION-------------*/
int SetParameters(char far *send_string)
{
	/*
	 * send string
	 */
	api_len = sizeof( send_string) - 1;
	if( api_len > 0 )
	{
		api_func = PCB_SET_PARAMS;
		CLIM(api_func, (char *)send_string, api_len, &api_retc, irma);
		if (api_retc != PCB_RC_SET_PARAMS_OK )
		{
                   API_Error(api_func, api_retc);
		}
	}
	return(0);
}

/*-----------------------------------------------------------*/
/*---------------RELEASE FUNCTION----------------------------*/
void Release()

{
	 /* release the session */
	api_func = PCB_RELEASE;
	CLIM(api_func, &api_nullc, api_len, &api_retc, irma);
	if (api_retc != PCB_RC_RELEASE_OK)
	{
		api_func = PCB_DISCONNECT;
		CLIM(api_func, &api_nullc, api_null, &api_null, irma);
                API_Error(PCB_RELEASE, api_retc);
	}
}


/*------------------------------------------------------------*/
/*-------------------DISCONNECT FUNCTION----------------------*/

void Disconnect()

{
	/* disconnect the session */
	api_func = PCB_DISCONNECT;
	CLIM(api_func, &api_nullc, api_len, &api_retc, irma);
	if (api_retc != PCB_RC_DISCONNECT_OK)
	{
            API_Error(api_func, api_retc);
	}
}

/*--------------------------------------------------------------*/
/*---------------------COPYSTRING FUNCION-----------------------*/

void CopyString(char *data_string, int position, int length)

{
	int row, col, i;

	row = position /100;
	col = position - row * 100;
	api_retc = (row - 1) * 80 + col;
	api_len = length;
	api_func = PCB_COPY_STRING;

	CLIM(api_func, data_string, api_len, &api_retc, irma);
	if (api_retc == PCB_RC_COPY_STRING_OK_BUSY)
	{	Wait();
		api_len = length;
		api_retc = (row - 1) * 80 + col;
		api_func = PCB_COPY_STRING;
		CLIM(api_func, data_string, api_len, &api_retc, irma);
	}

	if (api_retc != PCB_RC_COPY_STRING_OK)
	{
           API_Error(api_func, api_retc);
	}

	/* since strings are null terminated in C, remove nulls copied */
	/* from the screen */
	for (i = 0; i <= length - 1; ++i)
		if (data_string[i] == '\0')
			data_string[i] = ' ';

	data_string[length] = '\0';
}


/*------------------------------------------------------------*/
/*----------------COPY PRESENTATION SPACE FUNCION-------------*/

void CopyPS(char *data_string)

{
	int i;

	api_func = PCB_COPYPS;
     api_len = 1920;
	CLIM(api_func, data_string, api_len, &api_retc, irma);

	if (api_retc == PCB_RC_COPYPS_OK_BUSY)
	{	Wait();
		api_func = PCB_COPYPS;
		CLIM(api_func, data_string, api_len, &api_retc, irma);
	}

	if (api_retc != PCB_RC_COPYPS_OK)
	{
                   API_Error(api_func, api_retc);
	}

	/*  since strings are null terminated in C, nulls from the screen */
	/*  must be removed. */
	for (i = 0; i<= 1919; ++i)
		if (data_string[i] == '\0')
			data_string[i] = ' ';

	   /* the following statement forces the string to be 1920 chars*/
	data_string[1920] = '\0';
}

/*------------------------------------------------------------*/
/*----------------COPY OPERATION INFORMATION AREA FUNCION-----*/

void CopyOIA(char *data_string)

{
	int i;
	char d_string[103];
	int retc;
	int func;
	int len;

	for (i=0; i<103; ++i) d_string[i] = 0;

	func = PCB_COPYOIA;
     CLIM(func,d_string,len,&retc,irma);
	//TCLIM(&func, d_string, &len, &retc);

	if (api_retc != PCB_RC_COPYOIA_OK && api_retc != PCB_RC_COPYOIA_INCOMPL_BUSY && api_retc != PCB_RC_COPYOIA_INCOMPL_LOCKED)
	{
                   API_Error(api_func, api_retc);
	}

	for (i=0; i<103; ++i)
	   data_string[i] = d_string[i];

	data_string[103] = 0;
}


/*------------------------------------------------------------*/
/*----------------------DEBUGGER CODE MAIN--------------------*/

#if DEBUG
    void main(void)
    {
	char string[150];

	Connect('C');

        SendKey("@y");
        SendString("ALPH", 102);
	Wait();

    }
#endif
