PROGRAM PROG3;
{$U+          Copyright (C), 1985 by Lyle Faurot.  All rights reserved.

   New Topics: Comments
               Output with the Write and WriteLn statements
               Compiler directive - $U+

   Note that this block of comments, extending over several lines
   is included between a single set of brackets at the left.

   $U+ is a special form of comment, called a compiler directive.
   This directive, $U+, will appear in most of the sample programs
   to make sure you can terminate a program without having to reboot.
   (More about compiler directives later.)

}

(*  Parentheses and asterisks can also be used to enclose a comment *)

BEGIN
  WriteLn('* * * * * * * * * * * * * * * * * *');  {Note that comments      }
  WriteLn('*                                 *');  {placed at the end of a  }
  WriteLn('*          TURBO-LESSON 3         *');  {statement line should   }
  WriteLn('*                                 *');  {be bracketed on the     }
  WriteLn('*  Edited, Compiled, Executed by  *');  {same line.  A multiline }
  WriteLn('*       (put your name here)      *');  {comment, like the one at}
  WriteLn('*                                 *');  {the beginning of this   }
  WriteLn('* * * * * * * * * * * * * * * * * *');  {program would include   }
  {    some of the non-comment statements, making them ineffective.         }

  {The fact that statements can be temporarily killed by commenting them
   out illustrates the usefulness of a second type of comment delimiter.

   Try killing several of the WriteLn statements above by inserting
   (*  to the left of the first statement to be killed and
   *)  to the left of the statement AFTER the last statement to be killed.
       Run the program to see the results.
  }

  WriteLn;
  Write  ('Check carefully when ');
  Write  ('you run this program. ');
  Write  ('How many lines ');
  WriteLn('are printed');
  WriteLn('by this last set of Write and WriteLn statements?');

END. {PRG3}
