PROGRAM PROG2;
{          Copyright (C), 1985 by Lyle Faurot.  All rights reserved.

Note that this program is not a program to compile and run,
but a tutorial on editing programs.

PROG2 is part of TURBO-LESSON 2.

OBJECTIVE 3.  Move the cursor to desired location.
(See TURBO-LESSON 2 for list of objectives).

One of the basics of any screen editor or word processor is the
ability to move around the screen easily.  The arrow keys at the
right of the keyboard are used to move the cursor.  Note that
the following may be substituted for the arrow keys:

       ctrl-s  = left-arrow
       ctrl-d  = right-arrow
       ctrl-e  = up-arrow
       ctrl-x  = down-arrow

##### DO:

Try out the cursor movement keys by moving the cursor to the
numbers below in order starting at 1:

                       1
                                           4
                3
       5
               2         6

##### DO:

Move the cursor around while watching the top line of this
screen.  The line and column are always indicated there
if you need this information.

Notice that the screen can be "pushed" up or down by holding
down the up-arrow or down-arrow.  

##### DO:

Try out this feature by scrolling to the beginning of this 
program, using the up-arrow, and then scrolling back here using 
the down-arrow.  

Was that a little slow?  There are some faster ways to move the
cursor if you are moving it more than a few spaces or lines.
Instead of using the up-arrow to scroll to the beginning of this
file, you could have used ctrl-PgUp.  

##### DO:

Try ctrl-PgUp then return here using the down arrow.  To get to 
the end of the file, use ctrl-PgDn.  Before you try that, you 
should know that PgUp and PgDn without the control key will move 
the cursor up or down one screen at a time.  

##### DO:

Try crtl-PgDn to move the cursor to the end of this file and 
return here using ctrl-PgUp.  

Another useful combination is ctrl-left-arrow and ctrl-right-arrow.
By using the control key with the left and right arrow keys you can
move left or right one word at a time.

##### DO:

Use ctrl-left-arrow and ctrl-right-arrow to move the cursor back 
and forth one word at a time on these two lines. 

Also try crtl-up-arrow.  What happened?  Only the left and right 
arrow keys are combined with the control key for cursor control.  

The Home and End keys are also used for cursor control.  

##### DO:

Try the Home and End keys.  

What happens?  This gives you a quick way to get to the beginning 
or end of a line.  You will find the End key especially useful in 
writing programs.  

What cursor movement results when you combine the control key 
with Home and End.  Try it!  

##### DO:

Experiment with ctrl-Home and ctrl-End.

This provides a quick route to the top or bottom of the current 
screen.  

LEARNING THESE CURSOR MOVEMENT KEYS AND KEY COMBINATIONS NOW
WILL SAVE TIME AND FRUSTRATION LATER WHEN YOU ARE WORKING
ON PROGRAMS!  YOU MAY WANT TO POST THE FOLLOWING LIST BY YOUR
COMPUTER UNTIL YOU BECOME COMFORTABLE WITH EDITING.

     Left-arrow       Left one character
     Right-arrow      Right one character
     Ctrl-Left-arrow  Left one word
     Ctrl-Right-arrow Right one word
     Home             Left end of current line
     End              Right end of current line
     Ctrl-Home        Top of current screen
     Ctrl-End         Bottom of current screen
     PgUp             Previous screen
     PgDn             Next screen
     Ctrl-PgUp        Beginning of file
     Ctrl-PgDn        End of file
(Program PROG2A will print this table.)


OBJECTIVE 4.  Insert/replace text.

There are two ways to type text when using an editor or word
processor:  

(1) Insert new text while pushing existing text to the right to 
make room for the new text, and 

(2) Replace text by typing over the original text.  

##### DO:

Look at the top line of this screen while depressing the Ins
key several times.  The status line indicates "Insert" or
"Overwrite" mode is presently active.  The Ins key gives you
a way to switch modes.

##### DO:

Try the two typing modes on the practice text below:

*************************************************************
      PRACTICE TEXT: DON'T WORRY ABOUT MAKING A MISTAKE --
THIS TEXT IS HERE FOR YOUR EXPERIMENTATION.  Use the better
of the two modes to correct mistakes, insert some new text
(how about a nice, overworked term like "user-friendly"),
and change some of the upper case text to lower case.

There ar  sume mistekes hear   for you to coreect.

Use the Insert mode with the right arrow and the space bar
to correct the following:
Thequickbrownfoxjumpedoverthelazydog'sback.
*************************************************************


OBJECTIVE 5.  Delete text.

There are several ways to delete text:

(1) Use the Del key or ctrl-G to delete the character at the
cursor position and pull the characters from the right.  You
might think of this as "eating" the characters to the right.

##### DO:

Use the Del key and Ctrl-G to eliminate the x's below:

abcdexxxfghijkxxxxxxxxlmxnopxxxqrstxxxxxxxxxxxxxxxuvwxyz.

(2) Use the backspace key to delete the character to the left
of the cursor and pull the characters from the right.  This
"eats" characters to the left.  

##### DO:

Use the backspace to eliminate the letters from f to k in the 
practice line above.  

NOTE THAT Del, ctrl-G, and backspace WORK THE SAME WAY IN
EITHER INSERT OR OVERWRITE MODE.

(3) Use the space bar to space out characters in the OVERWRITE
mode.  You shouldn't need this very often if you learn to use
the other methods for deleting text.

(4) Use ctrl-Y to delete the entire line.  

##### DO:

Delete the blank line and the extra Line2 below using ctrl-Y:
       Line 1
       Line 2
       Line 2
       Line 3

       Line 4
       Line 5


OBJECTIVE 6.  Auto-tab for readable programs.

PASCAL provides very good tools for structuring programs.
The advantages gained from carefully structuring a program will
be wasted if the program itself is not typed in a manner which
makes the structure clear.  Tabbing in this editor is a little
different - depressing the tab key advances the cursor to a
position under the next word in the previous line!  That may
seem a little strange, but don't make up your mind until you
try the both exercises in this section.  

On a typewriter the tabs are fixed.  Each time you depress the
TAB key you move so many spaces.  TURBO sets the tabs by looking
at the line immediately above the cursor.  The first letter in
each word is the position of your tab for the line below.

For example, this line sets tabs in the positions numbered below:
1   2        3    4    5    6    7  8   9         10       11

When I type in a different line, the tabs change--like this
1    2 3    4  5 6         7     8   9    10           11

This makes it easy to line up program commands with tabs:

No indent on this line.  Typing return and TAB after here
   Produces first indent under the "i." Typing return here
   Continues under the letter "P."  Typing return then TAB here
             Indents under the letter "u."  Return after here
             Lines up under "I."  Return again after here
             Does the same!

In the sample program below, the first line is entered manually,
resulting in tabs at characters "i" ":" "I" on the first line.

##### DO:

Try the tab feature by typing in the following program segment: 

VAR   i,j,k          : Integer; 
      a,b,c,d        : Real;
      First_Name     : String[10];
      Last_Name      : String[16];
      Zip            : String[5];

(With the Insert mode on, the program segment may be typed in
below without overwriting the text that follows.)




A feature based on this tabbing technique is used to provide
"structured" indentation of statement lines.  


##### DO:

Watch the line at the top of the screen as you depress ctrl-Q 
followed by ctrl-I several times.  

The word, Indent, should toggle on and off.  When Indent appears 
in the status line, the automatic indentation feature is active.  

When the enter key is depressed, the cursor will return to a 
position under the leftmost word of the previous line if the 
Indent feature is active.  Otherwise, the cursor returns to the 
left margin.  

Remember ctrl-Q, ctrl-I will toggle this feature off (and back 
on) in case it gets in your way at times.  

##### DO:

Try typing in the following statements with the Indent feature
on to see how it works:

BEGIN
  REPEAT
     i := i + k;
     c := a + b;
     REPEAT
        ReadLn(First_Name);
        ReadLn(Last_Name);
        WriteLn(First_Name, ' ',Last_Name);
     UNTIL Last_Name = 'ZZZ';
     WriteLn('All names printed');
  UNTIL i > 20;
END.

********** End of PROG2 tutorial ******************
}


