{$A-}
Unit STRLIB;


Interface

TYPE  str1      =  string[1];   str2      =  string[2];
      str3      =  string[3];   str4      =  string[4];
      str5      =  string[5];   str6      =  string[6];
      str7      =  string[7];   str8      =  string[8];
      str9      =  string[9];   str10     =  string[10];
      str11     =  string[11];  str12     =  string[12];
      str13     =  string[13];  str14     =  string[14];
      str15     =  string[15];  str16     =  string[16];
      str17     =  string[17];  str19     =  string[19];
      str20     =  string[20];  str22     =  string[22];
      str23     =  string[23];  str24     =  string[24];
      str25     =  string[25];  str26     =  string[26];
      str30     =  string[30];  str31     =  string[31];
      str32     =  string[32];  str33     =  string[33];
      str35     =  string[35];  str38     =  string[38];
      str39     =  string[39];  str40     =  string[40];
      str41     =  string[41];  str42     =  string[42];
      str43     =  string[43];  str45     =  string[45];
      str48     =  string[48];  str49     =  string[49];
      str46     =  string[46];  str50     =  string[50];
      str52     =  string[52];  str55     =  string[55];
      str60     =  string[60];  str63     =  string[63];
      str65     =  string[65];  str66     =  string[66];
      str70     =  string[70];  str71     =  string[71];
      str72     =  string[72];  str73     =  string[73];
      str75     =  string[75];  str76     =  string[76];
      str79     =  string[79];  str80     =  string[80];
      str81     =  string[81];  str132    =  string[132];
      str255    =  string[255];

FUNCTION RemoveLB(Instr:string):string;
{-remove leading blanks of string.}

FUNCTION RemoveTB(Instr:string):string;
{-remove leading blanks of string}

FUNCTION Strip_blks(Instr:string):string;
{-removes leading and trailing spaces of string.}

Function Locase(c:char):char;
{-return the lower case of the alphabet}

function UpcaseStr(S : string) : string;
{-UpcaseStr converts a string to upper case }

function LoCaseStr(S : string) : string;
{- LoCaseStr converts a string to Lower case }

Function CapWords(S:string):string;
{-capitalize the first letter of each word}

FUNCTION repeatchr(c:CHAR;l:INTEGER):string;
{-generate L number of repeated characters}

function CenterStr(S : string; Width : Byte) : string;
{- center a string (s) within N columns.}


function CenterChr(S : string; Ch : Char; Width : Byte) : string;
{- center a string (s) within N columns of char ch.}

Function IntStr(i : integer; f : shortint):str7;
{- convert integer number to a string function 12/8/86}
{- Input I - integer to convert, F-field format}

Function WordStr(i:word; f : shortint):str7;
{- convert word number to a string function 12/8/86}
{- Input I - word to convert, F-field format}


Function LongIntStr(i : Longint; f : shortint):str10;
{- convert longint number to a string function 9/21/88}
{- Input I - longint to convert, F-field format}

function strint(s:str7):integer;
{-convert a alphanumeric to a integer}

function strlongint(s:str25):Longint;
{-convert a alphanumeric to a integer}

function strword(s:str7):word;
{-convert a alphanumeric to a word}

function strreal(s:str20):real;
{-convert a alphanumeric to a real}

function Substr(s:string; target:string; replace:string):string;
{- substitute the "target" string with the "replace" string in string "s".

   ie s := 'HECTOR SANTOS';
      s := substr(s,'HEC','SAN');
      s => 'SANTOR SANTOS'
}

FUNCTION removestring(s:string; target:string):string;
{- Remove the "target" string from the input string "s".

   ie s := 'HECTOR SANTOS';
      s := removestring(s,'HEC');
      s => 'TOR SANTOS'
}

Function First_non_Space(s:string):byte;

PROCEDURE SplitString(InStr:string; N : integer; VAR Out1,Out2:string);
{
SplitString : This Procedure will split a string (Instr) into two parts
              (Out1, Out2).  Out1 will retain the length given by N minus
              the amount so that the out1 does not end with a partial word.

}

Function Mat2Str(var mat; s : byte):string;

(* Pascal to ASCIIzed string conversion *)

procedure PasToZ(s: String);

{$V-}
function nextword(var s : string):string;
function strtoken(var s : string; Delimiters:string):string;
{$V+}

Function RemoveBackSlash(s:string):string;
function ForceExtension(Name, Ext : string) : string;
function DefaultExtension(Name, Ext : string) : string;
function HasExtension(Name : string; var DotPos : Word) : Boolean;

{===========================================================================}

Implementation

(* Pascal to ASCIIzed string conversion *)

procedure PasToZ(s: String);

var
   n: Word;
begin
   n := Byte(s[0]);
   if (n > 0) then
   begin
      Move(s[1],s[0],n);
      s[n] := #0
   end
end;

FUNCTION RemoveLB(Instr:string):string;
{-remove leading blanks}

VAR n : INTEGER;
BEGIN
 n := 1;
 WHILE (instr[n]=' ') and (n < LENGTH(instr)) DO n := n+1;
 RemoveLB := COPY(instr,n,length(instr));
END; {end Function removelb}


FUNCTION RemoveTB(Instr:string):string;

VAR n : INTEGER;
BEGIN
n := LENGTH(instr);
WHILE instr[n]=' ' DO
   BEGIN
     instr := COPY(instr,1,n-1);
     n := n-1;
     IF n=0 then
        begin
         RemoveTb := '';
         EXIT;
        end;
   END;
RemoveTB:= instr;
END; {end Function removetb}


FUNCTION Strip_blks(Instr:string):string;
{-removes leading and trailing spaces of string.}

BEGIN
 strip_blks := Removelb(Removetb(instr));
END; {end Function strip_blks}



Function Locase(c:char):char;
{-return the lower case of the alphabet}
 
begin
  locase := c;
  if c in ['A'..'Z'] then locase := chr(ord(c)+32);
 end;


function UpcaseStr(S : string) : string;
{-  UpcaseStr converts a string to upper case }

var
  P : Integer;
begin
  for P := 1 to Length(S) do
    S[P] := Upcase(S[P]);
  UpcaseStr := S;
end;


function LoCaseStr(S : string) : string;
{- LoCaseStr converts a string to Lower case }

var
  P : Integer;
begin
  for P := 1 to Length(S) do
    S[P] := LoCase(S[P]);
  LoCaseStr := S;
end;


Function CapWords(S:string):string;
{-capitalize the first letter of each word}

Var l : byte absolute s;
    i : byte;
    c : char;
 begin
   For i := 1 to l do
      if s[i]<> ' ' then
         If i=1
            then s[i]:=Upcase(s[i])
            else if s[i-1] in [' ','-']
                    then s[i]:=Upcase(s[i])
                    else s[i] := Locase(s[i]);
   Capwords := s;
 end;


FUNCTION repeatchr(c:CHAR;l:INTEGER):string;
{-generate L number of repeated characters}

VAR junk : string;
    i    : INTEGER;
BEGIN
repeatchr := '';
IF l<=0 then exit;
junk [0] := chr(l);
fillchar(junk[1],l,c);
repeatchr := junk;
END;


function CenterChr(S : string; Ch : Char; Width : Byte) : string;
{-Return a string centered in a string of Ch with specified width}
  var
    o : string;
  begin
    if Length(S) >= Width then
      CenterChr := S
    else begin
      o[0] := Chr(Width);
      FillChar(o[1], Width, Ch);
      Move(S[1], o[Succ((Width-Length(S)) shr 1)], Length(S));
      CenterChr := o;
    end;
  end;

function CenterStr(S : string; Width : Byte) : string;
    {-Return a string centered in a blank string of specified width}
  begin
    CenterStr := CenterChr(S, ' ', Width);
  end;


Function IntStr(i : integer; f : shortint):str7;
{- convert integer number to a string function 12/8/86}
{- Input I - integer to convert, F-field format}

var e : integer; j : str6;
 begin
 j := '';
 str(i:f,j);
 IntStr := j;
end;

Function WordStr(i :word; f : shortint):str7;
{- convert word number to a string function 12/8/86}
{- Input I - word to convert, F-field format}

var j : str7;
 begin
 j := '';
 str(i:f,j);
 WordStr := j;
end;

Function LongIntStr(i : Longint; f : shortint):str10;
{- convert longint number to a string function 9/21/88}
{- Input I - longint to convert, F-field format}

var j : str10;
 begin
 j := '';
 str(i:f,j);
 LongIntStr := j;
end;

function strint(s:str7):integer;
{-convert a alphanumeric to a integer}

var i,err : integer;

begin
 strint := 0;
 val(s,i,err);
 if err = 0 then strint := i;
end;

function strlongint(s:str25):Longint;
{-convert a alphanumeric to a Long integer}

var err : integer; i : longint;

begin
 strLongint := 0;
 val(s,i,err);
 if err = 0 then strLongint := i;
end;


function strword(s:str7):word;
{-convert a alphanumeric to a word}

var i   : word;
    err : integer;

begin
 strword := 0;
 val(s,i,err);
 if err = 0 then strword := i;
end;


function strreal(s:str20):real;

var err : integer;
    i   : real;

begin
 strreal := 0;
 val(s,i,err);
 if err = 0 then strreal := i;
end;



FUNCTION SUBSTR(s:string; target:string; replace:string):string;
{- substitute the "target" string with the "replace" string in string "s"}

{
 IE  s := 'HECTOR SANTOS';
      s := substr(s,'HEC','SAN');
      s => 'SANTOR SANTOS'
}


VAR slen  : BYTE ABSOLUTE s;
    tlen  : BYTE ABSOLUTE target;
    rlen  : BYTE ABSOLUTE replace;
    p     : INTEGER;
BEGIN
p := POS(target,s);
substr := s;
IF (p <> 0) AND ((slen-tLen+rlen)<=255)  {2nd condition checks for max len}
   THEN BEGIN
        DELETE(s,p,tlen);
        INSERT(replace,s,p);
        substr := s;
        END;
END; {end function substr}

FUNCTION removestring(s:string; target:string):string;

VAR slen  : BYTE ABSOLUTE s;
    tlen  : BYTE ABSOLUTE target;
    p     : INTEGER;
BEGIN
p := POS(target,s);
removestring := s;
IF (p <> 0)
   THEN BEGIN
        DELETE(s,p,tlen);
        removestring := s;
        END;
END; {end function substr}

Function First_non_Space(s:string):byte;
 var i : byte;
  begin
   First_non_space := 0;
   if length(s) = 0 then exit;
   i := 0;
   while (s[i+1] = ' ') and ((i+1) < length(s)) do i:=i+1;
   First_non_space := i;
  end;




PROCEDURE SplitString(InStr:string; N : integer; VAR Out1,Out2:string);
{
SplitString : This Procedure will split a string (Instr) into two parts
              (Out1, Out2).  Out1 will retain the length given by N minus
              the amount so that the out1 does not end with a partial word.

}

VAR I   : INTEGER;

BEGIN
out1 := '*** Error In String Split ***';
out2 := '*** Error In String Split ***';
instr := RemoveTb(instr);
i := n;
if (n >= length(instr)) then
   begin
      out1 := instr;
      out2 := '';
      exit;
   end;

WHILE (Instr[i]<>' ') AND (i<>0) DO i := i - 1;
IF i<>0
   THEN BEGIN
        Out1 := COPY(instr,1,i);
        Out2 := COPY(instr,i+1,LENGTH(instr));
        END;
END; {end splitstring}

Function Mat2Str(var mat; s : byte):string;
{-convert s bytes in mat into a string}
var i  : byte;
    js : string;
type
   chars = array[1..maxint] of char;
 begin
   i := 1;
   js := '';
   while (i <= s) and ((chars(mat)[i]) <> chr(0)) do
       begin
         js := js + chars(mat)[i];
         i := i +1;
       end;

   Mat2str := js;
 end;


function nextword(var s : string):string;
var p : byte;
  begin
    nextword := '';
    s := strip_blks(s);
    if length(s)=0 then exit;
    p := pos(' ',s);
    if p > 0
     then begin nextword := copy(s,1,p-1); Delete(s,1,p); end
     else begin nextword := s; s:= ''; end;
  end;

function Strtoken(var s : string; delimiters:string):string;
var p,b : byte;
    vkeys : set of char;
  begin
    StrToken := '';
    s := strip_blks(s);
    if length(s)=0 then exit;
    vkeys := [];
    for p := 1 to length(delimiters) do vkeys := vkeys + [delimiters[p]];

    if s[1] in Vkeys then delete(s,1,1);

    for p := 1 to length(s) do
       begin
         if s[p] in vkeys then
            begin
               strtoken := copy(s,1,p-1);
               Delete(s,1,p);
               exit;
            end;
       end;
    StrToken := S;
    s        := '';
  end;

Function RemoveBackSlash(s:string):string;
  begin
    if (s[length(s)] = '\') and (length(s) > 3) then
       Delete(s,length(s),1);
    RemovebackSlash := S;
  End;

function HasExtension(Name : string; var DotPos : Word) : Boolean;
  {-Return whether and position of extension separator dot in a pathname}
var
  I : Word;
begin
  DotPos := 0;
  for I := Length(Name) downto 1 do
    if (Name[I] = '.') and (DotPos = 0) then
      DotPos := I;
  HasExtension := (DotPos > 0) and (Pos('\', Copy(Name, Succ(DotPos), 64)) = 0);
end;

function DefaultExtension(Name, Ext : string) : string;
  {-Return a pathname with the specified extension attached}
var
  DotPos : Word;
begin
  if HasExtension(Name, DotPos) then
    DefaultExtension := Name
  else
    DefaultExtension := Name+'.'+Ext;
end;

function ForceExtension(Name, Ext : string) : string;
  {-Return a pathname with the specified extension attached}
var
  DotPos : Word;
begin
  if HasExtension(Name, DotPos) then
    ForceExtension := Copy(Name, 1, DotPos)+Ext
  else
    ForceExtension := Name+'.'+Ext;
end;


End.
