{$A-}
UNIT FIDOFMT;
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%                                                                       %*)
(*%                                                                       %*)
(*%        F I D O   M E S S A G E   S T R U C T U R E                    %*)
(*%                                                                       %*)
(*%                                                                       %*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%*)
(*                                                                         *)
(* Opus stores and handles its messages in the traditional FTSC FidoNet    *)
(* message format with the exception that additional dating information    *)
(* is added in a set of two 'timestamp' fields that indicate when a        *)
(* message was created and when it arrived on the system and in the use    *)
(* of certain message flags.  The extended use of the flags is done in     *)
(* such a way as to only be of use within the Opus environment and avoids  *)
(* conflict with other systems which adhere to basic FidoNet standards.    *)
(*                                                                         *)
(* In a manner directly descended from the original Fido<tm> BBS system,   *)
(* messages are stored in one or more directories which each correspond    *)
(* to a System Area (topic).  Each message is stored in its own file and   *)
(* has a file name format "#.MSG" where "#" is the assigned number of the  *)
(* message.  The first messages in any given area would be named 1.MSG,    *)
(* 2.MSG, and so on.                                                       *)
(*                                                                         *)
(* Each message file consists of a fixed-length header record, immediately *)
(* followed by a variable-length stream of ASCII text that is terminated   *)
(* by an ASCII NULL (Code 0).  All text is considered to be unformatted    *)
(* and continuous without end-of-line sequences unless they are meant to   *)
(* unconditionally force a new paragraph.  Traditionally, some message     *)
(* editors and BBS's use a  $8D character (CR with 8th bit ON) as a "soft" *)
(* carriage return.  These should be treated as superfluous *unless" they  *)
(* are immediately followed by a space.  In that case, the line that the   *)
(* space starts is considered to be fixed format and should not be word    *)
(* wrapped as all other message text will be.                              *)
(*                                                                         *)
(* The header data contains fixed information about the author, addressee, *)
(* creation and arrival dates, subject, message numbers that it replies to *)
(* or is answered by, privacy flags, and so on.  In the case of messages   *)
(* in a netmail area, there are many special flags used.                   *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)


(*-------------------------------------------------------------------------*)
(*  TIME STAMP  (Not an FTSC Standard. Unique to Opus)                     *)
(*-------------------------------------------------------------------------*)
(*                                                                         *)
(*  The following _stamp structure is used in Opus message headers to      *)
(*  store a message's creation date (when first written) and the date the  *)
(*  message arrived on the system such as when received via netmail.       *)
(*                                                                         *)
(*  This dating information is auxiliary and used by Opus only. It does    *)
(*  *not* replace the functionality of the FTSC standard ASCII formatted   *)
(*  date field which is also maintained by Opus for compatibility with the *)
(*  rest of the world.                                                     *)
(*                                                                         *)
(*-------------------------------------------------------------------------*)

INTERFACE

(*--------------------------------------------------------------------------*)
(* msg.h - Message header                                                   *)
(*--------------------------------------------------------------------------*)
type _fido_fromtype    = string[35];
     _fido_totype      = string[35];
     _fido_subtype     = string[71];
     _fido_datetype    = string[19];

Type _fidomsgtype =
    record
      from         : _fido_fromtype; (* 0 *)
      towhom       : _fido_totype;   (* 35 *)
      subject      : _fido_subtype;  (* 71 *)
      azdate       : _fido_datetype; (* 142 Obsolete/unused ASCII date information        *)
      timesread    : word;           (* 162 FIDO<tm>: Number of times read                *)
      dest_node    : word;           (* 164 Destination node                              *)
      orig_node    : word;           (* 166 Origination node number                       *)
      cost         : word;           (* 168 Unit cost charged to send the message         *)
      orig_net     : word;           (* 170 Origination network number                    *)
      dest_net     : word;           (* 172 Destination network number                    *)

      date_written : longint;        (* 176 When user wrote the msg              *)
      date_arrived : longint;        (* 180 When msg arrived on-line             *)
      reply        : word;           (* 184 Current msg is a reply to this msg number     *)
      attr         : word;           (* 186 Attribute (behavior) of the message           *)
      up           : word;           (* 188 Next message in the thread
   *) end;

(*--------------------------------------------------------------------------*)
(* Message attributes                                                       *)
(*--------------------------------------------------------------------------*)

Const MSGPRIVATE  = $0001; (* For addressee *ONLY*    * 0000 0000 0000 0001 *)
Const MSGCRASH    = $0002; (* High priority           * 0000 0000 0000 0010 *)
Const MSGREAD     = $0004; (* Was read by addressee   * 0000 0000 0000 0100 *)
Const MSGSENT     = $0008; (* Was sent by FidoMail      0000 0000 0000 1000 *)
Const MSGFILE     = $0010; (* SUBJ=file(s) to send    * 0000 0000 0001 0000 *)
Const MSGFWD      = $0020; (* Msg from & to elsewhere   0000 0000 0010 0000 *)
Const MSGORPHAN   = $0040; (* Msg destination unknown   0000 0000 0100 0000 *)
Const MSGKILL     = $0080; (* Delete after sending    * 0000 0000 1000 0000 *)
Const MSGLOCAL    = $0100; (* Msg is Local, not Net     0000 0001 0000 0000 *)
Const MSGHOLD     = $0200; (* Hold msg for pickup     * 0000 0010 0000 0000 *)
Const MSGCRAP     = $0400; (* ---------------------- X  0000 0100 0000 0000 *)
Const MSGFRQ      = $0800; (* SUBJ=file(s) to get     * 0000 1000 0000 0000 *)
Const MSGRRQ      = $1000; (* Msg Receipt requested  X* 0001 0000 0000 0000 *)
Const MSGCPT      = $2000; (* Msg is a Msg Receipt   X* 0010 0000 0000 0000 *)
Const MSGARQ      = $4000; (* Audit Trail requested  X* 0100 0000 0000 0000 *)
Const MSGURQ      = $8000; (* SUBJ=files(s) to UPD   X* 1000 0000 0000 0000 *)
                                                 (*------------------------*)
                                                 (* ^^                     *)
                                                 (* ||                     *)
                                                 (* ||* = preserved by     *)
                                                 (* ||    the network      *)
                                                 (* ||? = stripped by the  *)
                                                 (* |     net (FTSC spec)  *)
                                                 (* |     but preserved    *)
                                                 (* |     by seadog<tm>    *)
                                                 (* |X  = not used by Opus *)
                                                 (*------------------------*)

(*--------------------------------------------------------------------------*)
(* Area attributes (limit or describe the behavior of an area)              *)
(*--------------------------------------------------------------------------*)

Const  SYSMAIL      = $0001; (* is a mail area                                *)
Const  P_REP        = $0002; (* OPUS: Net mail private echomail back          *)
Const  NOPUBLIC     = $0004; (* OPUS: Disallow public messages                *)
Const  NOPRIVATE    = $0008; (* OPUS: Disallow private messages               *)
Const  ANON_OK      = $0010; (* OPUS: Enable anonymous messages               *)
Const  ECHOMAIL     = $0020; (* OPUS: Set=Echomail Clear=Not Echomail         *)
Const  OPUS_UALIAS  = $0040; (* OPUS170: Use user's alias in this area        *)
Const  HIGHBIT      = $0040; (* MAX:  Allow high-bit chars in this area       *)
Const  PASSTHROUGH  = $0080; (* OPUS170: Passthough Area only                 *)
Const  INBOUND      = $0100; (* OPUS170: Inbound Only area                    *)
Const  NREALNAME    = $0200; (* MAX:  Don't use ^aREALNAME for this area      *)
Const  USEREALNAME  = $0400; (* MAX:  Use usr.name instead of alias           *)
Const  CONF         = $0800; (* MAX:  Conference-type area (no origin/sb's)   *)
Const  MAX_UALIAS   = $1000; (* MAX:  Use usr.alias instead of usr.name       *)

IMPLEMENTATION

END.
