{$I-,R-}

unit Printer;

{ A replacement unit for the standard Turbo 4 PRINTER unit.
  This unit solves problems with outputing printer control strings
  and graphics data through the LST file.

  Version 1.0 -  1/24/1988 - First general release

  Scott Bussinger
  Professional Practice Systems
  110 South 131st Street
  Tacoma, WA  98444
  (206)531-8944
  Compuserve 72247,2671 }


interface

uses Dos;

var Lst: text;


implementation

var ExitSave: pointer;
    SaveMode: boolean;

function SetDeviceMode(Handle: word;SetRawMode: boolean): boolean;
  { Return the current value of the device raw/cooked mode and set to new mode }
  var Regs: Registers;
  begin
  with Regs do
    begin
    AX := $4400;                                 { Get the current device status }
    BX := Handle;
    MsDos(Regs);
    SetDeviceMode := odd(DX shr 5);              { Test the current value of RAW bit }
    AX := $4401;                                 { Set the new device status }
    BX := Handle;
    DX := DX and $00DF;                          { Clear the RAW bit }
    if SetRawMode then
      inc(DX,32);                                { Turn the RAW bit on }
    MsDos(Regs)
    end
  end;

{$F+}
procedure ExitHandler;
  { Restore the original PRN device mode and close file }
  var DontCare: boolean;
  begin
  ExitProc := ExitSave;                          { Chain to other exit procedures }
  DontCare := SetDeviceMode(TextRec(Lst).Handle,SaveMode); { Restore the original device mode }
  close(Lst)
  end;
{$F-}

begin
assign(Lst,'PRN');                               { Open the printer device }
rewrite(Lst);
SaveMode := SetDeviceMode(TextRec(Lst).Handle,true); { Set to RAW (binary) mode }
ExitSave := ExitProc;
ExitProc := @ExitHandler
end.
