{ Timerd12.inc - DOS event timer                            ver 1.2, 01-30-87 }
{   by Jim H. LeMay  CIS: 76011,217                                           }
{ A 24 hour timer with resolution of 1/18.2... seconds to measure elapsed time
  in seconds.  Works on all IBM compatible machines and is interchangeable with
  TIMERH.INC.  If TIMERH.INC can work on your machine, then use it; if not,
  TIMERD.INC will.  Both also compile with Turbo87.
  TO TEST: Remove the curly braces around "BEGIN ... END".  Compile and Run.
  TO USE:  Place "Timer(Start)" and "Timer(Stop)" as desired in your program.
           "ElapsedTime" gives result in seconds.  }

type
    StartStop = (Start, Stop, SetRead, ReadRead);
    TicksArray = array [1..5] of byte;
var
    t0,t1,t2,TicksPerDay,TicksPerSec,ElapsedTime: real;
    T1array,T2array: TicksArray;
const
    FirstTime: boolean = true;

procedure GetTicks (VAR Ticks: TicksArray);
begin
Inline(
  $1E                    {   push  ds               ;Save Turbo DS}
  /$31/$C0               {   xor   ax,ax            ;Set ax=0}
  /$8E/$D8               {   mov   ds,ax            ;Segment for DOS timer}
  /$BE/$6C/$04           {   mov   si,$046C         ;Offset for DOS timer}
  /$C4/$7E/<TICKS        {   les di,[bp+<Ticks]     ;Load address of split}
  /$FC                   {   cld                    ;Set direction forward}
  /$AB                   {   stosw                  ;Store zero}
  /$FA                   {   cli                    ;Clear interrupts}
  /$A4                   {   movsb                  ;Copy DOS low byte}
  /$A5                   {   movsw                  ;Copy DOS mid word}
  /$FB                   {   sti                    ;Allow interrupts}
  /$1F                   {   pop   ds               ;Restore Turbo DS}
)
end;

function ArrayToReal (Ticks: TicksArray): real;
begin
  ArrayToReal := ((Ticks[5]*256.0) + Ticks[4])*256 + Ticks[3]
end;

procedure TimerInit;
begin
  FirstTime := false;
  TicksPerDay := 1573040.0;             { DOS timer ticks/day. }
  TicksPerSec := TicksPerDay/86400.0;
  t0 := 0.0                             { only needed for TIMERH.INC }
end;

procedure Timer (SS: StartStop);
begin
case SS of
  Start: begin
           if FirstTime then TimerInit;
           ElapsedTime:=0;
           GetTicks (T1array)
         end;
  Stop:  begin
           GetTicks (T2array);
           t1 := ArrayToReal(T1array);           { Convert AFTER the event! }
           t2 := ArrayToReal(T2array);
           if t2<t1 then t2:=t2+TicksPerDay;
           ElapsedTime:= (t2-t1)/TicksPerSec     { units of seconds }
         end
  end   { end case }
end;

{
var ch: char;

BEGIN
  ClrScr;
  Writeln('Press any key for a lap; <ESC> to stop.');
  Timer (Start);
  repeat
    write(chr(16));
    read(Kbd,ch);
    Timer (Stop);
    writeln ('E.T. =',ElapsedTime:10:2,' secs: ticks2=',t2:12:0);
    GotoXY (24,wherey); WriteLn ('-ticks1=',t1:12:0);
    GotoXY (21,wherey); WriteLn ('E.T. ticks=',(t2-t1):12:0);
    writeln;
  until ch = chr(27)
END.
}
