Unit rand;

{RAND.TPU and RAND.PAS - Created August 27, 1992
 By Ray Sun

     RAND.PAS provides good random numbers for pascal users.  The
numbers provided should show a statistically acceptable amount of runs
and the average of the numbers should approach half of the input
integer i.  I credit a book of whose name I unfortunately cannot
remember for the algorithm used for the rectangularly distributed
random numbers.  I merely implemented the algorithm as a pascal unit
for the public to use.

     On the use of this code, please mention my name in the
documentation.  Thank you.
}

Interface

Var x, y, z : real;                                      { 3 seed values }

Function RandomNumber( i : integer ):integer;
Procedure Initialize;

Implementation

Function RandomNumber( i : integer ):integer;
Begin

{    x:=171 * (ix mod 177) - 2 * (ix / 177);              (* int random *)
     y:=172 * (iy mod 177) - 35 * (iy / 176);
     z:=170 * (iz mod 177) - 63 * (iz / 178);
     if x<0 then x:=ix+30269;
     if y<0 then y:=iy+30307;
     if z<0 then z:=iz+30323;                }

     x := (trunc( 171 * x ) mod 30269)*1.0;               { longint random }
     y := (trunc( 172 * x ) mod 30307)*1.0;
     z := (trunc( 170 * x ) mod 30323)*1.0;

     RandomNumber:=trunc((frac(x/30269.0+y/30307.0+z/30323.0))*i)+1;
end;

Procedure Initialize;
Begin
     Randomize;
     x := (Random(maxint-1)+1)*1.0;           { Initialize seed values of }
     y := (Random(maxint-1)+1)*1.0;           { x, y, and z.  }
     z := (Random(maxint-1)+1)*1.0;
end;
END.
