{PikTest, by Stephen C. McGough: a sample program to demonstrate the use
	of the PickFile procedure in the PikFile unit}

Program PikTest;
uses crt,dos,pikfile;
var
  Infile : Text;
	FileLine : string;
	I        : byte;
	ch       : char;
begin
	Template := 'c:\tp\*.pas';
	PickFile(Template,anyfile-directory,Result);
	ClrScr;
  Case Result of
		0:begin
				HighVideo;
				Writeln('The file chosen was ',Template);
				LowVideo;
			end;
		1:begin
				Writeln('There are no files matching your specifications on this path');
				{Here, whatever you want to do next}
			end;
		2:begin
				Writeln('The path you gave cannot be used by DOS,');
				Writeln('so please input a correct one.');
				{Here, a recall of the path input routine and a retry of PickFile}
			end;
		3:begin
				Writeln('You did not choose a file.');
				{Here, however you want to handle this}
			end;
		4:begin
				Writeln('The disk drive door is open, or you put the disk in the wrong drive');
				Writeln('Please correct the problem and press any key.');
      	Repeat until Keypressed;
				{Here, a recall to the pickfile routine}
			end;
  end;

{Let's make this into a simple file lister, just to make sure that
 it works!}

If Result = 0 then
	begin
		Assign(Infile,Template);
		Reset(Infile);
		GotoXY(1,25);
		HighVideo;
		Write('Press "q" to quit, or any other key to see another 18 lines.');
		LowVideo;
		Window(1,4,80,22);
		Repeat
		  for I := 1 to 18 do
				begin
					Readln(Infile,FileLine);
					Writeln(FileLine);
				end;
			ch := ReadKey;
			if Eof(Infile) then ch := 'q';
		Until ch = 'q';
	end;
	Window(1,1,80,25);
	GotoXY(1,25);
	ClrEol;
end.