program polyroot(input,output);
(* Program uses the Newton-Raphson technique to find a simple real root *)
(* of a polynomial and removes it by synthetic division.  The procedure *)
(* may be continued until all such roots are found or until the reduced *)
(* polynomial is of degree 2.  If the polynomial can be reduced to one *)
(* of degree 2, the quadratic formula is applied to yield all roots. *)

label 10,20;
type vector = array[0..10] of real;
var coef: vector;
    x0,error: real;
    degree,delta,i,maxiter,counter: integer;
    q1,q2,q3,q4: char;

procedure readin(var a1: vector; n1: integer);
(* Reads in polynomial coefficients from the keyboard. *)

var i: integer;

begin
   for i := 0 to n1 do
      begin
         write('Input the A(',i,') coefficent: ');
         readln(a1[i]);
      end;
   writeln('The polynomial coefficients are: ');

   writeln;
   for i := 0 to n1 do
      begin
         write(a1[i]:9,'  ');
      end;
   writeln;
end;



procedure newtraf(coef: vector; error1: real; var root: real; var k1:integer;
                  n1,max: integer);
(* Searches for a real root of a polynomial by the Newton-Raphson technique. *)

var yd,fcn,deriv,a1: real;
    i: integer;

begin
   a1 := 1.0;
   fcn := a1*coef[0];
   for i := 1 to n1 do
      begin
         a1 := root*a1;  (* finds root^i *)
         fcn := fcn + a1*coef[i];   (* value of trunc polynomial *)
      end;
   a1 := 1.0;
   deriv := a1*coef[1];
   for i := 1 to (n1-1) do
      begin
         a1 := root*a1;
         deriv := deriv + (i+1)*a1*coef[i+1]; (* value of derivative *)
      end;
   yd := deriv;
   if deriv = 0.0 then
     begin
        yd := 0.0000001;  (* prevent divide by zero *)
        writeln('Try a new guess!');
     end;
   root := root - fcn/yd;
   k1 := k1 + 1;
   writeln('Value of fcn: ',fcn:9);
   if (k1 < max) and (abs(fcn/yd) > error1) then
      newtraf(coef,error1,root,k1,n1,max);
end;



procedure syndiv(var c:vector; root: real; var n1: integer);
(* Carries out synthetic division of a real polynomial by a first-degree *)
(* real polynomial. *)

label 10;
type vect2 = array[0..1] of real;
var a: vector;
    b: vect2;
var i,j: integer;

begin
   b[1] := 1.0;
   b[0] := -root;
   for i := n1 downto 1 do
      begin
         a[i-1] := c[i]/b[1];
         if i = 1 then
            goto 10;
         for j := 0 to 1 do
            begin
               c[i-j] := c[i-j] - a[i-1]*b[1-j];
            end;
         10:writeln;
      end;
   n1 := n1 - 1;
   for i := 0 to n1 do
      begin
         c[i] := a[i];
      end;
end;

procedure quadroot(c: vector); 
(* Applies quadratic formula to a real second-degree polynomial, *)
(* in the form  c[2]*x*x + c[1]*x + c[0] = 0 *)
var y,y1,x1,x2,z1,z2: real;
  begin
    y := c[1]*c[1]/4-c[2]*c[0];
    y1 := sqrt(abs(y));
    z1 := -c[1]/(2*c[2]);
    z2 := y1/c[2];
    if y > 0 then
      begin
        x1 := z1 + z2;
        x2 := z1 - z2;
        writeln('The roots are: ',x1:10,' and ',x2:10);
      end
    else
      begin
        write('The roots are: ',z1:9,' + j',z2:9);
        writeln(' and  ',z1:9,' - j',z2:9);
     end;
  end;

begin  (* main *)
   write('Input degree of polynomial: ');
   readln(degree);
   writeln;
   readin(coef,degree);
   write('Input convergence factor: ');
   readln(error);
   writeln;
   write('Input maximum number of iterations: ');
   readln(maxiter);
   writeln;
10:counter := 0;
   write('Input the initial guess: ');
   readln(x0);
   writeln;
20:newtraf(coef,error,x0,counter,degree,maxiter);
   writeln;
   writeln('The calculated root is: ',x0:10);
   writeln('The number of iterations is: ',counter);
   writeln;
   writeln('Try another initial guess (y,n)? ');
   readln(q1);
   if q1 = 'y' then
      goto 10;
   write('More iterations (y,n)? ');
   readln(q2);
   if q2 = 'y' then
      begin
         writeln('How many more iterations: ');
         readln(delta);
         maxiter := maxiter + delta;
         writeln;
         write('New convergence factor (y,n)?');
         readln(q3);
         if q3 = 'n' then
            goto 20;
         write('Input new convergence factor: ');
         readln(error);
         goto 20;
      end;
   syndiv(coef,x0,degree);
   writeln('The coefficients of the resulting polynomial are: ');
   writeln;
   for i := 0 to degree do
      begin
         write(coef[i]:8:3,'  ');
      end;
   writeln;
   if degree > 2 then
      begin
         write('Continue to search for roots (y,n)? ');
         readln(q4);
         if q4 = 'y' then
            goto 10;
      end;
   if degree = 2 then
      writeln;
      quadroot(coef);
end.

