program parfract(input,output);
(* Program evaluates a rational function N(s)/D(s) for complex s. *)

type vector = array[0..10] of real;
var coefn,coefd:vector;
    num1,num2,denom1,denom2,z1,z2,magr,magj,magnitude,angle: real;
    mn,md: integer;  (*  degree of numerator and denominator  *)
    q: char;

procedure readin(var a1: vector; n1: integer);
(* Reads in polynomial coefficients from the keyboard. *)

var i: integer;

begin
   for i := 0 to n1 do
      begin
         write('Input the ',i,' coefficent: ');
         readln(a1[i]);
      end;
   writeln('The polynomial coefficients are:');
   writeln;
   for i := 0 to n1 do
      begin
         write(a1[i]:6:3,'  ');
      end;
   writeln;
end;

procedure evalpoly(coef: vector; w1,w2: real; var b1,b2: real; n1: integer);
(* Evaluates a polynomial N(s) in the form *)
(*  A(0) + A(1)s + A(2)s^2 + ...+ A(n1)s^n1 for  s = w1 + jw2. *)

var a1,a2: vector;
    i: integer;

begin
   a1[0] := 1.0;
   a2[0] := 0.0;
   b1 := a1[0]*coef[0];
   b2 := a2[0]*coef[0];
   for i := 1 to n1 do
      begin
         a1[i] := w1*a1[i-1] - w2*a2[i-1];  (* real part of w^i *)
         a2[i] := w1*a2[i-1] + w2*a1[i-1];  (* imag part of w^i *)
         b1 := b1 + a1[i]*coef[i];   (* real part of trunc polynomial *)
         b2 := b2 + a2[i]*coef[i];   (* imag part of trunc polynomial *)
      end;
end;

procedure evaltf(a1,a2,b1,b2: real; var d1,d2: real);
(* Evaluates a complex quotient d1 + jd2 = (a1 + ja2)/(b1 + jb2). *)

var d: real;

begin
   d := b1*b1 + b2*b2;
   d1 := (a1*b1 + a2*b2)/d;
   d2 := (a2*b1 - a1*b2)/d;
end;

procedure correct(var d1,d2,w2: real);
(* Corrects partial-fraction calculation for a complex pair of poles. *)

var d11: real;

begin
   d11 := d2/(2*w2);
   d2 := -d1/(2*w2);
   d1 := d11;
end;

procedure rectpol(a1,a2: real; var cmag1,angle1: real);
(* Converts rectangular form a1 + ja2 to polar form. *)
var eta: real;

begin
   cmag1 := sqrt(a1*a1 + a2*a2);
   if (a1 = 0.0) and (a2 = 0.0) then
      angle1 := 0.0;
   if (a1 = 0.0) and (a2 > 0.0) then
      angle1 := 90.0;
   if (a1 = 0.0) and (a2 < 0.0) then
      angle1 := -90.0;
   if abs(a1) > 0.0 then
      eta := arctan(a2/a1)*57.296;
   if a1 > 0 then
      angle := eta;
   if (a1 < 0.0) and (a2 >= 0.0) then
      angle1 := eta + 180.0;
   if (a1 < 0.0) and (a2 < 0.0) then
      angle1 := eta - 180.0;
end;

begin   (*  main  *)
   write('Input degree of numerator polynomial: ');
   readln(mn);
   writeln;
   write('Input degree of denominator polynomial: ');
   readln(md);
   writeln;
   writeln('Input numerator coefficients as prompted:');
   writeln;
   readin(coefn,mn);
   writeln('Input denominator coefficients as prompted:');
   readin(coefd,md);
   write('Input complex value of z (z1 z2): ');
   readln(z1,z2);
   evalpoly(coefn,z1,z2,num1,num2,mn);
   evalpoly(coefd,z1,z2,denom1,denom2,md);
   evaltf(num1,num2,denom1,denom2,magr,magj);
   writeln('Is this a P-F expansion for a complex root? (y,n):');
   writeln;
   readln(q);
   if q = 'y'
      then correct(magr,magj,z2);
   rectpol(magr,magj,magnitude,angle);
   writeln('The real and imaginary parts are: ');
   writeln(magr:9,', ',magj:9);
   writeln;
   writeln('The magnitude and angle are: ');
   writeln(magnitude:9,', ',angle:5:2,' degrees');
end.



