program numint(input,output);
(* Program evaluates the definite integral of a function with upper  and *)
(*  lower limits, t2 and t1, by the method of trapezoidal integration. *)

var e,f,t1,t2: real;
    n: integer;

function fcn(y: real): real;
  begin
    fcn := y*y+y+1.0     (* Define function to be integrated *)
  end;


procedure integral(var f2: real;e0,z1,z2: real; var n1:integer);
(* Calculates definite integral of fcn using trapezoidal integration *)
(* for upper and lower limits z1 and z2 *)

  var k1,i: integer;
      f1,f3,y1,y2,e1,h: real;

  begin
    h := (z2-z1)/n1;
    f3 := f2;
    f2 := 0.0;
    k1 := 1;
    for i := 0 to n1 do
      begin
        f1 := 0.0;
        y1 := z1+h*(i-1);
        y2 := z1+h*i;
        f1 := h*(fcn(y1)+fcn(y2))/2;
        f2 := f2+f1;
        e1 := (f2-f3)/f2;
      end;
   writeln(k1:5,f2:15:5,'  ',e1:10:5);
   if abs(e1) > e0 then
      begin
         n1 := 2*n1;
         k1 := k1+1;
         integral(f,e,z1,z2,n1);
      end
   else writeln('Done');
end;


begin (** main **)
  write('Initial and final times:');
  readln(t1,t2);
  writeln;
  write('Input number of increments:');
  readln(n);
  writeln;
  write('Input error criterion: ');
  readln(e);
  writeln;
  writeln('Run':5,'integral':15,'Error': 15);
  writeln;
  f := 0.0;
  integral(f,e,t1,t2,n);
end.
