program cmatinv(input, output);
(* Program calculates the inverse of complex matrix A by gauss elimination, *)
(* and solves the matrix equation Ax = f, if desired *)

type mat = array[1..10,1..10] of real;
     mat1 = array[1..10,1..20] of real;
var a,b,c,f: mat;
    n: integer;
    q: char;

procedure cmatread(var a1: mat; m1,n1: integer);
(* Reads in coefficients of n-order matrix A1 from the keyboard and *)
(* forms the 2n-order equivalent real matrix. *)

var aa,ab: real;
    i,j: integer;

begin
   writeln('Enter matrix as directed by prompt.');
   writeln;
   for i := 1 to m1 do
      begin
         for j := 1 to n1 do
            begin
               writeln;
               writeln('Enter complex ',i,'-',j, ' element: ');
               readln(aa,ab);
               a1[2*i-1,2*j-1] := aa;
               a1[2*i-1,2*j] := ab;
               a1[2*i,2*j-1] := -ab;
               a1[2*i,2*j] := aa;
            end;
         writeln;
      end;
end;

procedure cmatwrite(a1: mat; m1,n1: integer);
(* Prints out the complex matrix A1 from the equivalent real matrix. *)

var i,j: integer;

begin
   writeln;
   for i := 1 to m1 do
      begin
         for j := 1 to n1 do
            begin
               write('(',a1[2*i-1,2*j-1]:9,', ',a1[2*i-1,2*j]:9,')','  ');
            end;
         writeln;
      end;
   writeln;
end;


procedure matinv(a1: mat; var b2: mat; n1: integer);
(* Calculates the inverse of matrix A1 and designates it as B2. *)

label 10,20,30;
var d: real;
    b1: mat1;
    i,j,k,m: integer;

begin  (* Set up a matrix [A U] for Gauss elimination procedure *)
   for i := 1 to n1 do
      begin
         for j := 1 to n1 do
            begin
               b1[i,n1+j] := 0;
               b1[i,j] := a1[i,j];
            end;
         b1[i,n1+i] := 1;
      end;
   for k := 1 to n1 do  (* Find the largest element in the k column *)
      begin
         if k = n1 then goto 10;
         m := k;
         for i := k+1 to n1 do
            begin
               if abs(b1[i,k]) > abs(b1[m,k]) then
               m := i;
            end;
         if m = k then goto 10;
         for j := k to 2*n1 do
            begin  (* Exchange k and m rows. *)
               d := b1[k,j];
               b1[k,j] := b1[m,j];
               b1[m,j] := d;
            end;
      10:for j := k+1 to 2*n1 do
            begin  (* Divide row k by the k-k element. *)
               b1[k,j] := b1[k,j]/b1[k,k];
            end;
         if k = 1 then goto 20;
         for i := 1 to k-1 do  (* Clear out above main diagonal *)
            begin
               for j := k+1 to 2*n1 do
                  begin
                     b1[i,j] := b1[i,j] - b1[i,k]*b1[k,j];
                  end;
            end;
         if k = n1 then goto 30;
      20:for i := k+1 to n1 do
            begin
               for j := k+1 to 2*n1 do  (* Clear out below main diagonal *)
                  begin
                     b1[i,j] := b1[i,j] - b1[i,k]*b1[k,j];
                  end;
            end;
         end;
30:for i := 1 to n1 do    (* Copy A-inverse to the left side of B. *)
      begin
         for j := 1 to n1 do
            begin
               b2[i,j] := b1[i,n1+j];
            end;
      end;
end;

procedure matmult(a1,b1: mat; var c1: mat; m1,n1,n2: integer);
(* Calculates the matrix product [C1] = [A1][B1]. *)

var i,j,k: integer;

begin
   for i := 1 to m1 do
      begin
         for j := 1 to n2 do
            begin
               c1[i,j] := 0.0;
               for k := 1 to n1 do
                  begin
                     c1[i,j] := c1[i,j] + a1[i,k]*b1[k,j];
                  end;
            end;
      end;
end;



procedure cmatpol(a1: mat; m1: integer);
(* Calculates the polar form of a complex vector in rectangular form, *)
(* and prints out the results. *)

var c11,c2,cmag1,angle1,eta: real;
    j,i: integer;

begin
   for i := 1 to m1 do
   begin
      j := 2*i-1;
      c11 := a1[j,1];
      c2 := a1[j,2];
      cmag1 := sqrt(c11*c11 + c2*c2);
      if (c11 = 0.0) and (c2 = 0.0) then
         angle1 := 0.0;
      if (c11 = 0.0) and (c2 > 0.0) then
         angle1 := 90.0;
      if (c11 = 0.0) and (c2 < 0.0) then
         angle1 := -90.0;
      if (abs(c11) > 0.0) then
         eta := arctan(c2/c11)*57.296;
      if (c11 > 0) then
         angle1 := eta;
      if (c11 < 0.0) and (c2 >= 0.0) then
         angle1 := eta + 180.0;
      if (c11 < 0.0) and (c2 < 0.0) then
         angle1 := eta - 180.0;
      writeln(cmag1:9,'  ',angle1:5:1);
   end;
end;


begin  (* main *)
   writeln('This program finds the inverse of a complex matrix.');
   writeln;
   write('Input the order of the square complex matrix A: ');
   readln(n);
   writeln;
   writeln('The elements of A will next be input: ');
   cmatread(a,n,n);
   writeln('The matrix A is: ');
   writeln;
   cmatwrite(a,n,n);
   writeln;
   matinv(a,b,2*n);
   writeln('The inverse of A is: ');
   writeln;
   cmatwrite(b,n,n);
   matmult(a,b,c,2*n,2*n,2*n);
   writeln;
   writeln('The product of A and A-inverse is:');
   writeln;
   cmatwrite(c,n,n);
   writeln;
   writeln('Solve Ax = f ?  (y,n)');
   readln(q);
   if q = 'y' then
      begin
         writeln('Input the vector f as directed by prompt:');
         writeln;
         cmatread(f,n,1);
         matmult(b,f,c,2*n,2*n,2);
         writeln;
         writeln('The complex vector solution is:');
         writeln;
         writeln('In rectangular form:');
         writeln;
         cmatwrite(c,n,1);
         writeln;
         writeln('In polar form (magnitude, and angle in degrees):');
         writeln;
         cmatpol(c,n);
      end;
end.
