program trapz1(input,output);
(* Program solves first-order differential equation  x' = ax + f *)
(* by trapezoidal integration. *)

var a,x0,t0,h,tr: real;
    np: integer;

function fcn(z: real): real;  (* Define forcing function *)
   begin
      fcn := 10;
   end;

procedure change(var h1: real; var np1: integer); forward;
(* Halves the integration increment, and calls integration procedure. *)

var b: char;
    a1,t1,tr1,x1: real;

procedure integ(x1,a1,h1,t1,tr1: real; np1: integer);
(* Uses trapezoidal integration with increment h1 to solve x' = ax + f. *)
(* Initial value is x1 at t1, run time is tr1, and np1 is the number of *)
(* points between print. *)

var i: integer;
x,k1,k2,x2,t: real;
begin
   t := t1;
   x2 := x1;
   writeln(t0:5,'':5,x0:10);
   while t <= t1 + tr1 + h1*np1 do
      begin
         k1 := 1 + a1*h1/2;
         k2 := 1 - a1*h1/2;
         for i := 1 to np1 do
            begin
               x := (k1*x2 +(fcn(t) + fcn(t+h1))*h1/2)/k2;
               t := t + h1;
               x2 := x;
            end;
         writeln(t:5,'':5,x:10);
      end;
   change(h1,np1);
end;

procedure change;  (* Comment above *)

begin
   writeln('Try a smaller increment (y,n)?');
   readln(b);
   writeln;
   if b = 'y' then
      begin
         h1 := h1/2;
         np1 := 2*np1;
         integ(x0,a,h1,t1,tr,np1);
      end;
end;

begin (* main *)
   writeln('Forcing function must be in function subroutine.');
   writeln;
   write('Input the coefficient a (with sign): ');
   readln(a);
   writeln;
   write('Input the initial value of x: ');
   readln(x0);
   writeln;
   write('Input initial time: ');
   readln(t0);
   write('Input run time: ');
   readln(tr);
   writeln;
   write('Input time increment: ');
   readln(h);
   writeln;
   write('Input number of increments between print: ');
   readln(np);
   writeln;
   writeln('Time   ':10,'Solution  ':10);
   writeln;

   integ(x0,a,h,t0,tr,np);
end.
