program rmatinv(input, output);
(* Program calculates the inverse of real matrix A by gaussian *)
(* elimination and solves the matrix equation Ax = f if desired *)

type mat = array[1..10,1..10] of real;
     mat1 = array[1..10,1..20] of real;
var a,b,c,d,f: mat;
    q: char;
    n: integer;

procedure matread(var a1: mat; m1,n1: integer);
(* Reads in the coefficients of matrix A1 *)

var i,j: integer;
begin
   for i := 1 to m1 do
      begin
         for j := 1 to n1 do
            begin
               write('Input the ',j,' element of row ',i,':  ');
               readln(a1[i,j]);
            end;
         writeln;
      end;
end;

procedure matwrite(a1: mat; m1,n1: integer);
(* Prints out matrix A1 *)

var i,j: integer;
begin
   writeln;
   for i := 1 to m1 do
      begin
         for j := 1 to n1 do
            begin
               write(a1[i,j]:10,' ':2);
            end;
         writeln;
      end;
end;


procedure matinv(a1: mat; var b2: mat; n1: integer);
(* Calculates the inverse of matrix A1 and designates it as matrix C *)

label 10,20,30;
var d: real;
    b1: mat1;
    i,j,k,m: integer;

begin  (* Set up a matrix [A U] for Gauss elimination procedure *)
   for i := 1 to n1 do
      begin
         for j := 1 to n1 do
            begin
               b1[i,n1+j] := 0;
               b1[i,j] := a1[i,j];
            end;
         b1[i,n1+i] := 1;
      end;
   for k := 1 to n1 do  (* Find the largest element in the k column *)
      begin
         if k = n1 then goto 10;
         m := k;
         for i := k+1 to n1 do
            begin
               if abs(b1[i,k]) > abs(b1[m,k]) then
               m := i;
            end;
         if m = k then goto 10;
         for j := k to 2*n1 do
            begin  (* Exchange k and m rows. *)
               d := b1[k,j];
               b1[k,j] := b1[m,j];
               b1[m,j] := d;
            end;
      10:for j := k+1 to 2*n1 do
            begin  (* Divide row k by the k-k element. *)
               b1[k,j] := b1[k,j]/b1[k,k];
            end;
         if k = 1 then goto 20;
         for i := 1 to k-1 do  (* Clear out above main diagonal *)
            begin
               for j := k+1 to 2*n1 do
                  begin
                     b1[i,j] := b1[i,j] - b1[i,k]*b1[k,j];
                  end;
            end;
         if k = n1 then goto 30;
      20:for i := k+1 to n1 do
            begin
               for j := k+1 to 2*n1 do  (* Clear out below main diagonal *)
                  begin
                     b1[i,j] := b1[i,j] - b1[i,k]*b1[k,j];
                  end;
            end;
         end;
30:for i := 1 to n1 do    (* Copy A-inverse to the left side of B. *)
      begin
         for j := 1 to n1 do
            begin
               b2[i,j] := b1[i,n1+j];
            end;
      end;
end;

procedure matmult(a1,b1: mat; var c1: mat; m1,n1,n2: integer);
(* Calculates the matrix product [A1][B1] = C1 *)

var i,j,k: integer;

begin
   for i := 1 to m1 do
      begin
         for j := 1 to n2 do
            begin
               c1[i,j] := 0.0;
               for k := 1 to n1 do
                  begin
                     c1[i,j] := c1[i,j] + a1[i,k]*b1[k,j];
                  end;
            end;
      end;
end;


begin  (* main *)
   writeln('This program calculates the inverse of a matrix.');
   writeln;
   write('Input the order of the square matrix A: ');
   readln(n);
   writeln;
   writeln('Input the elements of A as prompted: ');
   matread(a,n,n);
   writeln('The matrix A is: ');
   writeln;
   matwrite(a,n,n);
   writeln;
   matinv(a,b,n);
   writeln('The inverse of A is: ');
   writeln;
   matwrite(b,n,n);
   matmult(a,b,c,n,n,n);
   writeln;
   writeln('The product of A and A-inverse is:');
   writeln;
   matwrite(c,n,n);
   writeln;
   writeln('Solve Ax = f? (y,n) ');
   readln(q);
   if q = 'y' then
      begin
         writeln('Input the elements of vector f as directed by prompt:');
         writeln;
         matread(f,n,1);
         writeln;
         writeln('The solution vector is:');
         writeln;
         matmult(b,f,d,n,n,1);
         matwrite(d,n,1);
      end;
end.
