program newton(input,output);
(* Program searches for the intersection of two nonlinear functions *)
(* of y1 and y2 by the Newton-Raphson procedure. *)

var m,y1,y2,e: real;
    l,max: integer;


procedure check(x1,x2,d1,d2,e: real; var l: integer; max1: integer); forward;
(* Checks maximum mismatch and continues iteration if maximum *)
(* allowable mismatch is exceeded. *)

var m1,m2,f1,f2,j11,j12,j21,j22: real;

procedure estimate(var x1,x2: real; max1: integer);
(* Uses Newton-Raphson technique to estimate new solution for x1 and x2 *)
(* from previous estimate. *)

var f1,f2,j11,j12,j21,j22,d,d1,d2: real;
   begin
      f1 := x1 + 2.0*x1*x1*x1 + x2 - 2.0;            (* Function # 1 *)
      f2 := x1 + x2 + 4.0*(1.0-exp(-3.0*x2)) - 4.0;  (* Function # 2 *)
      j11 := 1.0 + 6.0*x1*x1;                        (* Jacobian elements *)
      j12 := 1.0;
      j21 := 1.0;
      j22 := 1.0 + 12.0*exp(-3.0*x2);
      d := j11*j22 - j12*j21;
      d1 := (-j22*f1 + j12*f2)/d;
      d2 := (j21*f1 - j11*f2)/d;
      x1 := x1 + d1;            (* New estimate for x1 *)
      x2 := x2 + d2;            (* New estimate for x2 *)
      check(x1,x2,d1,d2,e,l,max1);
   end;

procedure check;  (* Comment above *)

   begin
      l := l + 1;
      m := 0.0;
      m1 := d1/x1;          (* Mismatch for x1 *)
      m2 := d2/x2;          (* Mismatch for x2 *)
      if abs(m1) > abs(m2) then
         m := m1
      else m := m2;         (* Find maximum mismatch *)
      writeln(l:5,'':5,m:10,'':5,x1:10,'  ',x2:10);
      if (abs(m) > e) and (l < max1) then
         begin
            estimate(x1,x2,max1);
         end;
   end;

begin  (* main *)
   writeln('Functions and Jacobians should be in procedure "estimate".');
   writeln;
   write('Input initial estimates for x1 and x2 (with space between): ');
   readln(y1,y2);
   writeln;
   write('Input maximum allowable mismatch: ');
   readln(e);
   writeln;
   write('Input maximum number of iterations: ');
   readln(max);
   writeln;
   writeln('Iter. #   ':10,'Max Mismatch    ':15,'x1  ':12,'x2':10);
   writeln;
   l := 0;
   m := 999.999;
   writeln(l:5,'':5,m:10,'':5,y1:10,'  ',y2:10); (* print initial values *)
   estimate(y1,y2,max);
end.



