{$R-,S-,I-,D-,T-,F-,V+,B-,N-,L+ }
Program MTest;

{ Message-Passing Test
  Christian Philipps
  6/88
}

USES Dos, Crt, Tp4Multi;

VAR MessageBuffer : String;
    SubNo         : TaskNoType;
    BeepNo        : TaskNoType;

{-----------------------------------------------------------------------------}

PROCEDURE TaskMsgOut(txt : string);

{ Safe output of a string to the screen }

BEGIN {TaskMsgOut}
  BindCPU;
  Writeln(txt);
  ReleaseCPU;
END;  {TaskMsgOut}

{-----------------------------------------------------------------------------}

PROCEDURE Beep;

{ First Sub-Task }

BEGIN {Beep}
  REPEAT
    Sound(200);
    Delay(5);
    NoSound;
  UNTIL Keypressed;

  TaskMsgOut('Beep: Sending to SubTask...');
  IF Send(SubNo,@MessageBuffer,Length(MessageBuffer)+1,Wait) <> Task_OK
     THEN Writeln('Beep: Receive-Status not O.K.')
     ELSE Writeln('Beep: Message received correctly!');

  TaskMsgOut('Beep: End of the performance...');
  Terminate;
END;  {Beep}

{-----------------------------------------------------------------------------}

PROCEDURE SubTask;

{ Second Sub-Task }

VAR Message : String;

BEGIN {SubTask}
  TaskMsgOut('SubTask: Ready! - Sleeping for 5 seconds!');
  Sleep(Seconds(5));

  TaskMsgOut('SubTask: Receive with wait...');
  IF Receive(BeepNo,@Message,Wait) <> Task_OK
     THEN TaskMsgOut('SubTask: Error during Receive!!')
     ELSE TaskMsgOut('SubTask: Received: '+Message);

  TaskMsgOut('SubTask: Get the message from MasterTask, if available');
  IF Receive(AnyTask,@Message,NoWait) <> Task_OK
     THEN TaskMsgOut('SubTask: Error during Receive!!')
     ELSE TaskMsgOut('SubTask: Received: '+Message);

  Writeln('SubTask: Message received from Task No. ',ReceivedFrom);
  TaskMsgOut('SubTask: Terminating...');
  Terminate;
END;  {SubTask}

{-----------------------------------------------------------------------------}

BEGIN {Main}
  ClrScr;
  MessageBuffer := 'Message in a bottle...';

  Writeln('MasterTask: Starting the BeepTask!');
  BeepNo := CreateTask(@Beep,Pri_User,500);
  IF BeepNo < 0
     THEN Writeln('MasterTask: Error during creation of the BeepTask!');

  Writeln('MasterTask: Starting the SubTask!');
  SubNo := CreateTask(@SubTask,Pri_User,1000);
  IF SubNo < 0
     THEN BEGIN
            Writeln('MasterTask: Task-Create failed!!');
            Halt;
          END;

  Sleep(Seconds(1));   { Let it speak to us... }

  Writeln('MasterTask: Waiting for the message to be received...');
  IF Send(SubNo,@MessageBuffer,Length(MessageBuffer)+1,Wait) <> Task_OK
     THEN Writeln('MasterTask: Receive-status not O.K.')
     ELSE Writeln('MasterTask: Message received correctly!');

  Writeln('MasterTask: Sleeping for 2 seconds...');
  Sleep(Seconds(2));

  Writeln('MasterTask: <RETURN> ends!');
  Readln;
  NoSound;
END. {Main}