{ Unit written by Kelly Drown for interfacing the Fossil Driver. This is a   }
{ a beta test unit and as such, is not fully tested, nor is it garunteed to  }
{ to work. You are free to use this code as you wish and modify as you see   }
{ fit. I would, however, like you to mention my name in your documentation   }
{ if you use this code. I ask this courtesy in place of asking for funds, as }
{ this code is covered under my standard copyright. Thanks.                  }

{  Beta test version 0.03 }

UNIT KDFOSSIL;

INTERFACE

Uses Dos;

Var
   Regs       : Registers;
   Port       : Integer;
   Result     : Boolean;
   Esc        : Char;
   Num,
   NumB       : String;

{---------------------------- User Routines ------------------------------}

Function CheckCarrier( Port : Integer ) : Boolean;
Procedure Modem_Send( ch : Char; Port : Integer );
Procedure Modem_Send_String( Str : String; Port : Integer );
Procedure DeInitFossil( Port : Integer );
Procedure InitFossil( Port, Baud : Integer );
Procedure Modem_Input( VAR Inchar : Byte; Port : Integer );
Procedure CursorForward( Row, Port : Integer );
Procedure CursorBackward( Row, Port : Integer );
Procedure CursorUp( Row, Port : Integer );
Procedure CursorDown( Row, Port : Integer );
Procedure CursorPos( Row, RowB, Port : Integer );
Procedure ClearScreen( Port : Integer );
Procedure ClearEOL( Port : Integer );
Procedure Modem_Send_Blink( Str : String; Port : Integer );
Procedure CursorColor( Row, RowB, Port : Integer );
Procedure WarmBoot;
Procedure ColdBoot;
Procedure ControlDTR( Port, State : Integer );
Procedure FlushOutput( Port : Integer );
Procedure PurgeOutput( Port : Integer );
Procedure PurgeInput( Port : Integer );
Function Local( VAR Scan : Byte ) : Boolean;


IMPLEMENTATION

{-------------------------------------------------------------------------}
Function CheckCarrier( Port : Integer ) : Boolean;

Var TestBit : Byte;

Begin
     TestBit := 7;             { Carrier Detect Bit }
       With Regs do
       Begin
         Ah := $03;            { Address for DCD Checking         }
         Dx := Port -1;           { Tell Fossil what Port to check   }
       End;
         Intr($14,Regs);       { Pass registers through Int 14h   }
     Result := ( Regs.Al AND ( 1 SHL TestBit ) ) = 0; { Check Bit 7 True }
        IF Result = True THEN Begin
          WriteLn( #7, 'CARRIER NOT PRESENT OR LOST!' );
          With Regs Do
            Begin
              ah := $05;
              dx := Port -1;      { De-Initialize port from app.     }
            End;
          Intr($14,Regs);
          CheckCarrier := False; { NO CARRIER! }
          Exit;
          End;
     CheckCarrier := True;
 End;
{-------------------------------------------------------------------------}
Procedure ControlDTR( Port, State : Integer );
Begin
  With Regs DO
   Begin
    ah := $06;
    dx := Port -1;
    Case State OF
      0 : al := $00;
      1 : al := $01;
    End;
   End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Procedure FlushOutput( Port : Integer );
Begin
  With Regs DO
    Begin
    ah := $08;
    dx := Port -1;
    End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Procedure PurgeOutput( Port : Integer );
Begin
  With Regs DO
    Begin
    ah := $09;
    dx := Port -1;
    End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Procedure PurgeInput( Port : Integer );
Begin
  With Regs DO
    Begin
    ah := $0a;
    dx := Port -1;
    End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Function Local( VAR Scan : Byte ) : Boolean;
Begin
  Regs.ah := $0d;
  Intr($14,Regs);
 IF Regs.ax = $FFFF THEN Local := False
 ELSE Begin
        Scan := Regs.ax;
        Local := True;
      End;
End;
{-------------------------------------------------------------------------}
Procedure WarmBoot;
Begin
  With Regs DO
    Begin
    ah := $17;
    al := $01;
    End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Procedure ColdBoot;
Begin
  With Regs DO
    Begin
    ah := $17;
    al := $00;
    End;
  Intr($14,Regs);
End;
{-------------------------------------------------------------------------}
Procedure Modem_Send(ch : char; Port : Integer);

Begin
  Write(ch);
     With regs do
       Begin
          Ah := $01;
          Dx := Port -1;
          Al := Ord(ch);
       End;
      Intr($14,regs);
End;
{-------------------------------------------------------------------------}
Procedure Modem_Send_String( Str : String; Port : Integer );
Var i : Integer;
Begin
     For i := 1 to Length(Str) Do
     Modem_Send(Str[i], Port);
End;
{-------------------------------------------------------------------------}
Procedure DeInitFossil( Port : Integer );

Begin
  With Regs Do
    Begin
      ah := $08;
      dx := Port -1;
    End;
    Intr($14,regs);  {Flush any pending output on out the door}

  With Regs do
    Begin
      Ah := $05;
      Dx := Port -1;
    End;
      Intr($14,Regs);    { De-Initialize Fossil Driver }
   halt;
End;
{-------------------------------------------------------------------------}
Procedure InitFossil( Port, Baud : Integer );

Begin
       With Regs do
          Begin
           ah := $04;
           dx := Port -1;
          End;
           Intr($14,Regs);

         With Regs do
          Begin
           ah := $00;
           dx := Port -1;
         CASE Baud of
               300 : al := 67;
              1200 : al := 131;
              2400 : al := 163;
              4800 : al := 195;
              9600 : al := 227;
         End;  { Case }
       End;  { Registers }
     Intr($14,Regs);
  End;
{-----------------------------------------------------------------------}

Procedure Modem_Input( VAR Inchar : Byte;
                           port   : Integer );

Begin
    With Regs DO
    Begin
      ah := $0a;  {purge input buffer}
      dx := Port -1;
    END;
    Intr($14,Regs);
 Repeat
    With Regs Do
       Begin
          ah := $0c;
          dx := Port -1;
       End;
    Intr($14,Regs);
Until Regs.AX <> $FFFF;
    Inchar := Regs.al;
End;
{-------------------------------------------------------------------------}
Procedure CursorForward( Row : Integer; Port : Integer );
Begin
     Esc := Chr(27);
     Str( Row, Num );
     Modem_Send_String( Esc+ '['+ Num+ 'c', Port );
     Write( Esc + '[' + Num + 'c' );
End;
{-------------------------------------------------------------------------}
Procedure CursorBackward( Row : Integer; Port : Integer );
Begin
     Esc := Chr(27);
     Str( Row, Num );
     Modem_Send_String( Esc+ '[' + Num+ 'd', Port );
     Write( Esc + '[' + Num + 'd' );
End;
{-------------------------------------------------------------------------}
Procedure CursorUp( Row : Integer; Port : Integer );
Begin
     Esc := Chr(27);
     Str( Row, Num );
     Modem_Send_String( Esc+ '[' + Num+ 'a', Port );
     Write( Esc + '[' + Num + 'a' );
End;
{-------------------------------------------------------------------------}
Procedure CursorDown( Row : Integer; Port : Integer );
Begin
     Esc := Chr(27);
     Str( Row, Num );
     Modem_Send_String( Esc+ '[' + Num+ 'b', Port );
     Write( Esc + '[' + Num + 'b' );
End;
{-------------------------------------------------------------------------}
Procedure CursorPos( Row, RowB, Port : Integer );
Begin
     Esc := Chr(27);
     Str( Row, Num );
     Str( RowB, NumB );
     Modem_Send_String( Esc+ '['+ Num+ ';'+ NumB+ 'h', Port );
     Write( Esc+ '['+ Num+ ';'+ NumB+ 'h' );
End;
{-------------------------------------------------------------------------}
Procedure ClearScreen( Port : Integer );
Begin
     Esc := Chr(27);
     Modem_Send_String( Esc+ '[2j', Port );
     Write( Esc+ '[2j' );
End;
{-------------------------------------------------------------------------}
Procedure ClearEOL( Port : Integer );
Begin
     Esc := Chr(27);
     Modem_Send_String( Esc+ '[k', Port );
     Write( Esc+ '[k' );
End;
{-------------------------------------------------------------------------}
Procedure Modem_Send_Blink( Str : String; Port : Integer );
Begin
     Esc := Chr(27);
     Modem_Send_String( Esc+ '[5m'+ Str+ '[m', Port );
     Write( Esc+ '[5m', Str, '[m' );
End;
{-------------------------------------------------------------------------}
Procedure CursorColor( Row, RowB, Port : Integer );

   { Row and RowB are Foreground and Background respectively }

Begin
     Esc := Chr(27);
     Str( Row, Num );
     Str( RowB, NumB );
     Modem_Send_String( Esc+ '['+ Num+ ';'+ NumB+ 'm', Port );
     Write( Esc+ '['+ Num+ ';'+ NumB+ 'm' );
End;
{-------------------------------------------------------------------------}


end. { The End }
