program JoyStick;

var
   I    : integer;
   Temp : byte;


function Button_Pressed(Which_One : char):boolean;
{ Returns 'true' if specified button is pressed }
const
   JoyPort = $201;
var
   Mask : byte;
begin
   if not(Which_One in ['A'..'D']) then Which_One := 'A';
   case Which_One of
      'A' : Mask := 16;
      'B' : Mask := 32;
      'C' : Mask := 64;
      'D' : Mask := 128;
   end;
   Button_Pressed := (port[JoyPort] and Mask) = 0;
end;


function JoyStick_Pos(Which_One : Char):integer;
const
   MaxCount = 400;
   JoyPort  = $201;
var
   Counter : integer;
   Mask    : byte;
begin
   if not(Which_One in ['A'..'D']) then Which_One := 'A';
   case Which_One of
      'A' : Mask := 1;
      'B' : Mask := 2;
      'C' : Mask := 4;
      'D' : Mask := 8;
   end;

{ This assembly code causes the CX register to count down from MaxCount toward
  zero.  When CX reaches zero or when the one-shot on the game adapter times
  out the looping stops and Counter is assigned the number of counts that were
  accumulated.  MaxCount should be chosen so that CX never reaches 0 so that
  the usable range of the joystick will not be limited. }

   inline(
      $B9/MaxCount/     {       MOV  CX,MaxCount   Initialize down counter   }
      $BA/JoyPort/      {       MOV  DX,JoyPort    Port address of joysticks }
      $8A/$A6/Mask/     {       MOV  AH,Mask[BP]   Mask for desired one-shot }
      $EE/              {       OUT  DX,AL         Start the one-shots       }
      $EC/              { READ: IN   AL,DX         Read the one-shots        }
      $84/$C4/          {       TEST AL,AH         Check desired one-shot    }
      $E0/$FB/          {       LOOPNZ READ        Repeat until timed out    }
      $89/$8E/Counter); {       MOV  Counter[BP],CX  This makes CX available }
                        {                            to Turbo Pascal         }
   if Counter = 0 then
      JoyStick_Pos := 0                { Exceeded useful range or not in use }
   else
      JoyStick_Pos := MaxCount - Counter;
end;


begin  { Mainline }
   clrscr;
   gotoxy(1,2);
   writeln('Joysticks':12,'Buttons':12);
   write('A':6,'B':6,'A':6,'B':6);
   repeat
      gotoxy(1,5);
      write(JoyStick_Pos('A'):6,JoyStick_Pos('B'):6);
      if Button_Pressed('A') then
         write('PRES':6)
      else
         write('UP':6);
      if Button_Pressed('B') then
         write('PRES':6)
      else
         write('UP':6);
   until keypressed;
end.
