Unit IO;


{ Copyright (C) 1988 by P.Mackay. All Rights Reserved

   Name     :  IO

   Compiler :  Unit for Borland's Turbo-Pascal v4/5 ...

   Function :  Provides capability to easily use and switch between the 3
                 output methods available: ANSI/BIOS/DIRECT-WRITES.

   Guarantee:  If it breaks, you get to keep both pieces.

   Author   :  Phil Mackay,
               21 Andrew Place, North Rocks
               2151 N.S.W  Australia.                                      }

interface

Type
  OutType        = (ANSI,BIOS,DIRECT);

Const
  CLS            = #27 + '[2J';
  Left           = #27 + '[1D';
  Right          = #27 + '[1C';
  Up             = #27 + '[1A';
  Down           = #27 + '[1B';
  Black          = #27 + '[30m';
  Blue           = #27 + '[34m';
  Green          = #27 + '[32m';
  Cyan           = #27 + '[36m';
  Orange         = #27 + '[31m';
  Purple         = #27 + '[35m';
  Red            = #27 + '[33m';
  White          = #27 + '[37m';
  BlackB         = #27 + '[40m';
  BlueB          = #27 + '[44m';
  GreenB         = #27 + '[42m';
  CyanB          = #27 + '[46m';
  OrangeB        = #27 + '[41m';
  PinkB          = #27 + '[45m';
  RedB           = #27 + '[43m';
  WhiteB         = #27 + '[47m';
  Bold           = #27 + '[1m';
  Flash          = #27 + '[5m';
  Off            = #27 + '[0m';

var
  IOmethod         : OutType;
  backcolor        : integer;
procedure IOGotoXY(x,y : integer);
procedure IOTextColor(color : integer);
procedure IOTextBackground(color : integer);
procedure IOClrEol;
procedure IOClrScr;
procedure OutputMethod (Method : OutType);

implementation

Uses CRT;

procedure IOGotoXY(x,y : integer);
var
  Sx,Sy : string;
begin
  if IOmethod = ANSI then
    begin
      Str(x,Sx);
      str(y,Sy);
      write(#27 + '[' + Sy + ';' + Sx + 'H');
    end
  else GotoXY(x,y);
end;


procedure IOTextColor(color : integer);

var
  flashing : boolean;

begin
  if IOmethod = ANSI then
    begin
      flashing := false;

      if color > 15 then
        begin
          color := color - 16;
          flashing := true;
        end
      else
        write (off);

      if color > 7 then
        begin
          color := color - 8;
          write (Bold);
        end
      else
        write (off);

      if flashing then write (flash);

      case color of
        0 : write (#27 + '[30m');
        1 : write (#27 + '[34m');
        2 : write (#27 + '[32m');
        3 : write (#27 + '[36m');
        4 : write (#27 + '[31m');
        5 : write (#27 + '[35m');
        6 : write (#27 + '[33m');
        7 : write (#27 + '[37m');
      end;
      IOTextBackground(Backcolor);
    end
  else TextColor(color);
end;


procedure IOTextBackground(color : integer);
begin
  if IOmethod = ANSI then
    begin
      Case color of
        0 : write (#27 + '[40m');
        1 : write (#27 + '[44m');
        2 : write (#27 + '[42m');
        3 : write (#27 + '[46m');
        4 : write (#27 + '[41m');
        5 : write (#27 + '[45m');
        6 : write (#27 + '[43m');
        7 : write (#27 + '[47m');
        end;
      BackColor := color;
    end
  else TextBackground(color);
end;


procedure IOClrEol;
begin
  if IOmethod = ANSI then write (#27 + '[K')
    else ClrEol;
end;


procedure IOClrScr;
begin
  if IOmethod = ANSI then write (Cls)
    else clrscr;
end;


procedure OutputMethod (Method: OutType);

begin
  Case Method of
    ANSI   : begin
               assign (input,'');
               reset (input);
               assign (output,'');
               rewrite (output);
               IOmethod := ANSI;
             end;
    BIOS   : begin
               AssignCRT (output);
               rewrite (output);
               AssignCRT (input);
               reset (input);
               DirectVideo := false;
               IOmethod := BIOS;
             end;
    DIRECT : begin
               AssignCRT (output);
               rewrite (output);
               AssignCRT (input);
               reset (input);
               DirectVideo := true;
               IOmethod := DIRECT;
             end;
  end;
end;

begin
  OutputMethod(ANSI);
End.