unit Fossil;
{ (C) 1987 W. B. Fair, Jr. "All Rights Reserved"

  This Unit provides basic I/O services via a FOSSIL program.
  The FOSSIL is assumed to be previously installed and provides
  a degree of system independence to communications software.

  12/15/87 Initial coding
  }

interface
  uses DOS;
  const
    MaxPort = 2;
  type
    ComPort = (Com_1, Com_2);
  var
    FossilInstalled : boolean;
    FossilMaxFcn    : byte;
    FossilVersion   : byte;
    PortStat        : array[0..MaxPort] of word;

  procedure SystemReboot;
  procedure InitFossil    (port : ComPort);
  procedure UnInitFossil  (port : ComPort);
  procedure SetBaud       (port : ComPort; baud : integer);
  procedure XmitPort      (c : byte; port : ComPort);
  function  RcvPort       (port : ComPort) : byte;
  procedure GetPortStatus (port : ComPort);
  function  PortDataRdy   (port : ComPort) : boolean;
  procedure LowerDTR      (port : ComPort);
  procedure RaiseDTR      (port : ComPort);

implementation

  var
    Regs      : Registers;

  procedure SystemReboot;
  begin
    Regs.AH:= $17;
    Regs.AL:= 0;
    Intr($14, Regs);
  end; {SystemReboot }

  procedure InitFossil(port : ComPort);
  begin
    FossilInstalled:= false;
    Regs.DX:= Ord(port);
    Regs.BX:= 0;
    Regs.CX:= 0;
    Regs.AH:= 4;
    Intr( $14, Regs);
    FossilInstalled:= (Regs.AX = $1954);
    FossilMaxFcn:= Regs.BL;
    FossilVersion:= Regs.BH;
  end; { InitFossil }

  procedure SetBaud(port : ComPort; baud : integer);
  begin
    with Regs do
    case baud of
       300: AL:= $40;
       600: AL:= $60;
      1200: AL:= $80;
      2400: AL:= $A0;
      4800: AL:= $C0;
      9600: AL:= $E0;
     19200: AL:= 0;
      else  AL:= $80;
    end; { case }
    Regs.DX:= Ord(port);
    Regs.AH:= 0;
    Intr($14, Regs);
  end; { SetBaud }

  procedure XmitPort(c : byte; port : ComPort);
  begin
    Regs.DX:= Ord(port);
    Regs.AL:= c;
    Regs.AH:= 1;
    Intr( $14, Regs);
    PortStat[Ord(port)]:= Regs.AX;
  end; { Xmit }

  function RcvPort(port : ComPort) : byte;
  begin
    Regs.DX:= Ord(port);
    Regs.AH:= 2;
    Intr($14, Regs);
    RcvPort:= Regs.AL;
  end; { RcvPort }

  procedure GetPortStatus(port : ComPort);
  begin
    Regs.DX:= Ord(port);
    Regs.AH:= 3;
    Intr($14, Regs);
    PortStat[Ord(port)]:= Regs.AX;
  end; { GetPortStatus }

  function PortDataRdy(port : ComPort) : boolean;
  begin
    GetPortStatus(port);
    PortDataRdy:= ((PortStat[Ord(port)] and $100) <> 0);
  end; { PortDataRdy }

  procedure UnInitFossil(port : ComPort);
  begin
    Regs.DX:= Ord(port);
    Regs.AH:= 5;
    Intr($14, Regs);
    FossilInstalled:= false;
  end; { UnInitFossil }

  procedure RaiseDTR(port : ComPort);
  begin
    Regs.DX:= Ord(port);
    Regs.AL:= 1;
    Regs.AH:= 6;
    Intr($14, Regs);
  end; { RaiseDTR }

  procedure LowerDTR(port : ComPort);
  begin
    Regs.DX:= Ord(port);
    Regs.AL:= 0;
    Regs.AH:= 6;
    Intr($14, Regs);
  end; { LowerDTR }

begin
  { Initialization Code }
  FossilInstalled:= false;
end.                                                 