{$R-,S+,I+,D+,F-,V-,B-,N-,L+ }
{$M $4000,0,0}
PROGRAM where;
  (********************************************************)
  (* Uses SearchEngine to find and display matching files *)
  (* in any subdirectory and total their sizes.  E.g., to *)
  (* find all Pascal files, execute WHERE *.PAS           *)
  (********************************************************)
USES DOS,Engine;

VAR
  template, path : STRING;
  ErrCode        : Byte;
  Total          : LongInt;

  {$F+} PROCEDURE ShowFile(VAR S : SearchRec; path : PathStr); {$F-}
  BEGIN
    WriteLn(path + S.Name);
    Total := Total + S.Size
  END;

  PROCEDURE Validate;
    {Validate the command line parameter}
  VAR P : Byte;
    Ext : ExtStr;
  BEGIN
    IF ParamCount <> 1 THEN
      BEGIN
        WriteLn('SYNTAX:  "WHERE [path]filespec"');
        Halt;
      END;
    FSplit(ParamStr(1), path, template, Ext);
    IF Length(path) = 2 THEN path := path + '\';
    template := template + Ext;
    (*IF no path specified, search from root of
      current volume*)
    IF path = '' THEN
      BEGIN
        GetDir(0, path);
        IF Length(path) = 2 THEN path := path + '\'
        ELSE path[0] := #3;
      END;
  END;

  BEGIN
    Total := 0;
    Validate;
    WriteLn
    ('Searching for "', template, '" in or below "', path, '"');
    SearchEngineAll(path, template, Archive, ShowFile, ErrCode);
    Writeln
    ('These files occupy ',Total : 8,' bytes of disk space.')
  END.
