{$R-,S+,I+,D+,F-,V-,B-,N-,L+ }
{$M 2048,0,0 }
PROGRAM DirSum;
  (********************************************************)
  (*  Uses SearchEngine to write the names of all files   *)
  (*  in the current directory and display the total disk *)
  (*  space that they occupy.                             *)
  (********************************************************)
USES DOS,ENGINE;

VAR
  Template  : PathStr;
  ErrorCode : Byte;
  Total     : LongInt;

{$F+} PROCEDURE WriteIt(VAR S : SearchRec; P : PathStr); {$F-}
BEGIN   WriteLn(S.name); Total := Total + S.Size  END;

BEGIN
  Total := 0;
  GetDir(0, Template);
  IF Length(Template) = 3 THEN Dec(Template[0]);
  {^Avoid ending up with "C:\\*.*"!}
  Template := Template + '\*.*';
  SearchEngine(Template, AnyFile, WriteIt, ErrorCode);
  IF ErrorCode <> 0 THEN ErrorMessage(ErrorCode) ELSE
    Writeln('Total size of displayed files: ',Total : 8);
END.
