{$R-,S+,I+,D+,F-,V-,B-,N-,L+ }
{$M $4000,0,0}
PROGRAM DelBak;

  (********************************************************)
  (* Uses SearchEngine to find and delete all *.BAK files *)
  (* in any subdirectory in the current volume.           *)
  (********************************************************)

USES DOS,Engine;

VAR
  path    : PathStr;
  ErrCode : Byte;
  Number  : Integer;
  Size    : LongInt;

  {$F+} PROCEDURE DelFile(VAR S : SearchRec; path : PathStr); {$F-}
  VAR F : FILE;
  BEGIN
    Inc(Size, S.Size);
    Assign(F, path + S.name);
    Erase(F);
    Inc(Number);
  END;

  PROCEDURE Initialize;
  BEGIN
    Number := 0;
    Size := 0;
    GetDir(0, path);
    IF Length(path) = 2 THEN path := path + '\'
    ELSE path[0] := #3;
    WriteLn('Going to delete ALL *.BAK files in the current volume.');
    WriteLn('Press <Return> to proceed, ^Break to stop.');
    ReadLn;
  END;

  BEGIN
    Initialize;
    SearchEngineAll(path, '*.bak', AnyFile, DelFile, ErrCode);
    WriteLn
    ('Erased ',Number,' *.BAK files for a saving of ',Size,' bytes');
  END.
