{                                            9/2/86
  This code allows you to format numeric I/O in Turbo Pascal.
It is based on a routine I first saw in PC Magazine which I
have modified and added to.  It also uses a routine called,
Strip, which I first saw in the Boosters utilities.  Comma2
allows you to format numeric output as currency, percentages,
or in punctuated form.  Comma2 calls upon the Function 'Strip'
to delete leading and trailing characters from the string sent
to it.  By doing that, Comma2 left justifies the number passed
to it for the display field.
  While I haven't tried it yet, I'm sure Comma2 would make a nice
addition to the Boosters utility library.  I have tried this code
with FastWrite, and it works just fine.
  I have included a short program to demonstrate the Comma2
Function.  If you have any comments or questions, please contact
me, John Wood, on the PC-Library BBS.  The code is as follows: }


Program TestNum;
{$V-}
Type
  Str32  = String[32];
  Str80  = String[80];
  AnyStr = String[255];
Var
  Num    : Real;

Function Strip (Str:AnyStr; Ch:Char) : AnyStr;
   { Removes all leading and trailing C characters from S }
Begin
   InLine ($1E/ $8D/$7E/$07/ $8A/$4E/$06/ $30/$ED/ $8C/$D0/ $8E/$C0/
           $8B/$46/$04/ $83/$F9/$01/ $77/$0E/ $8A/$5E/$07/ $30/$FF/
           $39/$D8/ $74/$35/ $8B/$D7/ $EB/$1D/$90/ $FC/ $F3/$AE/ $E3/$2B/
           $4F/ $8B/$D7/ $8A/$4E/$06/ $30/$ED/ $8D/$7E/$07/ $01/$CF/ $4F/
           $FD/ $F3/$AE/ $47/ $8B/$CF/ $29/$D1/ $41/ $88/$8E/$06/$01/
           $8B/$F2/ $8D/$BE/$07/$01/ $8C/$D0/ $8E/$D8/ $FC/ $F3/$A4/
           $EB/$07/$90/ $C7/$86/$06/$01/$00/$00/ $1F/$5D);
End;

Function Comma2 (Form:Char; Number:Real; Field:Integer; Dec:Integer) : Str32;
Var
  Hold : Str32;
  I    : Integer;
Begin
  Str (Number:Field:Dec, Hold);
  If Dec > 0 Then Dec := Dec + 1;
  For I := 1 to (Field - Dec - 3) do
    If ((Field - Dec - I) Mod 3 = 0) And (Hold[I] <> ' ')
    And (Hold[I] <> '-') Then
    Begin
      Delete (Hold,1,1); Insert (',', Hold, I);
    End;
  Case Form of
    '$' : Comma2:= '$'+ Strip(Hold,' ');
    '#' : Comma2:= Strip(Hold,' ');
    '%' : Comma2:= Strip(Hold,' ')+' %';
  End;
End;

Begin                 { Main Program }
  ClrScr;
  GotoXY(20,5); Write('What is the Number '); Read(Num);
  GotoXY(28,7); Write(Comma2('$',Num,32,2));
  GotoXY(28,8); Write(Comma2('#',Num,32,2));
  GotoXY(28,9); Write(Comma2('%',Num,32,2));
End.

