//
//  BBSAPI.C
//  BBS Applications Programming Interface
//
//  Chris Boaro    10/13/89
//

#define  INCL_DOS
#define  INCL_SUB
#include <os2.h>

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <time.h>

#define EXPAN
#include "os2bbs.h"        /* need the port_rec definition */
#include "bbsapi.h"
#include "bbsutil.h"
#include "bbsglob.h"

//
//  GloProcess()
//
//  Parses and processes a potential global command. If 'cmd'
//  represents a valid global command, the appropriate
//  routines is called and 1 is returned. Otherwise, 0 is
//  returned. If 0 is returned, 'cmd' is a valid command
//  and can be processed normally by the application.
//
DSDLL GloProcess(char *cmd, PORT_REC *unhand)
{
   short r = 0;

   if( (unhand->v_usron >= 2) && (cmd[0] == '/') ) {
      if( strnicmp(&cmd[1],"w",1) == 0 ) {
         GloUsersOn(unhand-(unhand->recnum),unhand);
         r = 1;
      }
      else if( strnicmp(&cmd[1],"p",1) == 0 ) {
         GloPageUser(unhand-(unhand->recnum),unhand);
         r = 1;
      }
      else if( strnicmp(&cmd[1],"t",1) == 0 ) {
         GloTimeLeft(unhand-(unhand->recnum),unhand);
         r = 1;
      }
      else if( strnicmp(&cmd[1],"off",3) == 0 ) {
         GloLogOff(unhand-(unhand->recnum),unhand);
         r = 1;
      }
   }
   return(r);
}

//
//  GloLogOff()
//
//  Log off quickly
//
DSDLL GloLogoff(PORT_REC *bport, PORT_REC *unhand)
{
   unhand->v_usron = 0;
   DosSemClear((void far *) &(unhand->AbortRead) );
   return(1);
}

//
//  GloTimeLeft()
//
//  Prints statistics about time online and time remaining
//
DSDLL GloTimeLeft(PORT_REC *bport, PORT_REC *unhand)
{
   char temp1[30], temp2[30], temp3[10];
   long tm, call, today, tlong;
   short col1 = GREEN;
   short col2 = WHITE;

   time(&tm);
   TimeString(temp1,tm,1);                  // time now
   TimeString(temp2,unhand->t_login,1);  // time logged in
   tlong = (tm - (unhand->t_login)) / 60L;
   ltoa(tlong+1L,temp3,10);                 // minutes on

   call = (((unhand->t_offby - tm) / 60L) + (T_CREDIT/60L) + 1L);
   if( unhand->gis->gisBillCode == 0 )
      today = unhand->p_user->u_time_day - unhand->p_user->u_day_use - ((tm-T_LOGIN)/60L) + (T_CREDIT/60L);
   else
      today = unhand->p_user->u_time_month - unhand->p_user->u_mon_use - ((tm-T_LOGIN)/60L) + (T_CREDIT/60L);
   if( today < 0 ) today = 0;

   SerColorWrite("\n\r         Current Time: ",col1,unhand);
   SerColorWrite(temp1[0] == ' ' ? &temp1[1] : temp1,col2,unhand);
   SerColorWrite("\n\r       Time Logged In: ",col1,unhand);
   SerColorWrite(temp2[0] == ' ' ? &temp2[1] : temp2,col2,unhand);
   SerColorWrite("\n\r       Minutes Online: ",col1,unhand);
   SerColorWrite(temp3,col2,unhand);
   SerColorWrite("\n\r  Time Left This Call: ",col1,unhand);
   SerColorWrite(ltoa(call,temp1,10),col2,unhand);
   if( unhand->gis->gisBillCode == 0 )
      SerColorWrite("\n\r      Time Left Today: ",col1,unhand);
   else
      SerColorWrite("\n\r Time Left This Month: ",col1,unhand);
   SerColorWrite(ltoa(today,temp2,10),col2,unhand);
   SerColorWrite("\n\r",CREGCOL,unhand);
   return(1);
}

//
//  GloPageUser()
//
//  Sends a page to a user
//
DSDLL GloPageUser(PORT_REC *bport, PORT_REC *unhand)
{
   char name[30], pg[PGSIZE];
   short lnum, rc;

   while( LOGGED_IN ) {
      SerPrompt("\n\rUser to Page: ",BRGREEN,unhand);
      COLOR(CREGCOL);
      if( SerGetCmd(name,12,unhand) >= 0 ) 
         break;
   }
   if( LOGGED_IN && ((lnum=UseLocateClosest(name,bport)) == -1) ) {
      sprintf(pg,"\n\r{%s} is not currently logged in!\n\r",name);
      SerMultiColWrite(pg,'{','}',BRYELLOW,BRWHITE,unhand);
      if( CMDWAIT )
         SerGetStr(pg,PGSIZE-5,unhand);       // read waiting but bogus command
   }
   else {
      while( LOGGED_IN ) {
         SerPrompt("\n\rEnter Message: ",BRGREEN,unhand);
         COLOR(CREGCOL);
         if( SerGetStr(pg,PGSIZE-1,unhand) >= 0 )
            break;
      }
      if( LOGGED_IN && pg[0] ) {
         rc = UseAddPage(pg,lnum,PAGE_REGULAR,unhand,bport);
         if( rc == PERR_OK ) {
            sprintf(pg,"\n\rPage sent to {%s} on line {%d\n\r",(bport+lnum)->p_user->u_handle,lnum);
         }
         else {
            switch( rc ) {
               case PERR_FULL:
                  sprintf(pg,"\n\r{%s} can not receive pages right now, try again shortly\n\r",(bport+lnum)->p_user->u_handle);
                  break;
               case PERR_FORGET:
                  sprintf(pg,"\n\r{%s} has chosen to forget you\n\r",(bport+lnum)->p_user->u_handle);
                  break;
               default:
                  strcpy(pg,"\n\rYour page could not be sent\n\r");
                  break;
            }
         }
         SerMultiColWrite(pg,'{','}',BRWHITE,BRMAGENTA,unhand);
      }
   }
   return(1);
}



//
//  GloUsersOn()
//
//  Displays the users currently logged on
//
//
DSDLL GloUsersOn(PORT_REC *bport, PORT_REC *unhand)
{
   short i, on=0;
   short newuser = 0;
   char dstr[20], citystate[60];
   char *str;
   char flag;

   if( (str=malloc(512)) == NULL )
      return(0);
   for(i=0;i<(unhand->gis->gisMaxusers);i++) {
      if( ((bport+i)->inviso != 2) && ((bport+i)->v_usron == 2) && ( (bport+i)->inviso == 0 || P_USER->u_access == GODLEVEL ) ) {
         if( (bport+i)->p_user->u_access < bport->gis->gisVerLevel ) 
            newuser = 1;
         else
            newuser = 0;
         if( !on ) {
            COLOR(BRWHITE);
            SerWrite("\n\rUsers Online:\n\r",unhand);
            COLOR(BRGREEN);
            SerWrite("\n\rLine  User           Location         Calling From            Age S  Log on",unhand);
            COLOR(BRBLUE);
            SerWrite("\n\r----  -------------  ---------------  ----------------------  --- -  -------\n\r",unhand);
            COLOR(BRWHITE);
         }
         on++;
         TimeString(dstr,(bport+i)->t_login,1);
         strcpy(citystate,(bport+i)->p_user->u_city);
         strcat(citystate,", ");
         if( (bport+i)->p_user->u_country[0] )
            strcat(citystate,(bport+i)->p_user->u_country);
         else
            strcat(citystate,(bport+i)->p_user->u_state);

         if( (bport+i)->inviso )
            flag = 'i';
         else if( (bport+i)->sysopflag )
            flag = '!';
         else if( Forgotten(i,unhand) )
            flag = 'f';
         else if( newuser && unhand->p_user->u_access == GODLEVEL )
            flag = 'n';
         else 
            flag = ' ';

         if( newuser && unhand->p_user->u_access != GODLEVEL )
            sprintf(str," %2d   -Newuser-\n\r",i);
         else
            sprintf(str," %2d   %-12.12s %c %-15.15s  %-22.22s  %3d %c  %s\n\r",i,(bport+i)->p_user->u_handle,flag,(bport+i)->locstr,citystate,
                   (bport+i)->p_user->u_age,(bport+i)->p_user->u_sex ? 'M' : 'F',dstr);

         SerWrite(str,unhand);
      } /* if user logged on */
   } /* for */
   if( on == 0 )         // only hapens when all users on are invisable
      SerColorWrite("\n\rSorry, there are no users logged in right now\n\r",BRYELLOW,unhand);
   free(str);
   COLOR(CREGCOL);
   return(1);
}

