////////////////////////////////////////////////////////////////////////////
//
//   Omega Point/2 Bulletin Board System
//   Copyright (c) ExcelSoft Software, 1990
//   Version 1.0, cab, 21-Feb-90
//   
//   This file may be freely modified for you own use.
//
//   Data and structures needed to write expansion programs for the
//   OP/2 BBS system under OS/2. 
// 
//   Any module that makes use the IO routines will need to include
//   this file. If you have the OS/2 Toolkit, include include the file
//   OS2.H before this one. 
// 
//   See EXPAND.C and EXPAND.MAK for sample code and make file.
//
//////////////////////////////////////////////////////////////////////////

#ifndef _BBSEXPAN_H
#define _BBSEXPAN_H

//
//  These typedefs and defines will be used if the file OS2.H hasn't
//  been included. This will allow you to write extension programs 
//  without having the OS/2 Toolkit. (note that Microsoft C 6.0
//  comes with all the needed OS/2 include files)
//  

#ifndef OS2_INCLUDED
   #define PASCAL        pascal
   #define FAR           far
   #define NEAR          near
   #define VOID          void
   typedef unsigned short USHORT;
   typedef unsigned long  ULONG;
   typedef unsigned char  BYTE;
   typedef void (pascal far *PFNEXITLIST)(USHORT);
#endif

//
//  Make variables extenal except to one module
//
#ifndef MAINMODULE                       // check if this is THE main module
  #define BBSEXTERN extern
#else
  #define BBSEXTERN
#endif

//
//  Include these files unless otherwise specified
//
#ifndef NO_INCL_BBS
   #ifndef EXPAN
      #define EXPAN
   #endif
   #include "os2bbs.h"
   #include "bbsapi.h"
#endif

BBSEXTERN PORT_REC        *anchor,       // pointer to start of control segment
                          *unhand;       // pointer to control segment for calling user
BBSEXTERN int             usernum,       // user number of calling user
                          instance;      // instance of OP/2 BBS running
BBSEXTERN void far        *semhand;      // system semaphore to signal program end

//  
//  Prototypes
//
int    SerWritef(PORT_REC *, char *, ...);
int    UseChildAppInit(char *, char *, PORT_REC **, PORT_REC **, void far **, int *, int *);
PFNEXITLIST  CleanExit(USHORT);

#endif

