#define INCL_DOS
#include <os2.h>

#include <stdio.h>
#include <process.h>

#include "bbsexpan.h"


#define PIPESIZE   128
#define LENGTH     30
#define FLAGS      1
#define ARGS       0L
#define ENVS       0L
#define STDIN      0
#define STDOUT     1
#define STSZ       4096
#define BUFFSIZE   512

USHORT ReadHandle, WriteHandle, NewStdout, childID;
USHORT NewStdin, Read2, Write2;


unsigned long BuffAdd=0;           // semaphore for adding to buffer
char threadstk[STSZ], theadstk2[STSZ];
void ReadPipe(void far *);
void WritePipe(void far *);


main(int argc, char *argv[])
{
   char tbuf[BUFFSIZE+2], *p;
   char fbuf[LENGTH];
   char ar[128];
   struct _RESULTCODES ExResult, CwResult;
   USHORT HandState, procID;
   USHORT Strlen, Written;
   int j, c;
   short arg;
   short lcountsave;
   short inputflag=0;
   unsigned rc, rc2;
   FILE *err;

   arg = 2;
   while( argv[arg][0] == '-' ) {
      switch(argv[arg][1]) {
         case 'i':
            inputflag = 1;
            break;
      }
      arg++;
   }

   rc = UseChildAppInit(argv[1],argv[0],&anchor,&unhand,&semhand,&usernum,&instance);
   if( rc != 0 ) {
      printf("\nCould not initialize application (%d)\n",rc);
      goto END_APP;
   }

   rc = DosMakePipe(&ReadHandle, &WriteHandle, PIPESIZE);
   if( rc )
      goto END_APP;

   rc = DosMakePipe(&Read2, &Write2, 1);
   if( rc ) 
      goto END_APP;

   DosClose(STDIN);
   DosClose(STDOUT);
   NewStdout = STDOUT;
   NewStdin = STDIN;

   DosDupHandle(WriteHandle,&NewStdout);
   DosDupHandle(Read2,&NewStdin);

   DosQFHandState(Write2,&HandState);
   HandState &= 0x7F88;
   HandState |= 0x0080;
   DosSetFHandState(Write2,HandState);

   DosQFHandState(ReadHandle,&HandState);
   HandState &= 0x7F88;
   HandState |= 0x0080;
   DosSetFHandState(ReadHandle,HandState);

   COLOR(BRCYAN);

   if( CMDWAIT )
      SerGetStr(ar,127,unhand);
   else
      ar[0] = '\0';
   lcountsave = unhand->lcounton;
   if( rc=DosExecPgm(fbuf,LENGTH,FLAGS,ar,ENVS,&ExResult,argv[arg]) ) {
      printf("\nError in DosExecPgm: %u %s\n",rc,fbuf);
      goto END_APP;
   }

   rc = _beginthread(ReadPipe,(void far *)threadstk,STSZ, NULL);
   if( rc == -1 ) {
      printf("\nError: Could not begin thread\n");
      goto END_APP;
   }

   if( inputflag ) {
      unhand->lcounton = 0;
      rc2 = _beginthread(WritePipe,(void far *)theadstk2,STSZ,NULL);
      if( rc == -1 ) {
         printf("\nError: Could not begin thread\n");
         goto END_APP;
      }
   }

   DosSleep(1000L);

   childID = ExResult.codeTerminate;
   DosCwait(1,0,&CwResult,&procID,childID);

   DosClose(Read2);
   DosClose(Write2);
   DosClose(ReadHandle);
   DosClose(WriteHandle);

   ///////////////////////////////////// Need this to clean up
END_APP:
   unhand->lcounton = lcountsave;
   DosExit(1,1);
}


void WritePipe(void far *arg)
{
   short c, ch;
   USHORT written;

   while(1) {
      c = SerReadc(unhand);
      ch = c;
      DosWrite(Write2,&ch,1,&written);
      if( ch == 13 ) {
         ch = 10;
         DosWrite(Write2,&ch,1,&written);
      }
   }
   return;
}


void ReadPipe(void far *arg)
{
   USHORT Read, done = 0;
   unsigned char   st[PIPESIZE+10];

   while(!done) {
      DosRead(ReadHandle,st,PIPESIZE,&Read);
      DosSemRequest(&BuffAdd,-1L);
      if( Read ) {
         st[Read] = '\0';
         if( !SerWrite(st,unhand) ) {
            DosKillProcess(0,childID);
            SerWrite("\n",unhand);
            done = 1;
         }
      }
      DosSemClear(&BuffAdd);
   }
   return;
}



