//
//   OP/2 BBS - Copyright (c) 1990 ExcelSoft Software. All rights reserved.
//
//   OS2LED.H
//
//   Header file for OP/2 Line Editor Functions
//
//    9oct89   cab   Initial Coding
//    6mar90   cab   Updated for new format
//    20sep90  cab   Added function to free txtbuff memory
//

#ifndef _OS2LED_H
#define _OS2LED_H

#define  MAXCOL         70
#define  NO_COMMAND     0

// typedefs
typedef struct lntype {
   short  len;                    // length of line 
   char   ltxt[MAXCOL+4];         // line text.. little extra padding 
   struct lntype *nextl;          // pointer to next line             
} LNTYPE;                         // line type

// entry point prototypes
short APIENTRY _loadds FileToLntype(LNTYPE **, char *, int, int, int, int *, int *);
short APIENTRY _loadds FreeLntype(LNTYPE *);
short APIENTRY _loadds LineEdit(LNTYPE **, int, PORT_REC *);
short APIENTRY _loadds LnEdit(LNTYPE **, LNTYPE *, int, int, int *, PORT_REC *);
short APIENTRY _loadds LntypeToTxt(int *, int *, LNTYPE *, char **);
short APIENTRY         FreeTxtBuff(char *);

#endif
